/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.util;

import org.apache.cassandra.cache.ChunkCache;
import org.apache.cassandra.io.compress.BufferType;
import org.apache.cassandra.io.util.ChannelProxy;
import org.apache.cassandra.io.util.RebuffererFactory;
import org.apache.cassandra.io.util.SegmentedFile;
import org.apache.cassandra.io.util.SimpleChunkReader;

public class BufferedSegmentedFile
extends SegmentedFile {
    public BufferedSegmentedFile(ChannelProxy channel, int bufferSize, long length) {
        this(channel, BufferedSegmentedFile.createRebufferer(channel, length, bufferSize), length);
    }

    private BufferedSegmentedFile(ChannelProxy channel, RebuffererFactory rebufferer, long length) {
        super(new SegmentedFile.Cleanup(channel, rebufferer), channel, rebufferer, length);
    }

    private BufferedSegmentedFile(BufferedSegmentedFile copy) {
        super(copy);
    }

    private static RebuffererFactory createRebufferer(ChannelProxy channel, long length, int bufferSize) {
        return ChunkCache.maybeWrap(new SimpleChunkReader(channel, length, BufferType.OFF_HEAP, bufferSize));
    }

    @Override
    public BufferedSegmentedFile sharedCopy() {
        return new BufferedSegmentedFile(this);
    }

    public static class Builder
    extends SegmentedFile.Builder {
        @Override
        public SegmentedFile complete(ChannelProxy channel, int bufferSize, long overrideLength) {
            long length = overrideLength > 0L ? overrideLength : channel.size();
            return new BufferedSegmentedFile(channel, bufferSize, length);
        }
    }
}

