/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.index.sasi.plan;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.PartitionPosition;
import org.apache.cassandra.db.PartitionRangeReadCommand;
import org.apache.cassandra.db.ReadCommand;
import org.apache.cassandra.db.ReadExecutionController;
import org.apache.cassandra.db.filter.RowFilter;
import org.apache.cassandra.db.partitions.UnfilteredPartitionIterator;
import org.apache.cassandra.db.rows.AbstractUnfilteredRowIterator;
import org.apache.cassandra.db.rows.Row;
import org.apache.cassandra.db.rows.Unfiltered;
import org.apache.cassandra.db.rows.UnfilteredRowIterator;
import org.apache.cassandra.dht.AbstractBounds;
import org.apache.cassandra.exceptions.RequestTimeoutException;
import org.apache.cassandra.index.sasi.disk.Token;
import org.apache.cassandra.index.sasi.plan.Operation;
import org.apache.cassandra.index.sasi.plan.QueryController;
import org.apache.cassandra.io.util.FileUtils;
import org.apache.cassandra.utils.AbstractIterator;

public class QueryPlan {
    private final QueryController controller;

    public QueryPlan(ColumnFamilyStore cfs, ReadCommand command, long executionQuotaMs) {
        this.controller = new QueryController(cfs, (PartitionRangeReadCommand)command, executionQuotaMs);
    }

    private Operation analyze() {
        try {
            Operation.Builder and = new Operation.Builder(Operation.OperationType.AND, this.controller, new RowFilter.Expression[0]);
            this.controller.getExpressions().forEach(and::add);
            return and.complete();
        }
        catch (Error | Exception e) {
            this.controller.finish();
            throw e;
        }
    }

    public UnfilteredPartitionIterator execute(ReadExecutionController executionController) throws RequestTimeoutException {
        return new ResultIterator(this.analyze(), this.controller, executionController);
    }

    private static class ResultIterator
    extends AbstractIterator<UnfilteredRowIterator>
    implements UnfilteredPartitionIterator {
        private final AbstractBounds<PartitionPosition> keyRange;
        private final Operation operationTree;
        private final QueryController controller;
        private final ReadExecutionController executionController;
        private Iterator<DecoratedKey> currentKeys = null;

        public ResultIterator(Operation operationTree, QueryController controller, ReadExecutionController executionController) {
            this.keyRange = controller.dataRange().keyRange();
            this.operationTree = operationTree;
            this.controller = controller;
            this.executionController = executionController;
            if (operationTree != null) {
                operationTree.skipTo((Long)((PartitionPosition)this.keyRange.left).getToken().getTokenValue());
            }
        }

        @Override
        protected UnfilteredRowIterator computeNext() {
            if (this.operationTree == null) {
                return (UnfilteredRowIterator)this.endOfData();
            }
            block11: while (true) {
                if (this.currentKeys == null || !this.currentKeys.hasNext()) {
                    if (!this.operationTree.hasNext()) {
                        return (UnfilteredRowIterator)this.endOfData();
                    }
                    Token token = (Token)this.operationTree.next();
                    this.currentKeys = token.iterator();
                }
                while (true) {
                    if (!this.currentKeys.hasNext()) continue block11;
                    DecoratedKey key = this.currentKeys.next();
                    if (!((PartitionPosition)this.keyRange.right).isMinimum() && ((PartitionPosition)this.keyRange.right).compareTo(key) < 0) {
                        return (UnfilteredRowIterator)this.endOfData();
                    }
                    UnfilteredRowIterator partition = this.controller.getPartition(key, this.executionController);
                    Throwable throwable = null;
                    try {
                        Row staticRow = partition.staticRow();
                        ArrayList<Unfiltered> clusters = new ArrayList<Unfiltered>();
                        while (partition.hasNext()) {
                            Unfiltered row = (Unfiltered)partition.next();
                            if (!this.operationTree.satisfiedBy(row, staticRow, true)) continue;
                            clusters.add(row);
                        }
                        if (clusters.isEmpty()) continue;
                        PartitionIterator partitionIterator = new PartitionIterator(partition, clusters);
                        return partitionIterator;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (partition == null) continue;
                        if (throwable != null) {
                            try {
                                partition.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        partition.close();
                        continue;
                    }
                    break;
                }
                break;
            }
        }

        @Override
        public boolean isForThrift() {
            return this.controller.isForThrift();
        }

        @Override
        public CFMetaData metadata() {
            return this.controller.metadata();
        }

        @Override
        public void close() {
            FileUtils.closeQuietly(this.operationTree);
            this.controller.finish();
        }

        private static class PartitionIterator
        extends AbstractUnfilteredRowIterator {
            private final Iterator<Unfiltered> rows;

            public PartitionIterator(UnfilteredRowIterator partition, Collection<Unfiltered> content) {
                super(partition.metadata(), partition.partitionKey(), partition.partitionLevelDeletion(), partition.columns(), partition.staticRow(), partition.isReverseOrder(), partition.stats());
                this.rows = content.iterator();
            }

            @Override
            protected Unfiltered computeNext() {
                return this.rows.hasNext() ? this.rows.next() : (Unfiltered)this.endOfData();
            }
        }
    }
}

