/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.view;

import com.google.common.util.concurrent.Striped;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.Lock;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.config.ViewDefinition;
import org.apache.cassandra.db.IMutation;
import org.apache.cassandra.db.Keyspace;
import org.apache.cassandra.db.SystemKeyspace;
import org.apache.cassandra.db.partitions.PartitionUpdate;
import org.apache.cassandra.db.view.TableViews;
import org.apache.cassandra.db.view.View;
import org.apache.cassandra.repair.SystemDistributedKeyspace;
import org.apache.cassandra.service.StorageService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ViewManager {
    private static final Logger logger = LoggerFactory.getLogger(ViewManager.class);
    private static final Striped<Lock> LOCKS = Striped.lazyWeakLock((int)(DatabaseDescriptor.getConcurrentViewWriters() * 1024));
    private static final boolean enableCoordinatorBatchlog = Boolean.getBoolean("cassandra.mv_enable_coordinator_batchlog");
    private final ConcurrentMap<String, View> viewsByName = new ConcurrentHashMap<String, View>();
    private final ConcurrentMap<UUID, TableViews> viewsByBaseTable = new ConcurrentHashMap<UUID, TableViews>();
    private final Keyspace keyspace;

    public ViewManager(Keyspace keyspace) {
        this.keyspace = keyspace;
    }

    public boolean updatesAffectView(Collection<? extends IMutation> mutations, boolean coordinatorBatchlog) {
        if (coordinatorBatchlog && !enableCoordinatorBatchlog) {
            return false;
        }
        for (IMutation iMutation : mutations) {
            for (PartitionUpdate update : iMutation.getPartitionUpdates()) {
                assert (this.keyspace.getName().equals(update.metadata().ksName));
                if (coordinatorBatchlog && this.keyspace.getReplicationStrategy().getReplicationFactor() == 1 || this.forTable(update.metadata()).updatedViews(update).isEmpty()) continue;
                return true;
            }
        }
        return false;
    }

    private Iterable<View> allViews() {
        return this.viewsByName.values();
    }

    public void update(String viewName) {
        View view = (View)this.viewsByName.get(viewName);
        assert (view != null) : "When updating a view, it should already be in the ViewManager";
        view.build();
        Optional<ViewDefinition> viewDefinition = this.keyspace.getMetadata().views.get(viewName);
        assert (viewDefinition.isPresent()) : "When updating a view, it should still be in the Keyspaces views";
        view.updateDefinition(viewDefinition.get());
    }

    public void reload() {
        HashMap<String, ViewDefinition> newViewsByName = new HashMap<String, ViewDefinition>();
        for (ViewDefinition viewDefinition : this.keyspace.getMetadata().views) {
            newViewsByName.put(viewDefinition.viewName, viewDefinition);
        }
        for (String string : this.viewsByName.keySet()) {
            if (newViewsByName.containsKey(string)) continue;
            this.removeView(string);
        }
        for (Map.Entry entry : newViewsByName.entrySet()) {
            if (this.viewsByName.containsKey(entry.getKey())) continue;
            this.addView((ViewDefinition)entry.getValue());
        }
        if (!StorageService.instance.isInitialized()) {
            logger.info("Not submitting build tasks for views in keyspace {} as storage service is not initialized", (Object)this.keyspace.getName());
            return;
        }
        for (View view : this.allViews()) {
            view.build();
            view.updateDefinition((ViewDefinition)newViewsByName.get(view.name));
        }
    }

    public void addView(ViewDefinition definition) {
        View view = new View(definition, this.keyspace.getColumnFamilyStore(definition.baseTableId));
        this.forTable(view.getDefinition().baseTableMetadata()).add(view);
        this.viewsByName.put(definition.viewName, view);
    }

    public void removeView(String name) {
        View view = (View)this.viewsByName.remove(name);
        if (view == null) {
            return;
        }
        this.forTable(view.getDefinition().baseTableMetadata()).removeByName(name);
        SystemKeyspace.setViewRemoved(this.keyspace.getName(), view.name);
        SystemDistributedKeyspace.setViewRemoved(this.keyspace.getName(), view.name);
    }

    public void buildAllViews() {
        for (View view : this.allViews()) {
            view.build();
        }
    }

    public TableViews forTable(CFMetaData metadata) {
        TableViews previous;
        UUID baseId = metadata.cfId;
        TableViews views = (TableViews)this.viewsByBaseTable.get(baseId);
        if (views == null && (previous = this.viewsByBaseTable.putIfAbsent(baseId, views = new TableViews(metadata))) != null) {
            views = previous;
        }
        return views;
    }

    public static Lock acquireLockFor(int keyAndCfidHash) {
        Lock lock = (Lock)LOCKS.get((Object)keyAndCfidHash);
        if (lock.tryLock()) {
            return lock;
        }
        return null;
    }
}

