/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.filter;

import com.google.common.collect.SortedSetMultimap;
import com.google.common.collect.TreeMultimap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.SortedSet;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.ColumnDefinition;
import org.apache.cassandra.cql3.ColumnIdentifier;
import org.apache.cassandra.db.Columns;
import org.apache.cassandra.db.PartitionColumns;
import org.apache.cassandra.db.TypeSizes;
import org.apache.cassandra.db.filter.ColumnSubselection;
import org.apache.cassandra.db.rows.CellPath;
import org.apache.cassandra.io.util.DataInputPlus;
import org.apache.cassandra.io.util.DataOutputPlus;

public class ColumnFilter {
    public static final Serializer serializer = new Serializer();
    private final boolean isFetchAll;
    private final CFMetaData metadata;
    private final PartitionColumns queried;
    private final SortedSetMultimap<ColumnIdentifier, ColumnSubselection> subSelections;

    private ColumnFilter(boolean isFetchAll, CFMetaData metadata, PartitionColumns queried, SortedSetMultimap<ColumnIdentifier, ColumnSubselection> subSelections) {
        assert (!isFetchAll || metadata != null);
        assert (isFetchAll || queried != null);
        this.isFetchAll = isFetchAll;
        this.metadata = metadata;
        this.queried = queried;
        this.subSelections = subSelections;
    }

    public static ColumnFilter all(CFMetaData metadata) {
        return new ColumnFilter(true, metadata, null, null);
    }

    public static ColumnFilter selection(PartitionColumns columns) {
        return new ColumnFilter(false, null, columns, null);
    }

    public PartitionColumns fetchedColumns() {
        return this.isFetchAll ? this.metadata.partitionColumns() : this.queried;
    }

    public PartitionColumns queriedColumns() {
        assert (this.queried != null || this.isFetchAll);
        return this.queried == null ? this.metadata.partitionColumns() : this.queried;
    }

    public boolean fetchesAllColumns() {
        return this.isFetchAll;
    }

    public boolean allFetchedColumnsAreQueried() {
        return !this.isFetchAll || this.queried == null && this.subSelections == null;
    }

    public boolean fetches(ColumnDefinition column) {
        return this.isFetchAll || this.queried.contains(column);
    }

    public boolean fetchedColumnIsQueried(ColumnDefinition column) {
        return !this.isFetchAll || this.queried == null || this.queried.contains(column);
    }

    public boolean fetchedCellIsQueried(ColumnDefinition column, CellPath path) {
        assert (path != null);
        if (!this.isFetchAll || this.subSelections == null) {
            return true;
        }
        SortedSet s = this.subSelections.get((Object)column.name);
        if (s.isEmpty()) {
            return true;
        }
        for (ColumnSubselection subSel : s) {
            if (subSel.compareInclusionOf(path) != 0) continue;
            return true;
        }
        return false;
    }

    public Tester newTester(ColumnDefinition column) {
        if (this.subSelections == null || !column.isComplex()) {
            return null;
        }
        SortedSet s = this.subSelections.get((Object)column.name);
        if (s.isEmpty()) {
            return null;
        }
        return new Tester(this.isFetchAll, s.iterator());
    }

    public static Builder allColumnsBuilder(CFMetaData metadata) {
        return new Builder(metadata);
    }

    public static Builder selectionBuilder() {
        return new Builder(null);
    }

    public String toString() {
        if (this.isFetchAll) {
            return "*";
        }
        if (this.queried.isEmpty()) {
            return "";
        }
        Iterator<ColumnDefinition> defs = this.queried.selectOrderIterator();
        if (!defs.hasNext()) {
            return "<none>";
        }
        StringBuilder sb = new StringBuilder();
        while (defs.hasNext()) {
            this.appendColumnDef(sb, defs.next());
            if (!defs.hasNext()) continue;
            sb.append(", ");
        }
        return sb.toString();
    }

    private void appendColumnDef(StringBuilder sb, ColumnDefinition column) {
        if (this.subSelections == null) {
            sb.append(column.name);
            return;
        }
        SortedSet s = this.subSelections.get((Object)column.name);
        if (s.isEmpty()) {
            sb.append(column.name);
            return;
        }
        int i = 0;
        for (ColumnSubselection subSel : s) {
            sb.append(i++ == 0 ? "" : ", ").append(column.name).append(subSel);
        }
    }

    public static class Serializer {
        private static final int IS_FETCH_ALL_MASK = 1;
        private static final int HAS_QUERIED_MASK = 2;
        private static final int HAS_SUB_SELECTIONS_MASK = 4;

        private static int makeHeaderByte(ColumnFilter selection) {
            return (selection.isFetchAll ? 1 : 0) | (selection.queried != null ? 2 : 0) | (selection.subSelections != null ? 4 : 0);
        }

        public void serialize(ColumnFilter selection, DataOutputPlus out, int version) throws IOException {
            out.writeByte(Serializer.makeHeaderByte(selection));
            if (selection.queried != null) {
                Columns.serializer.serialize(((ColumnFilter)selection).queried.statics, out);
                Columns.serializer.serialize(((ColumnFilter)selection).queried.regulars, out);
            }
            if (selection.subSelections != null) {
                out.writeUnsignedVInt(selection.subSelections.size());
                for (ColumnSubselection subSel : selection.subSelections.values()) {
                    ColumnSubselection.serializer.serialize(subSel, out, version);
                }
            }
        }

        public ColumnFilter deserialize(DataInputPlus in, int version, CFMetaData metadata) throws IOException {
            int header = in.readUnsignedByte();
            boolean isFetchAll = (header & 1) != 0;
            boolean hasQueried = (header & 2) != 0;
            boolean hasSubSelections = (header & 4) != 0;
            PartitionColumns queried = null;
            if (hasQueried) {
                Columns statics = Columns.serializer.deserialize(in, metadata);
                Columns regulars = Columns.serializer.deserialize(in, metadata);
                queried = new PartitionColumns(statics, regulars);
            }
            TreeMultimap subSelections = null;
            if (hasSubSelections) {
                subSelections = TreeMultimap.create(Comparator.naturalOrder(), Comparator.naturalOrder());
                int size = (int)in.readUnsignedVInt();
                for (int i = 0; i < size; ++i) {
                    ColumnSubselection subSel = ColumnSubselection.serializer.deserialize(in, version, metadata);
                    subSelections.put((Object)subSel.column().name, (Object)subSel);
                }
            }
            return new ColumnFilter(isFetchAll, isFetchAll ? metadata : null, queried, (SortedSetMultimap)subSelections);
        }

        public long serializedSize(ColumnFilter selection, int version) {
            long size = 1L;
            if (selection.queried != null) {
                size += Columns.serializer.serializedSize(((ColumnFilter)selection).queried.statics);
                size += Columns.serializer.serializedSize(((ColumnFilter)selection).queried.regulars);
            }
            if (selection.subSelections != null) {
                size += (long)TypeSizes.sizeofUnsignedVInt(selection.subSelections.size());
                for (ColumnSubselection subSel : selection.subSelections.values()) {
                    size += ColumnSubselection.serializer.serializedSize(subSel, version);
                }
            }
            return size;
        }
    }

    public static class Builder {
        private final CFMetaData metadata;
        private PartitionColumns.Builder queriedBuilder;
        private List<ColumnSubselection> subSelections;

        private Builder(CFMetaData metadata) {
            this.metadata = metadata;
        }

        public Builder add(ColumnDefinition c) {
            if (this.queriedBuilder == null) {
                this.queriedBuilder = PartitionColumns.builder();
            }
            this.queriedBuilder.add(c);
            return this;
        }

        public Builder addAll(Iterable<ColumnDefinition> columns) {
            if (this.queriedBuilder == null) {
                this.queriedBuilder = PartitionColumns.builder();
            }
            this.queriedBuilder.addAll(columns);
            return this;
        }

        private Builder addSubSelection(ColumnSubselection subSelection) {
            this.add(subSelection.column());
            if (this.subSelections == null) {
                this.subSelections = new ArrayList<ColumnSubselection>();
            }
            this.subSelections.add(subSelection);
            return this;
        }

        public Builder slice(ColumnDefinition c, CellPath from, CellPath to) {
            return this.addSubSelection(ColumnSubselection.slice(c, from, to));
        }

        public Builder select(ColumnDefinition c, CellPath elt) {
            return this.addSubSelection(ColumnSubselection.element(c, elt));
        }

        public ColumnFilter build() {
            PartitionColumns queried;
            boolean isFetchAll = this.metadata != null;
            PartitionColumns partitionColumns = queried = this.queriedBuilder == null ? null : this.queriedBuilder.build();
            if (!isFetchAll && queried == null) {
                queried = PartitionColumns.NONE;
            }
            TreeMultimap s = null;
            if (this.subSelections != null) {
                s = TreeMultimap.create(Comparator.naturalOrder(), Comparator.naturalOrder());
                for (ColumnSubselection subSelection : this.subSelections) {
                    s.put((Object)subSelection.column().name, (Object)subSelection);
                }
            }
            return new ColumnFilter(isFetchAll, this.metadata, queried, (SortedSetMultimap)s);
        }
    }

    public static class Tester {
        private final boolean isFetchAll;
        private ColumnSubselection current;
        private final Iterator<ColumnSubselection> iterator;

        private Tester(boolean isFetchAll, Iterator<ColumnSubselection> iterator) {
            this.isFetchAll = isFetchAll;
            this.iterator = iterator;
        }

        public boolean fetches(CellPath path) {
            return this.isFetchAll || this.hasSubselection(path);
        }

        public boolean fetchedCellIsQueried(CellPath path) {
            return !this.isFetchAll || this.hasSubselection(path);
        }

        private boolean hasSubselection(CellPath path) {
            while (this.current != null || this.iterator.hasNext()) {
                int cmp;
                if (this.current == null) {
                    this.current = this.iterator.next();
                }
                if ((cmp = this.current.compareInclusionOf(path)) == 0) {
                    return true;
                }
                if (cmp < 0) {
                    return false;
                }
                this.current = null;
            }
            return false;
        }
    }
}

