/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.functions;

import com.datastax.driver.core.TypeCodec;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.io.ByteStreams;
import com.google.common.reflect.TypeToken;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.nio.ByteBuffer;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.security.ProtectionDomain;
import java.security.SecureClassLoader;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;
import org.apache.cassandra.concurrent.NamedThreadFactory;
import org.apache.cassandra.cql3.ColumnIdentifier;
import org.apache.cassandra.cql3.functions.FunctionName;
import org.apache.cassandra.cql3.functions.JavaUDF;
import org.apache.cassandra.cql3.functions.SecurityThreadGroup;
import org.apache.cassandra.cql3.functions.ThreadAwareSecurityManager;
import org.apache.cassandra.cql3.functions.UDFByteCodeVerifier;
import org.apache.cassandra.cql3.functions.UDFContext;
import org.apache.cassandra.cql3.functions.UDFExecutorService;
import org.apache.cassandra.cql3.functions.UDFunction;
import org.apache.cassandra.cql3.functions.UDHelper;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.utils.FBUtilities;
import org.eclipse.jdt.core.compiler.CategorizedProblem;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.internal.compiler.ClassFile;
import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.Compiler;
import org.eclipse.jdt.internal.compiler.DefaultErrorHandlingPolicies;
import org.eclipse.jdt.internal.compiler.ICompilerRequestor;
import org.eclipse.jdt.internal.compiler.IErrorHandlingPolicy;
import org.eclipse.jdt.internal.compiler.IProblemFactory;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFileReader;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFormatException;
import org.eclipse.jdt.internal.compiler.env.IBinaryType;
import org.eclipse.jdt.internal.compiler.env.ICompilationUnit;
import org.eclipse.jdt.internal.compiler.env.INameEnvironment;
import org.eclipse.jdt.internal.compiler.env.NameEnvironmentAnswer;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.problem.DefaultProblemFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JavaBasedUDFunction
extends UDFunction {
    private static final String BASE_PACKAGE = "org.apache.cassandra.cql3.udf.gen";
    private static final Pattern JAVA_LANG_PREFIX;
    static final Logger logger;
    private static final AtomicInteger classSequence;
    private static final UDFExecutorService executor;
    private static final EcjTargetClassLoader targetClassLoader;
    private static final UDFByteCodeVerifier udfByteCodeVerifier;
    private static final ProtectionDomain protectionDomain;
    private static final IErrorHandlingPolicy errorHandlingPolicy;
    private static final IProblemFactory problemFactory;
    private static final CompilerOptions compilerOptions;
    private static final String[] javaSourceTemplate;
    private final JavaUDF javaUDF;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    JavaBasedUDFunction(FunctionName name, List<ColumnIdentifier> argNames, List<AbstractType<?>> argTypes, AbstractType<?> returnType, boolean calledOnNullInput, String body) {
        super(name, argNames, argTypes, UDHelper.driverTypes(argTypes), returnType, UDHelper.driverType(returnType), calledOnNullInput, "java", body);
        TypeToken<?>[] javaParamTypes = UDHelper.typeTokens(this.argCodecs, calledOnNullInput);
        TypeToken javaReturnType = this.returnCodec.getJavaType();
        String pkgName = "org.apache.cassandra.cql3.udf.gen." + JavaBasedUDFunction.generateClassName(name, 'p');
        String clsName = JavaBasedUDFunction.generateClassName(name, 'C');
        String executeInternalName = JavaBasedUDFunction.generateClassName(name, 'x');
        StringBuilder javaSourceBuilder = new StringBuilder();
        int lineOffset = 1;
        for (int i = 0; i < javaSourceTemplate.length; ++i) {
            String s = javaSourceTemplate[i];
            if ((i & 1) == 1) {
                switch (s) {
                    case "package_name": {
                        s = pkgName;
                        break;
                    }
                    case "class_name": {
                        s = clsName;
                        break;
                    }
                    case "body": {
                        lineOffset = JavaBasedUDFunction.countNewlines(javaSourceBuilder);
                        s = body;
                        break;
                    }
                    case "arguments": {
                        s = JavaBasedUDFunction.generateArguments(javaParamTypes, argNames);
                        break;
                    }
                    case "argument_list": {
                        s = JavaBasedUDFunction.generateArgumentList(javaParamTypes, argNames);
                        break;
                    }
                    case "return_type": {
                        s = JavaBasedUDFunction.javaSourceName(javaReturnType);
                        break;
                    }
                    case "execute_internal_name": {
                        s = executeInternalName;
                    }
                }
            }
            javaSourceBuilder.append(s);
        }
        String targetClassName = pkgName + '.' + clsName;
        String javaSource = javaSourceBuilder.toString();
        logger.trace("Compiling Java source UDF '{}' as class '{}' using source:\n{}", new Object[]{name, targetClassName, javaSource});
        try {
            EcjCompilationUnit compilationUnit = new EcjCompilationUnit(javaSource, targetClassName);
            Compiler compiler = new Compiler((INameEnvironment)compilationUnit, errorHandlingPolicy, compilerOptions, (ICompilerRequestor)compilationUnit, problemFactory);
            compiler.compile(new ICompilationUnit[]{compilationUnit});
            if (compilationUnit.problemList != null && !compilationUnit.problemList.isEmpty()) {
                boolean fullSource = false;
                StringBuilder problems = new StringBuilder();
                for (IProblem problem : compilationUnit.problemList) {
                    long ln = problem.getSourceLineNumber() - lineOffset;
                    if (ln < 1L) {
                        if (!problem.isError()) continue;
                        problems.append("GENERATED SOURCE ERROR: line ").append(problem.getSourceLineNumber()).append(" (in generated source): ").append(problem.getMessage()).append('\n');
                        fullSource = true;
                        continue;
                    }
                    problems.append("Line ").append(Long.toString(ln)).append(": ").append(problem.getMessage()).append('\n');
                }
                if (fullSource) {
                    throw new InvalidRequestException("Java source compilation failed:\n" + problems + "\n generated source:\n" + javaSource);
                }
                throw new InvalidRequestException("Java source compilation failed:\n" + problems);
            }
            Set<String> errors = udfByteCodeVerifier.verify(targetClassName, targetClassLoader.classData(targetClassName));
            String validDeclare = "not allowed method declared: " + executeInternalName + '(';
            Iterator<String> i = errors.iterator();
            while (i.hasNext()) {
                String error = i.next();
                if (!error.startsWith(validDeclare)) continue;
                i.remove();
            }
            if (!errors.isEmpty()) {
                throw new InvalidRequestException("Java UDF validation failed: " + errors);
            }
            Thread thread = Thread.currentThread();
            ClassLoader orig = thread.getContextClassLoader();
            try {
                thread.setContextClassLoader(UDFunction.udfClassLoader);
                Class<?> cls = Class.forName(targetClassName, false, targetClassLoader);
                int nonSyntheticMethodCount = 0;
                for (Method m : cls.getDeclaredMethods()) {
                    if (m.isSynthetic()) continue;
                    ++nonSyntheticMethodCount;
                }
                if (nonSyntheticMethodCount != 2 || cls.getDeclaredConstructors().length != 1) {
                    throw new InvalidRequestException("Check your source to not define additional Java methods or constructors");
                }
                MethodType methodType = MethodType.methodType(Void.TYPE).appendParameterTypes(TypeCodec.class, TypeCodec[].class, UDFContext.class);
                MethodHandle ctor = MethodHandles.lookup().findConstructor(cls, methodType);
                this.javaUDF = (JavaUDF)ctor.invokeWithArguments(this.returnCodec, this.argCodecs, this.udfContext);
            }
            finally {
                thread.setContextClassLoader(orig);
            }
        }
        catch (InvocationTargetException e) {
            throw new InvalidRequestException(String.format("Could not compile function '%s' from Java source: %s", name, e.getCause()));
        }
        catch (VirtualMachineError | InvalidRequestException e) {
            throw e;
        }
        catch (Throwable e) {
            logger.error(String.format("Could not compile function '%s' from Java source:%n%s", name, javaSource), e);
            throw new InvalidRequestException(String.format("Could not compile function '%s' from Java source: %s", name, e));
        }
    }

    @Override
    protected ExecutorService executor() {
        return executor;
    }

    @Override
    protected ByteBuffer executeUserDefined(int protocolVersion, List<ByteBuffer> params) {
        return this.javaUDF.executeImpl(protocolVersion, params);
    }

    private static int countNewlines(StringBuilder javaSource) {
        int ln = 0;
        for (int i = 0; i < javaSource.length(); ++i) {
            if (javaSource.charAt(i) != '\n') continue;
            ++ln;
        }
        return ln;
    }

    private static String generateClassName(FunctionName name, char prefix) {
        String qualifiedName = name.toString();
        StringBuilder sb = new StringBuilder(qualifiedName.length() + 10);
        sb.append(prefix);
        for (int i = 0; i < qualifiedName.length(); ++i) {
            char c = qualifiedName.charAt(i);
            if (Character.isJavaIdentifierPart(c)) {
                sb.append(c);
                continue;
            }
            sb.append(Integer.toHexString((short)c & 0xFFFF));
        }
        sb.append('_').append(ThreadLocalRandom.current().nextInt() & 0xFFFFFF).append('_').append(classSequence.incrementAndGet());
        return sb.toString();
    }

    @VisibleForTesting
    public static String javaSourceName(TypeToken<?> type) {
        String n = type.toString();
        return JAVA_LANG_PREFIX.matcher(n).replaceAll("");
    }

    private static String generateArgumentList(TypeToken<?>[] paramTypes, List<ColumnIdentifier> argNames) {
        StringBuilder code = new StringBuilder(32 * paramTypes.length);
        for (int i = 0; i < paramTypes.length; ++i) {
            if (i > 0) {
                code.append(", ");
            }
            code.append(JavaBasedUDFunction.javaSourceName(paramTypes[i])).append(' ').append(argNames.get(i));
        }
        return code.toString();
    }

    private static String generateArguments(TypeToken<?>[] paramTypes, List<ColumnIdentifier> argNames) {
        StringBuilder code = new StringBuilder(64 * paramTypes.length);
        for (int i = 0; i < paramTypes.length; ++i) {
            if (i > 0) {
                code.append(",\n");
            }
            if (logger.isTraceEnabled()) {
                code.append("            /* parameter '").append(argNames.get(i)).append("' */\n");
            }
            code.append("            (").append(JavaBasedUDFunction.javaSourceName(paramTypes[i])).append(") ").append(JavaBasedUDFunction.composeMethod(paramTypes[i])).append("(protocolVersion, ").append(i).append(", params.get(").append(i).append("))");
        }
        return code.toString();
    }

    private static String composeMethod(TypeToken<?> type) {
        return type.isPrimitive() ? "super.compose_" + type.getRawType().getName() : "super.compose";
    }

    static {
        CodeSource codeSource;
        JAVA_LANG_PREFIX = Pattern.compile("\\bjava\\.lang\\.");
        logger = LoggerFactory.getLogger(JavaBasedUDFunction.class);
        classSequence = new AtomicInteger();
        executor = new UDFExecutorService(new NamedThreadFactory("UserDefinedFunctions", 1, udfClassLoader, new SecurityThreadGroup("UserDefinedFunctions", null, UDFunction::initializeThread)), "userfunction");
        targetClassLoader = new EcjTargetClassLoader();
        udfByteCodeVerifier = new UDFByteCodeVerifier();
        errorHandlingPolicy = DefaultErrorHandlingPolicies.proceedWithAllProblems();
        problemFactory = new DefaultProblemFactory(Locale.ENGLISH);
        udfByteCodeVerifier.addDisallowedMethodCall("java/lang/Class", "forName");
        udfByteCodeVerifier.addDisallowedMethodCall("java/lang/Class", "getClassLoader");
        udfByteCodeVerifier.addDisallowedMethodCall("java/lang/Class", "getResource");
        udfByteCodeVerifier.addDisallowedMethodCall("java/lang/Class", "getResourceAsStream");
        udfByteCodeVerifier.addDisallowedMethodCall("java/lang/ClassLoader", "clearAssertionStatus");
        udfByteCodeVerifier.addDisallowedMethodCall("java/lang/ClassLoader", "getResource");
        udfByteCodeVerifier.addDisallowedMethodCall("java/lang/ClassLoader", "getResourceAsStream");
        udfByteCodeVerifier.addDisallowedMethodCall("java/lang/ClassLoader", "getResources");
        udfByteCodeVerifier.addDisallowedMethodCall("java/lang/ClassLoader", "getSystemClassLoader");
        udfByteCodeVerifier.addDisallowedMethodCall("java/lang/ClassLoader", "getSystemResource");
        udfByteCodeVerifier.addDisallowedMethodCall("java/lang/ClassLoader", "getSystemResourceAsStream");
        udfByteCodeVerifier.addDisallowedMethodCall("java/lang/ClassLoader", "getSystemResources");
        udfByteCodeVerifier.addDisallowedMethodCall("java/lang/ClassLoader", "loadClass");
        udfByteCodeVerifier.addDisallowedMethodCall("java/lang/ClassLoader", "setClassAssertionStatus");
        udfByteCodeVerifier.addDisallowedMethodCall("java/lang/ClassLoader", "setDefaultAssertionStatus");
        udfByteCodeVerifier.addDisallowedMethodCall("java/lang/ClassLoader", "setPackageAssertionStatus");
        udfByteCodeVerifier.addDisallowedMethodCall("java/nio/ByteBuffer", "allocateDirect");
        for (String ia : new String[]{"java/net/InetAddress", "java/net/Inet4Address", "java/net/Inet6Address"}) {
            udfByteCodeVerifier.addDisallowedMethodCall(ia, "getByAddress");
            udfByteCodeVerifier.addDisallowedMethodCall(ia, "getAllByName");
            udfByteCodeVerifier.addDisallowedMethodCall(ia, "getByName");
            udfByteCodeVerifier.addDisallowedMethodCall(ia, "getLocalHost");
            udfByteCodeVerifier.addDisallowedMethodCall(ia, "getHostName");
            udfByteCodeVerifier.addDisallowedMethodCall(ia, "getCanonicalHostName");
            udfByteCodeVerifier.addDisallowedMethodCall(ia, "isReachable");
        }
        udfByteCodeVerifier.addDisallowedClass("java/net/NetworkInterface");
        udfByteCodeVerifier.addDisallowedClass("java/net/SocketException");
        HashMap<String, String> settings = new HashMap<String, String>();
        settings.put("org.eclipse.jdt.core.compiler.debug.lineNumber", "generate");
        settings.put("org.eclipse.jdt.core.compiler.debug.sourceFile", "disabled");
        settings.put("org.eclipse.jdt.core.compiler.problem.deprecation", "ignore");
        settings.put("org.eclipse.jdt.core.compiler.source", "1.8");
        settings.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.8");
        compilerOptions = new CompilerOptions(settings);
        JavaBasedUDFunction.compilerOptions.parseLiteralExpressionsAsConstants = true;
        try (InputStream input = JavaBasedUDFunction.class.getResource("JavaSourceUDF.txt").openConnection().getInputStream();){
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            FBUtilities.copy(input, output, Long.MAX_VALUE);
            String template = output.toString();
            StringTokenizer st = new StringTokenizer(template, "#");
            javaSourceTemplate = new String[st.countTokens()];
            int i = 0;
            while (st.hasMoreElements()) {
                JavaBasedUDFunction.javaSourceTemplate[i] = st.nextToken();
                ++i;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        try {
            codeSource = new CodeSource(new URL("udf", "localhost", 0, "/java", new URLStreamHandler(){

                @Override
                protected URLConnection openConnection(URL u) {
                    return null;
                }
            }), (Certificate[])null);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
        protectionDomain = new ProtectionDomain(codeSource, ThreadAwareSecurityManager.noPermissions, targetClassLoader, null);
    }

    static final class EcjTargetClassLoader
    extends SecureClassLoader {
        private final Map<String, byte[]> classes = new ConcurrentHashMap<String, byte[]>();

        EcjTargetClassLoader() {
            super(UDFunction.udfClassLoader);
        }

        void addClass(String className, byte[] classData) {
            this.classes.put(className, classData);
        }

        byte[] classData(String className) {
            return this.classes.get(className);
        }

        @Override
        protected Class<?> findClass(String name) throws ClassNotFoundException {
            byte[] classData = this.classes.remove(name);
            if (classData != null) {
                return this.defineClass(name, classData, 0, classData.length, protectionDomain);
            }
            return this.getParent().loadClass(name);
        }

        @Override
        protected PermissionCollection getPermissions(CodeSource codesource) {
            return ThreadAwareSecurityManager.noPermissions;
        }
    }

    static final class EcjCompilationUnit
    implements ICompilationUnit,
    ICompilerRequestor,
    INameEnvironment {
        List<IProblem> problemList;
        private final String className;
        private final char[] sourceCode;

        EcjCompilationUnit(String sourceCode, String className) {
            this.className = className;
            this.sourceCode = sourceCode.toCharArray();
        }

        public char[] getFileName() {
            return this.sourceCode;
        }

        public char[] getContents() {
            return this.sourceCode;
        }

        public char[] getMainTypeName() {
            int dot = this.className.lastIndexOf(46);
            return (dot > 0 ? this.className.substring(dot + 1) : this.className).toCharArray();
        }

        public char[][] getPackageName() {
            StringTokenizer izer = new StringTokenizer(this.className, ".");
            char[][] result = new char[izer.countTokens() - 1][];
            for (int i = 0; i < result.length; ++i) {
                result[i] = izer.nextToken().toCharArray();
            }
            return result;
        }

        public boolean ignoreOptionalProblems() {
            return false;
        }

        public void acceptResult(CompilationResult result) {
            if (result.hasErrors()) {
                CategorizedProblem[] problems = result.getProblems();
                if (this.problemList == null) {
                    this.problemList = new ArrayList<IProblem>(problems.length);
                }
                Collections.addAll(this.problemList, problems);
            } else {
                ClassFile[] classFiles;
                for (ClassFile classFile : classFiles = result.getClassFiles()) {
                    targetClassLoader.addClass(this.className, classFile.getBytes());
                }
            }
        }

        public NameEnvironmentAnswer findType(char[][] compoundTypeName) {
            StringBuilder result = new StringBuilder();
            for (int i = 0; i < compoundTypeName.length; ++i) {
                if (i > 0) {
                    result.append('.');
                }
                result.append(compoundTypeName[i]);
            }
            return this.findType(result.toString());
        }

        public NameEnvironmentAnswer findType(char[] typeName, char[][] packageName) {
            int i;
            StringBuilder result = new StringBuilder();
            for (i = 0; i < packageName.length; ++i) {
                if (i > 0) {
                    result.append('.');
                }
                result.append(packageName[i]);
            }
            if (i > 0) {
                result.append('.');
            }
            result.append(typeName);
            return this.findType(result.toString());
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private NameEnvironmentAnswer findType(String className) {
            if (className.equals(this.className)) {
                return new NameEnvironmentAnswer((ICompilationUnit)this, null);
            }
            String resourceName = className.replace('.', '/') + ".class";
            try (InputStream is = UDFunction.udfClassLoader.getResourceAsStream(resourceName);){
                if (is == null) return null;
                byte[] classBytes = ByteStreams.toByteArray((InputStream)is);
                char[] fileName = className.toCharArray();
                ClassFileReader classFileReader = new ClassFileReader(classBytes, fileName, true);
                NameEnvironmentAnswer nameEnvironmentAnswer = new NameEnvironmentAnswer((IBinaryType)classFileReader, null);
                return nameEnvironmentAnswer;
            }
            catch (IOException | ClassFormatException exc) {
                throw new RuntimeException(exc);
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private boolean isPackage(String result) {
            if (result.equals(this.className)) {
                return false;
            }
            String resourceName = result.replace('.', '/') + ".class";
            try (InputStream is = UDFunction.udfClassLoader.getResourceAsStream(resourceName);){
                boolean bl = is == null;
                return bl;
            }
            catch (IOException e) {
                return false;
            }
        }

        public boolean isPackage(char[][] parentPackageName, char[] packageName) {
            int i;
            StringBuilder result = new StringBuilder();
            if (parentPackageName != null) {
                for (i = 0; i < parentPackageName.length; ++i) {
                    if (i > 0) {
                        result.append('.');
                    }
                    result.append(parentPackageName[i]);
                }
            }
            if (Character.isUpperCase(packageName[0]) && !this.isPackage(result.toString())) {
                return false;
            }
            if (i > 0) {
                result.append('.');
            }
            result.append(packageName);
            return this.isPackage(result.toString());
        }

        public void cleanup() {
        }
    }
}

