/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.utils.memory;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.NativeDecoratedKey;
import org.apache.cassandra.db.rows.Row;
import org.apache.cassandra.utils.concurrent.OpOrder;
import org.apache.cassandra.utils.memory.MemoryUtil;
import org.apache.cassandra.utils.memory.MemtableAllocator;
import org.apache.cassandra.utils.memory.NativePool;

public class NativeAllocator
extends MemtableAllocator {
    private static final int MAX_REGION_SIZE = 0x100000;
    private static final int MAX_CLONED_SIZE = 131072;
    private static final int MIN_REGION_SIZE = 8192;
    private static final Map<Integer, RaceAllocated> RACE_ALLOCATED = new HashMap<Integer, RaceAllocated>();
    private final AtomicReference<Region> currentRegion = new AtomicReference();
    private final ConcurrentLinkedQueue<Region> regions = new ConcurrentLinkedQueue();

    protected NativeAllocator(NativePool pool) {
        super(pool.onHeap.newAllocator(), pool.offHeap.newAllocator());
    }

    @Override
    public Row.Builder rowBuilder(OpOrder.Group opGroup) {
        throw new UnsupportedOperationException();
    }

    @Override
    public DecoratedKey clone(DecoratedKey key, OpOrder.Group writeOp) {
        return new NativeDecoratedKey(key.getToken(), this, writeOp, key.getKey());
    }

    @Override
    public MemtableAllocator.DataReclaimer reclaimer() {
        return NO_OP;
    }

    public long allocate(int size, OpOrder.Group opGroup) {
        assert (size >= 0);
        this.offHeap().allocate(size, opGroup);
        if (size > 131072) {
            return this.allocateOversize(size);
        }
        long peer;
        Region region;
        while ((region = this.currentRegion.get()) == null || (peer = region.allocate(size)) <= 0L) {
            this.trySwapRegion(region, size);
        }
        return peer;
    }

    private void trySwapRegion(Region current, int minSize) {
        RaceAllocated raceAllocated;
        Region next;
        int size = current == null ? 8192 : current.capacity * 2;
        if (minSize > size) {
            size = Integer.highestOneBit(minSize) << 3;
        }
        if ((next = (raceAllocated = RACE_ALLOCATED.get(size = Math.min(0x100000, size))).poll()) == null) {
            next = new Region(MemoryUtil.allocate(size), size);
        }
        if (this.currentRegion.compareAndSet(current, next)) {
            this.regions.add(next);
        } else if (!raceAllocated.stash(next)) {
            MemoryUtil.free(next.peer);
        }
    }

    private long allocateOversize(int size) {
        Region region = new Region(MemoryUtil.allocate(size), size);
        this.regions.add(region);
        long peer = region.allocate(size);
        if (peer == -1L) {
            throw new AssertionError();
        }
        return peer;
    }

    @Override
    public void setDiscarded() {
        for (Region region : this.regions) {
            MemoryUtil.free(region.peer);
        }
        super.setDiscarded();
    }

    static {
        for (int i = 8192; i <= 0x100000; i *= 2) {
            RACE_ALLOCATED.put(i, new RaceAllocated());
        }
    }

    private static class Region {
        private final long peer;
        private final int capacity;
        private AtomicInteger nextFreeOffset = new AtomicInteger(0);
        private AtomicInteger allocCount = new AtomicInteger();

        private Region(long peer, int capacity) {
            this.peer = peer;
            this.capacity = capacity;
        }

        long allocate(int size) {
            int oldOffset;
            do {
                if ((oldOffset = this.nextFreeOffset.get()) + size <= this.capacity) continue;
                return -1L;
            } while (!this.nextFreeOffset.compareAndSet(oldOffset, oldOffset + size));
            this.allocCount.incrementAndGet();
            return this.peer + (long)oldOffset;
        }

        public String toString() {
            return "Region@" + System.identityHashCode(this) + " allocs=" + this.allocCount.get() + "waste=" + (this.capacity - this.nextFreeOffset.get());
        }
    }

    private static class RaceAllocated {
        final ConcurrentLinkedQueue<Region> stash = new ConcurrentLinkedQueue();
        final Semaphore permits = new Semaphore(8);

        private RaceAllocated() {
        }

        boolean stash(Region region) {
            if (!this.permits.tryAcquire()) {
                return false;
            }
            this.stash.add(region);
            return true;
        }

        Region poll() {
            Region next = this.stash.poll();
            if (next != null) {
                this.permits.release();
            }
            return next;
        }
    }
}

