/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.util;

import org.apache.cassandra.db.Directories;
import org.apache.cassandra.utils.WrappedRunnable;

public abstract class DiskAwareRunnable
extends WrappedRunnable {
    protected Directories.DataDirectory getWriteDirectory(long writeSize) {
        Directories.DataDirectory directory = this.getDirectory();
        if (directory == null) {
            directory = this.getDirectories().getWriteableLocation(writeSize);
        }
        if (directory == null) {
            throw new RuntimeException("Insufficient disk space to write " + writeSize + " bytes");
        }
        return directory;
    }

    protected abstract Directories getDirectories();

    protected abstract Directories.DataDirectory getDirectory();

    public boolean reduceScopeForLimitedSpace() {
        return false;
    }
}

