/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.lifecycle;

import java.io.File;
import org.apache.cassandra.db.lifecycle.LogRecord;
import org.apache.cassandra.db.lifecycle.LogTransaction;
import org.apache.cassandra.io.util.FileUtils;
import org.apache.cassandra.utils.CLibrary;

final class LogReplica {
    private final File file;
    private int folderDescriptor;

    static LogReplica create(File folder, String fileName) {
        return new LogReplica(new File(fileName), CLibrary.tryOpenDirectory(folder.getPath()));
    }

    static LogReplica open(File file) {
        return new LogReplica(file, CLibrary.tryOpenDirectory(file.getParentFile().getPath()));
    }

    LogReplica(File file, int folderDescriptor) {
        this.file = file;
        this.folderDescriptor = folderDescriptor;
    }

    File file() {
        return this.file;
    }

    void append(LogRecord record) {
        boolean existed = this.exists();
        FileUtils.appendAndSync(this.file, record.toString());
        if (!existed) {
            this.syncFolder();
        }
    }

    void syncFolder() {
        if (this.folderDescriptor >= 0) {
            CLibrary.trySync(this.folderDescriptor);
        }
    }

    void delete() {
        LogTransaction.delete(this.file);
        this.syncFolder();
    }

    boolean exists() {
        return this.file.exists();
    }

    void close() {
        if (this.folderDescriptor >= 0) {
            CLibrary.tryCloseFD(this.folderDescriptor);
            this.folderDescriptor = -1;
        }
    }

    public String toString() {
        return String.format("[%s] ", this.file);
    }
}

