/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import com.google.common.collect.Iterables;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Optional;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.Clustering;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.ConsistencyLevel;
import org.apache.cassandra.db.DataRange;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.Keyspace;
import org.apache.cassandra.db.Memtable;
import org.apache.cassandra.db.PartitionPosition;
import org.apache.cassandra.db.ReadCommand;
import org.apache.cassandra.db.ReadExecutionController;
import org.apache.cassandra.db.filter.ClusteringIndexFilter;
import org.apache.cassandra.db.filter.ColumnFilter;
import org.apache.cassandra.db.filter.DataLimits;
import org.apache.cassandra.db.filter.RowFilter;
import org.apache.cassandra.db.lifecycle.SSTableSet;
import org.apache.cassandra.db.lifecycle.View;
import org.apache.cassandra.db.partitions.CachedPartition;
import org.apache.cassandra.db.partitions.PartitionIterator;
import org.apache.cassandra.db.partitions.UnfilteredPartitionIterator;
import org.apache.cassandra.db.partitions.UnfilteredPartitionIterators;
import org.apache.cassandra.db.rows.BaseRowIterator;
import org.apache.cassandra.db.transform.Transformation;
import org.apache.cassandra.dht.AbstractBounds;
import org.apache.cassandra.exceptions.RequestExecutionException;
import org.apache.cassandra.index.Index;
import org.apache.cassandra.io.sstable.format.SSTableReader;
import org.apache.cassandra.io.util.DataInputPlus;
import org.apache.cassandra.io.util.DataOutputPlus;
import org.apache.cassandra.metrics.TableMetrics;
import org.apache.cassandra.net.MessageOut;
import org.apache.cassandra.net.MessagingService;
import org.apache.cassandra.schema.IndexMetadata;
import org.apache.cassandra.service.ClientState;
import org.apache.cassandra.service.StorageProxy;
import org.apache.cassandra.service.pager.PagingState;
import org.apache.cassandra.service.pager.QueryPager;
import org.apache.cassandra.service.pager.RangeNamesQueryPager;
import org.apache.cassandra.service.pager.RangeSliceQueryPager;
import org.apache.cassandra.thrift.ThriftResultsMerger;
import org.apache.cassandra.tracing.Tracing;
import org.apache.cassandra.utils.FBUtilities;

public class PartitionRangeReadCommand
extends ReadCommand {
    protected static final ReadCommand.SelectionDeserializer selectionDeserializer = new Deserializer();
    private final DataRange dataRange;
    private int oldestUnrepairedTombstone = Integer.MAX_VALUE;

    public PartitionRangeReadCommand(boolean isDigest, int digestVersion, boolean isForThrift, CFMetaData metadata, int nowInSec, ColumnFilter columnFilter, RowFilter rowFilter, DataLimits limits, DataRange dataRange, Optional<IndexMetadata> index) {
        super(ReadCommand.Kind.PARTITION_RANGE, isDigest, digestVersion, isForThrift, metadata, nowInSec, columnFilter, rowFilter, limits);
        this.dataRange = dataRange;
        this.index = index;
    }

    public PartitionRangeReadCommand(CFMetaData metadata, int nowInSec, ColumnFilter columnFilter, RowFilter rowFilter, DataLimits limits, DataRange dataRange, Optional<IndexMetadata> index) {
        this(false, 0, false, metadata, nowInSec, columnFilter, rowFilter, limits, dataRange, index);
    }

    public static PartitionRangeReadCommand allDataRead(CFMetaData metadata, int nowInSec) {
        return new PartitionRangeReadCommand(metadata, nowInSec, ColumnFilter.all(metadata), RowFilter.NONE, DataLimits.NONE, DataRange.allData(metadata.partitioner), Optional.empty());
    }

    public DataRange dataRange() {
        return this.dataRange;
    }

    @Override
    public ClusteringIndexFilter clusteringIndexFilter(DecoratedKey key) {
        return this.dataRange.clusteringIndexFilter(key);
    }

    public boolean isNamesQuery() {
        return this.dataRange.isNamesQuery();
    }

    public PartitionRangeReadCommand forSubRange(AbstractBounds<PartitionPosition> range) {
        return new PartitionRangeReadCommand(this.isDigestQuery(), this.digestVersion(), this.isForThrift(), this.metadata(), this.nowInSec(), this.columnFilter(), this.rowFilter(), this.limits(), this.dataRange().forSubRange(range), this.index);
    }

    @Override
    public PartitionRangeReadCommand copy() {
        return new PartitionRangeReadCommand(this.isDigestQuery(), this.digestVersion(), this.isForThrift(), this.metadata(), this.nowInSec(), this.columnFilter(), this.rowFilter(), this.limits(), this.dataRange(), this.index);
    }

    public PartitionRangeReadCommand withUpdatedLimit(DataLimits newLimits) {
        return new PartitionRangeReadCommand(this.metadata(), this.nowInSec(), this.columnFilter(), this.rowFilter(), newLimits, this.dataRange(), this.index);
    }

    @Override
    public long getTimeout() {
        return DatabaseDescriptor.getRangeRpcTimeout();
    }

    @Override
    public boolean selectsKey(DecoratedKey key) {
        if (!this.dataRange().contains(key)) {
            return false;
        }
        return this.rowFilter().partitionKeyRestrictionsAreSatisfiedBy(key, this.metadata().getKeyValidator());
    }

    @Override
    public boolean selectsClustering(DecoratedKey key, Clustering clustering) {
        if (clustering == Clustering.STATIC_CLUSTERING) {
            return !this.columnFilter().fetchedColumns().statics.isEmpty();
        }
        if (!this.dataRange().clusteringIndexFilter(key).selects(clustering)) {
            return false;
        }
        return this.rowFilter().clusteringKeyRestrictionsAreSatisfiedBy(clustering);
    }

    @Override
    public PartitionIterator execute(ConsistencyLevel consistency, ClientState clientState) throws RequestExecutionException {
        return StorageProxy.getRangeSlice(this, consistency);
    }

    @Override
    public QueryPager getPager(PagingState pagingState, int protocolVersion) {
        if (this.isNamesQuery()) {
            return new RangeNamesQueryPager(this, pagingState, protocolVersion);
        }
        return new RangeSliceQueryPager(this, pagingState, protocolVersion);
    }

    @Override
    protected void recordLatency(TableMetrics metric, long latencyNanos) {
        metric.rangeLatency.addNano(latencyNanos);
    }

    @Override
    protected UnfilteredPartitionIterator queryStorage(ColumnFamilyStore cfs, ReadExecutionController executionController) {
        ColumnFamilyStore.ViewFragment view = cfs.select(View.select(SSTableSet.LIVE, this.dataRange().keyRange()));
        Tracing.trace("Executing seq scan across {} sstables for {}", (Object)view.sstables.size(), (Object)this.dataRange().keyRange().getString(this.metadata().getKeyValidator()));
        ArrayList<Memtable.MemtableUnfilteredPartitionIterator> iterators = new ArrayList<Memtable.MemtableUnfilteredPartitionIterator>(Iterables.size(view.memtables) + view.sstables.size());
        try {
            UnfilteredPartitionIterator iter;
            for (Memtable memtable : view.memtables) {
                iter = memtable.makePartitionIterator(this.columnFilter(), this.dataRange(), this.isForThrift());
                this.oldestUnrepairedTombstone = Math.min(this.oldestUnrepairedTombstone, iter.getMinLocalDeletionTime());
                iterators.add((Memtable.MemtableUnfilteredPartitionIterator)(this.isForThrift() ? ThriftResultsMerger.maybeWrap(iter, this.metadata(), this.nowInSec()) : iter));
            }
            for (SSTableReader sstable : view.sstables) {
                iter = sstable.getScanner(this.columnFilter(), this.dataRange(), this.isForThrift());
                iterators.add((Memtable.MemtableUnfilteredPartitionIterator)(this.isForThrift() ? ThriftResultsMerger.maybeWrap(iter, this.metadata(), this.nowInSec()) : iter));
                if (sstable.isRepaired()) continue;
                this.oldestUnrepairedTombstone = Math.min(this.oldestUnrepairedTombstone, sstable.getMinLocalDeletionTime());
            }
            return this.checkCacheFilter(UnfilteredPartitionIterators.mergeLazily(iterators, this.nowInSec()), cfs);
        }
        catch (Error | RuntimeException e) {
            try {
                FBUtilities.closeAll(iterators);
            }
            catch (Exception suppressed) {
                e.addSuppressed(suppressed);
            }
            throw e;
        }
    }

    @Override
    protected int oldestUnrepairedTombstone() {
        return this.oldestUnrepairedTombstone;
    }

    private UnfilteredPartitionIterator checkCacheFilter(UnfilteredPartitionIterator iter, final ColumnFamilyStore cfs) {
        class CacheFilter
        extends Transformation {
            CacheFilter() {
            }

            public BaseRowIterator applyToPartition(BaseRowIterator iter) {
                DecoratedKey dk = iter.partitionKey();
                CachedPartition cached = cfs.getRawCachedPartition(dk);
                ClusteringIndexFilter filter = PartitionRangeReadCommand.this.dataRange().clusteringIndexFilter(dk);
                if (cached != null && cfs.isFilterFullyCoveredBy(filter, PartitionRangeReadCommand.this.limits(), cached, PartitionRangeReadCommand.this.nowInSec())) {
                    iter.close();
                    return filter.getUnfilteredRowIterator(PartitionRangeReadCommand.this.columnFilter(), cached);
                }
                return iter;
            }
        }
        return Transformation.apply(iter, new CacheFilter());
    }

    @Override
    public MessageOut<ReadCommand> createMessage(int version) {
        if (version >= 10) {
            return new MessageOut<ReadCommand>(MessagingService.Verb.RANGE_SLICE, this, serializer);
        }
        return this.dataRange().isPaging() ? new MessageOut<ReadCommand>(MessagingService.Verb.PAGED_RANGE, this, legacyPagedRangeCommandSerializer) : new MessageOut<PartitionRangeReadCommand>(MessagingService.Verb.RANGE_SLICE, this, legacyRangeSliceCommandSerializer);
    }

    @Override
    protected void appendCQLWhereClause(StringBuilder sb) {
        if (this.dataRange.isUnrestricted() && this.rowFilter().isEmpty()) {
            return;
        }
        sb.append(" WHERE ");
        if (!this.rowFilter().isEmpty()) {
            sb.append(this.rowFilter());
            if (!this.dataRange.isUnrestricted()) {
                sb.append(" AND ");
            }
        }
        if (!this.dataRange.isUnrestricted()) {
            sb.append(this.dataRange.toCQLString(this.metadata()));
        }
    }

    public PartitionIterator postReconciliationProcessing(PartitionIterator result) {
        ColumnFamilyStore cfs = Keyspace.open(this.metadata().ksName).getColumnFamilyStore(this.metadata().cfName);
        Index index = this.getIndex(cfs);
        return index == null ? result : index.postProcessorFor(this).apply(result, this);
    }

    public String toString() {
        return String.format("Read(%s.%s columns=%s rowfilter=%s limits=%s %s)", this.metadata().ksName, this.metadata().cfName, this.columnFilter(), this.rowFilter(), this.limits(), this.dataRange().toString(this.metadata()));
    }

    @Override
    protected void serializeSelection(DataOutputPlus out, int version) throws IOException {
        DataRange.serializer.serialize(this.dataRange(), out, version, this.metadata());
    }

    @Override
    protected long selectionSerializedSize(int version) {
        return DataRange.serializer.serializedSize(this.dataRange(), version, this.metadata());
    }

    private static class Deserializer
    extends ReadCommand.SelectionDeserializer {
        private Deserializer() {
        }

        @Override
        public ReadCommand deserialize(DataInputPlus in, int version, boolean isDigest, int digestVersion, boolean isForThrift, CFMetaData metadata, int nowInSec, ColumnFilter columnFilter, RowFilter rowFilter, DataLimits limits, Optional<IndexMetadata> index) throws IOException {
            DataRange range = DataRange.serializer.deserialize(in, version, metadata);
            return new PartitionRangeReadCommand(isDigest, digestVersion, isForThrift, metadata, nowInSec, columnFilter, rowFilter, limits, range, index);
        }
    }
}

