/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.compaction;

import com.google.common.base.Throwables;
import java.io.Closeable;
import java.io.File;
import java.io.IOError;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Map;
import java.util.UUID;
import java.util.function.Predicate;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.RowIndexEntry;
import org.apache.cassandra.db.compaction.CompactionController;
import org.apache.cassandra.db.compaction.CompactionInfo;
import org.apache.cassandra.db.compaction.CompactionInterruptedException;
import org.apache.cassandra.db.compaction.CompactionManager;
import org.apache.cassandra.db.compaction.OperationType;
import org.apache.cassandra.io.sstable.Component;
import org.apache.cassandra.io.sstable.CorruptSSTableException;
import org.apache.cassandra.io.sstable.SSTableIdentityIterator;
import org.apache.cassandra.io.sstable.format.SSTableReader;
import org.apache.cassandra.io.sstable.metadata.MetadataComponent;
import org.apache.cassandra.io.sstable.metadata.MetadataType;
import org.apache.cassandra.io.sstable.metadata.ValidationMetadata;
import org.apache.cassandra.io.util.DataIntegrityMetadata;
import org.apache.cassandra.io.util.FileUtils;
import org.apache.cassandra.io.util.RandomAccessReader;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.OutputHandler;
import org.apache.cassandra.utils.UUIDGen;

public class Verifier
implements Closeable {
    private final ColumnFamilyStore cfs;
    private final SSTableReader sstable;
    private final CompactionController controller;
    private final RandomAccessReader dataFile;
    private final RandomAccessReader indexFile;
    private final VerifyInfo verifyInfo;
    private final RowIndexEntry.IndexSerializer rowIndexEntrySerializer;
    private int goodRows;
    private final OutputHandler outputHandler;
    private DataIntegrityMetadata.FileDigestValidator validator;

    public Verifier(ColumnFamilyStore cfs, SSTableReader sstable, boolean isOffline) {
        this(cfs, sstable, new OutputHandler.LogOutput(), isOffline);
    }

    public Verifier(ColumnFamilyStore cfs, SSTableReader sstable, OutputHandler outputHandler, boolean isOffline) {
        this.cfs = cfs;
        this.sstable = sstable;
        this.outputHandler = outputHandler;
        this.rowIndexEntrySerializer = sstable.descriptor.version.getSSTableFormat().getIndexSerializer(sstable.metadata, sstable.descriptor.version, sstable.header);
        this.controller = new VerifyController(cfs);
        this.dataFile = isOffline ? sstable.openDataReader() : sstable.openDataReader(CompactionManager.instance.getRateLimiter());
        this.indexFile = RandomAccessReader.open(new File(sstable.descriptor.filenameFor(Component.PRIMARY_INDEX)));
        this.verifyInfo = new VerifyInfo(this.dataFile, sstable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void verify(boolean extended) throws IOException {
        long rowStart = 0L;
        this.outputHandler.output(String.format("Verifying %s (%s)", this.sstable, FBUtilities.prettyPrintMemory(this.dataFile.length())));
        this.outputHandler.output(String.format("Deserializing sstable metadata for %s ", this.sstable));
        try {
            EnumSet<MetadataType> types = EnumSet.of(MetadataType.VALIDATION, MetadataType.STATS, MetadataType.HEADER);
            Map<MetadataType, MetadataComponent> sstableMetadata = this.sstable.descriptor.getMetadataSerializer().deserialize(this.sstable.descriptor, types);
            if (sstableMetadata.containsKey((Object)MetadataType.VALIDATION) && !((ValidationMetadata)sstableMetadata.get((Object)((Object)MetadataType.VALIDATION))).partitioner.equals(this.sstable.getPartitioner().getClass().getCanonicalName())) {
                throw new IOException("Partitioner does not match validation metadata");
            }
        }
        catch (Throwable t) {
            this.outputHandler.debug(t.getMessage());
            this.markAndThrow(false);
        }
        this.outputHandler.output(String.format("Checking computed hash of %s ", this.sstable));
        try {
            this.validator = null;
            if (this.sstable.descriptor.digestComponent != null && new File(this.sstable.descriptor.filenameFor(this.sstable.descriptor.digestComponent)).exists()) {
                this.validator = DataIntegrityMetadata.fileDigestValidator(this.sstable.descriptor);
                this.validator.validate();
            } else {
                this.outputHandler.output("Data digest missing, assuming extended verification of disk values");
                extended = true;
            }
        }
        catch (IOException e) {
            this.outputHandler.debug(e.getMessage());
            this.markAndThrow();
        }
        finally {
            FileUtils.closeQuietly(this.validator);
        }
        if (!extended) {
            return;
        }
        this.outputHandler.output("Extended Verify requested, proceeding to inspect values");
        try {
            ByteBuffer nextIndexKey = ByteBufferUtil.readWithShortLength(this.indexFile);
            long firstRowPositionFromIndex = this.rowIndexEntrySerializer.deserializePositionAndSkip(this.indexFile);
            if (firstRowPositionFromIndex != 0L) {
                this.markAndThrow();
            }
            DecoratedKey prevKey = null;
            while (!this.dataFile.isEOF()) {
                if (this.verifyInfo.isStopRequested()) {
                    throw new CompactionInterruptedException(this.verifyInfo.getCompactionInfo());
                }
                rowStart = this.dataFile.getFilePointer();
                this.outputHandler.debug("Reading row at " + rowStart);
                DecoratedKey key = null;
                try {
                    key = this.sstable.decorateKey(ByteBufferUtil.readWithShortLength(this.dataFile));
                }
                catch (Throwable th) {
                    this.throwIfFatal(th);
                }
                ByteBuffer currentIndexKey = nextIndexKey;
                long nextRowPositionFromIndex = 0L;
                try {
                    nextIndexKey = this.indexFile.isEOF() ? null : ByteBufferUtil.readWithShortLength(this.indexFile);
                    nextRowPositionFromIndex = this.indexFile.isEOF() ? this.dataFile.length() : this.rowIndexEntrySerializer.deserializePositionAndSkip(this.indexFile);
                }
                catch (Throwable th) {
                    this.markAndThrow();
                }
                long dataStart = this.dataFile.getFilePointer();
                long dataStartFromIndex = currentIndexKey == null ? -1L : rowStart + 2L + (long)currentIndexKey.remaining();
                long dataSize = nextRowPositionFromIndex - dataStartFromIndex;
                String keyName = key == null ? "(unreadable key)" : ByteBufferUtil.bytesToHex(key.getKey());
                this.outputHandler.debug(String.format("row %s is %s", keyName, FBUtilities.prettyPrintMemory(dataSize)));
                assert (currentIndexKey != null || this.indexFile.isEOF());
                try {
                    if (key == null || dataSize > this.dataFile.length()) {
                        this.markAndThrow();
                    }
                    SSTableIdentityIterator iterator = SSTableIdentityIterator.create(this.sstable, this.dataFile, key);
                    Throwable throwable = null;
                    if (iterator != null) {
                        if (throwable != null) {
                            try {
                                iterator.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        } else {
                            iterator.close();
                        }
                    }
                    if (prevKey != null && prevKey.compareTo(key) > 0 || !key.getKey().equals(currentIndexKey) || dataStart != dataStartFromIndex) {
                        this.markAndThrow();
                    }
                    ++this.goodRows;
                    prevKey = key;
                    this.outputHandler.debug(String.format("Row %s at %s valid, moving to next row at %s ", this.goodRows, rowStart, nextRowPositionFromIndex));
                    this.dataFile.seek(nextRowPositionFromIndex);
                }
                catch (Throwable th) {
                    this.markAndThrow();
                }
            }
        }
        catch (Throwable t) {
            throw Throwables.propagate((Throwable)t);
        }
        finally {
            this.controller.close();
        }
        this.outputHandler.output("Verify of " + this.sstable + " succeeded. All " + this.goodRows + " rows read successfully");
    }

    @Override
    public void close() {
        FileUtils.closeQuietly(this.dataFile);
        FileUtils.closeQuietly(this.indexFile);
    }

    private void throwIfFatal(Throwable th) {
        if (th instanceof Error && !(th instanceof AssertionError) && !(th instanceof IOError)) {
            throw (Error)th;
        }
    }

    private void markAndThrow() throws IOException {
        this.markAndThrow(true);
    }

    private void markAndThrow(boolean mutateRepaired) throws IOException {
        if (mutateRepaired) {
            try {
                this.sstable.descriptor.getMetadataSerializer().mutateRepairedAt(this.sstable.descriptor, 0L);
                this.sstable.reloadSSTableMetadata();
                this.cfs.getTracker().notifySSTableRepairedStatusChanged(Collections.singleton(this.sstable));
            }
            catch (IOException ioe) {
                this.outputHandler.output("Error mutating repairedAt for SSTable " + this.sstable.getFilename() + ", as part of markAndThrow");
            }
        }
        throw new CorruptSSTableException((Throwable)new Exception(String.format("Invalid SSTable %s, please force %srepair", this.sstable.getFilename(), mutateRepaired ? "" : "a full ")), this.sstable.getFilename());
    }

    public CompactionInfo.Holder getVerifyInfo() {
        return this.verifyInfo;
    }

    private static class VerifyController
    extends CompactionController {
        public VerifyController(ColumnFamilyStore cfs) {
            super(cfs, Integer.MAX_VALUE);
        }

        @Override
        public Predicate<Long> getPurgeEvaluator(DecoratedKey key) {
            return time -> false;
        }
    }

    private static class VerifyInfo
    extends CompactionInfo.Holder {
        private final RandomAccessReader dataFile;
        private final SSTableReader sstable;
        private final UUID verificationCompactionId;

        public VerifyInfo(RandomAccessReader dataFile, SSTableReader sstable) {
            this.dataFile = dataFile;
            this.sstable = sstable;
            this.verificationCompactionId = UUIDGen.getTimeUUID();
        }

        @Override
        public CompactionInfo getCompactionInfo() {
            try {
                return new CompactionInfo(this.sstable.metadata, OperationType.VERIFY, this.dataFile.getFilePointer(), this.dataFile.length(), this.verificationCompactionId);
            }
            catch (Exception e) {
                throw new RuntimeException();
            }
        }

        @Override
        public boolean isGlobal() {
            return false;
        }
    }
}

