/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import java.nio.ByteBuffer;
import org.apache.cassandra.db.AbstractClusteringPrefix;
import org.apache.cassandra.db.Clustering;
import org.apache.cassandra.db.ClusteringPrefix;
import org.apache.cassandra.utils.ObjectSizes;

public abstract class AbstractBufferClusteringPrefix
extends AbstractClusteringPrefix {
    public static final ByteBuffer[] EMPTY_VALUES_ARRAY = new ByteBuffer[0];
    private static final long EMPTY_SIZE = ObjectSizes.measure(Clustering.make(EMPTY_VALUES_ARRAY));
    protected final ClusteringPrefix.Kind kind;
    protected final ByteBuffer[] values;

    protected AbstractBufferClusteringPrefix(ClusteringPrefix.Kind kind, ByteBuffer[] values) {
        this.kind = kind;
        this.values = values;
    }

    @Override
    public ClusteringPrefix.Kind kind() {
        return this.kind;
    }

    @Override
    public ClusteringPrefix clustering() {
        return this;
    }

    @Override
    public int size() {
        return this.values.length;
    }

    @Override
    public ByteBuffer get(int i) {
        return this.values[i];
    }

    @Override
    public ByteBuffer[] getRawValues() {
        return this.values;
    }

    @Override
    public long unsharedHeapSize() {
        return EMPTY_SIZE + ObjectSizes.sizeOnHeapOf(this.values);
    }

    public long unsharedHeapSizeExcludingData() {
        return EMPTY_SIZE + ObjectSizes.sizeOnHeapExcludingData(this.values);
    }
}

