/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.statements;

import java.util.regex.Pattern;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.ColumnDefinition;
import org.apache.cassandra.cql3.ColumnIdentifier;

public class IndexTarget {
    public static final String TARGET_OPTION_NAME = "target";
    public static final String CUSTOM_INDEX_OPTION_NAME = "class_name";
    public static final String INDEX_KEYS_OPTION_NAME = "index_keys";
    public static final String INDEX_ENTRIES_OPTION_NAME = "index_keys_and_values";
    private static final Pattern COLUMN_IDENTIFIER_PATTERN = Pattern.compile("[a-z_0-9]+");
    public final ColumnIdentifier column;
    public final boolean quoteName;
    public final Type type;

    public IndexTarget(ColumnIdentifier column, Type type) {
        this.column = column;
        this.type = type;
        this.quoteName = !COLUMN_IDENTIFIER_PATTERN.matcher(column.toString()).matches();
    }

    public String asCqlString(CFMetaData cfm) {
        if (!cfm.getColumnDefinition((ColumnIdentifier)this.column).type.isCollection()) {
            return this.column.toCQLString();
        }
        return String.format("%s(%s)", this.type.toString(), this.column.toCQLString());
    }

    public static enum Type {
        VALUES,
        KEYS,
        KEYS_AND_VALUES,
        FULL,
        SIMPLE;


        public String toString() {
            switch (this) {
                case KEYS: {
                    return "keys";
                }
                case KEYS_AND_VALUES: {
                    return "entries";
                }
                case FULL: {
                    return "full";
                }
                case VALUES: {
                    return "values";
                }
                case SIMPLE: {
                    return "";
                }
            }
            return "";
        }

        public static Type fromString(String s) {
            if ("".equals(s)) {
                return SIMPLE;
            }
            if ("values".equals(s)) {
                return VALUES;
            }
            if ("keys".equals(s)) {
                return KEYS;
            }
            if ("entries".equals(s)) {
                return KEYS_AND_VALUES;
            }
            if ("full".equals(s)) {
                return FULL;
            }
            throw new AssertionError((Object)("Unrecognized index target type " + s));
        }
    }

    public static class Raw {
        private final ColumnDefinition.Raw column;
        private final Type type;

        private Raw(ColumnDefinition.Raw column, Type type) {
            this.column = column;
            this.type = type;
        }

        public static Raw simpleIndexOn(ColumnDefinition.Raw c) {
            return new Raw(c, Type.SIMPLE);
        }

        public static Raw valuesOf(ColumnDefinition.Raw c) {
            return new Raw(c, Type.VALUES);
        }

        public static Raw keysOf(ColumnDefinition.Raw c) {
            return new Raw(c, Type.KEYS);
        }

        public static Raw keysAndValuesOf(ColumnDefinition.Raw c) {
            return new Raw(c, Type.KEYS_AND_VALUES);
        }

        public static Raw fullCollection(ColumnDefinition.Raw c) {
            return new Raw(c, Type.FULL);
        }

        public IndexTarget prepare(CFMetaData cfm) {
            ColumnDefinition columnDef = this.column.prepare(cfm);
            Type actualType = this.type == Type.SIMPLE && columnDef.type.isCollection() ? Type.VALUES : this.type;
            return new IndexTarget(columnDef.name, actualType);
        }
    }
}

