/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.tools.nodetool;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import io.airlift.command.Arguments;
import io.airlift.command.Command;
import io.airlift.command.Option;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.TabularDataSupport;
import org.apache.cassandra.metrics.TableMetrics;
import org.apache.cassandra.tools.NodeProbe;
import org.apache.cassandra.tools.NodeTool;
import org.apache.commons.lang3.StringUtils;

@Command(name="toppartitions", description="Sample and print the most active partitions for a given column family")
public class TopPartitions
extends NodeTool.NodeToolCmd {
    @Arguments(usage="<keyspace> <cfname> <duration>", description="The keyspace, column family name, and duration in milliseconds")
    private List<String> args = new ArrayList<String>();
    @Option(name={"-s"}, description="Capacity of stream summary, closer to the actual cardinality of partitions will yield more accurate results (Default: 256)")
    private int size = 256;
    @Option(name={"-k"}, description="Number of the top partitions to list (Default: 10)")
    private int topCount = 10;
    @Option(name={"-a"}, description="Comma separated list of samplers to use (Default: all)")
    private String samplers = StringUtils.join((Object[])TableMetrics.Sampler.values(), (char)',');

    @Override
    public void execute(NodeProbe probe) {
        Map<TableMetrics.Sampler, CompositeData> results;
        Preconditions.checkArgument((this.args.size() == 3 ? 1 : 0) != 0, (Object)"toppartitions requires keyspace, column family name, and duration");
        Preconditions.checkArgument((this.topCount < this.size ? 1 : 0) != 0, (Object)"TopK count (-k) option must be smaller then the summary capacity (-s)");
        PrintStream out = probe.output().out;
        String keyspace = this.args.get(0);
        String cfname = this.args.get(1);
        Integer duration = Integer.valueOf(this.args.get(2));
        ArrayList targets = Lists.newArrayList();
        for (String s : this.samplers.split(",")) {
            try {
                targets.add(TableMetrics.Sampler.valueOf(s.toUpperCase()));
            }
            catch (Exception e) {
                throw new IllegalArgumentException(s + " is not a valid sampler, choose one of: " + StringUtils.join((Object[])TableMetrics.Sampler.values(), (String)", "));
            }
        }
        try {
            results = probe.getPartitionSample(keyspace, cfname, this.size, duration, this.topCount, targets);
        }
        catch (OpenDataException e) {
            throw new RuntimeException(e);
        }
        boolean first = true;
        for (Map.Entry<TableMetrics.Sampler, CompositeData> result : results.entrySet()) {
            CompositeData sampling = result.getValue();
            List topk = Lists.newArrayList(((TabularDataSupport)sampling.get("partitions")).values());
            Collections.sort(topk, new Ordering<CompositeData>(){

                public int compare(CompositeData left, CompositeData right) {
                    return Long.compare((Long)right.get("count"), (Long)left.get("count"));
                }
            });
            if (!first) {
                out.println();
            }
            out.println(result.getKey().toString() + " Sampler:");
            out.printf("  Cardinality: ~%d (%d capacity)%n", sampling.get("cardinality"), this.size);
            out.printf("  Top %d partitions:%n", this.topCount);
            if (topk.size() == 0) {
                out.println("\tNothing recorded during sampling period...");
            } else {
                int offset = 0;
                for (CompositeData entry : topk) {
                    offset = Math.max(offset, entry.get("string").toString().length());
                }
                out.printf("\t%-" + offset + "s%10s%10s%n", "Partition", "Count", "+/-");
                for (CompositeData entry : topk) {
                    out.printf("\t%-" + offset + "s%10d%10d%n", entry.get("string").toString(), entry.get("count"), entry.get("error"));
                }
            }
            first = false;
        }
    }
}

