/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.utils;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.URL;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Optional;
import java.util.Properties;
import java.util.TreeSet;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.zip.CRC32;
import java.util.zip.Checksum;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.cassandra.auth.IAuthenticator;
import org.apache.cassandra.auth.IAuthorizer;
import org.apache.cassandra.auth.IRoleManager;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.SerializationHeader;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.dht.IPartitioner;
import org.apache.cassandra.dht.LocalPartitioner;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.exceptions.ConfigurationException;
import org.apache.cassandra.io.IVersionedSerializer;
import org.apache.cassandra.io.sstable.Descriptor;
import org.apache.cassandra.io.sstable.metadata.MetadataComponent;
import org.apache.cassandra.io.sstable.metadata.MetadataType;
import org.apache.cassandra.io.sstable.metadata.ValidationMetadata;
import org.apache.cassandra.io.util.DataOutputBufferFixed;
import org.apache.cassandra.io.util.FileUtils;
import org.apache.cassandra.net.AsyncOneResponse;
import org.apache.cassandra.utils.AbstractIterator;
import org.apache.cassandra.utils.CloseableIterator;
import org.apache.cassandra.utils.FastByteOperations;
import org.apache.cassandra.utils.JVMStabilityInspector;
import org.apache.cassandra.utils.Pair;
import org.apache.cassandra.utils.Throwables;
import org.apache.commons.lang3.StringUtils;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.map.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FBUtilities {
    private static final Logger logger = LoggerFactory.getLogger(FBUtilities.class);
    private static final ObjectMapper jsonMapper = new ObjectMapper(new JsonFactory());
    public static final BigInteger TWO = new BigInteger("2");
    private static final String DEFAULT_TRIGGER_DIR = "triggers";
    private static final String OPERATING_SYSTEM = System.getProperty("os.name").toLowerCase();
    public static final boolean isWindows = OPERATING_SYSTEM.contains("windows");
    private static volatile InetAddress localInetAddress;
    private static volatile InetAddress broadcastInetAddress;
    private static volatile InetAddress broadcastRpcAddress;
    private static final ThreadLocal<MessageDigest> localMD5Digest;
    public static final int MAX_UNSIGNED_SHORT = 65535;

    public static int getAvailableProcessors() {
        if (System.getProperty("cassandra.available_processors") != null) {
            return Integer.parseInt(System.getProperty("cassandra.available_processors"));
        }
        return Runtime.getRuntime().availableProcessors();
    }

    public static MessageDigest threadLocalMD5Digest() {
        return localMD5Digest.get();
    }

    public static MessageDigest newMessageDigest(String algorithm) {
        try {
            return MessageDigest.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new RuntimeException("the requested digest algorithm (" + algorithm + ") is not available", nsae);
        }
    }

    public static InetAddress getLocalAddress() {
        if (localInetAddress == null) {
            try {
                localInetAddress = DatabaseDescriptor.getListenAddress() == null ? InetAddress.getLocalHost() : DatabaseDescriptor.getListenAddress();
            }
            catch (UnknownHostException e) {
                throw new RuntimeException(e);
            }
        }
        return localInetAddress;
    }

    public static InetAddress getBroadcastAddress() {
        if (broadcastInetAddress == null) {
            broadcastInetAddress = DatabaseDescriptor.getBroadcastAddress() == null ? FBUtilities.getLocalAddress() : DatabaseDescriptor.getBroadcastAddress();
        }
        return broadcastInetAddress;
    }

    public static InetAddress getBroadcastRpcAddress() {
        if (broadcastRpcAddress == null) {
            broadcastRpcAddress = DatabaseDescriptor.getBroadcastRpcAddress() == null ? DatabaseDescriptor.getRpcAddress() : DatabaseDescriptor.getBroadcastRpcAddress();
        }
        return broadcastRpcAddress;
    }

    public static Collection<InetAddress> getAllLocalAddresses() {
        HashSet<InetAddress> localAddresses = new HashSet<InetAddress>();
        try {
            Enumeration<NetworkInterface> nets = NetworkInterface.getNetworkInterfaces();
            if (nets != null) {
                while (nets.hasMoreElements()) {
                    localAddresses.addAll(Collections.list(nets.nextElement().getInetAddresses()));
                }
            }
        }
        catch (SocketException e) {
            throw new AssertionError((Object)e);
        }
        return localAddresses;
    }

    public static String getNetworkInterface(InetAddress localAddress) {
        try {
            for (NetworkInterface ifc : Collections.list(NetworkInterface.getNetworkInterfaces())) {
                if (!ifc.isUp()) continue;
                for (InetAddress addr : Collections.list(ifc.getInetAddresses())) {
                    if (!addr.equals(localAddress)) continue;
                    return ifc.getDisplayName();
                }
            }
        }
        catch (SocketException socketException) {
            // empty catch block
        }
        return null;
    }

    public static Pair<BigInteger, Boolean> midpoint(BigInteger left, BigInteger right, int sigbits) {
        BigInteger midpoint;
        boolean remainder;
        if (left.compareTo(right) < 0) {
            BigInteger sum = left.add(right);
            remainder = sum.testBit(0);
            midpoint = sum.shiftRight(1);
        } else {
            BigInteger max = TWO.pow(sigbits);
            BigInteger distance = max.add(right).subtract(left);
            remainder = distance.testBit(0);
            midpoint = distance.shiftRight(1).add(left).mod(max);
        }
        return Pair.create(midpoint, remainder);
    }

    public static int compareUnsigned(byte[] bytes1, byte[] bytes2, int offset1, int offset2, int len1, int len2) {
        return FastByteOperations.compareUnsigned(bytes1, offset1, len1, bytes2, offset2, len2);
    }

    public static int compareUnsigned(byte[] bytes1, byte[] bytes2) {
        return FBUtilities.compareUnsigned(bytes1, bytes2, 0, 0, bytes1.length, bytes2.length);
    }

    public static byte[] xor(byte[] left, byte[] right) {
        if (left == null || right == null) {
            return null;
        }
        if (left.length > right.length) {
            byte[] swap = left;
            left = right;
            right = swap;
        }
        byte[] out = Arrays.copyOf(right, right.length);
        for (int i = 0; i < left.length; ++i) {
            out[i] = (byte)(left[i] & 0xFF ^ right[i] & 0xFF);
        }
        return out;
    }

    public static byte[] hash(ByteBuffer ... data) {
        MessageDigest messageDigest = localMD5Digest.get();
        for (ByteBuffer block : data) {
            if (block.hasArray()) {
                messageDigest.update(block.array(), block.arrayOffset() + block.position(), block.remaining());
                continue;
            }
            messageDigest.update(block.duplicate());
        }
        return messageDigest.digest();
    }

    public static BigInteger hashToBigInteger(ByteBuffer data) {
        return new BigInteger(FBUtilities.hash(data)).abs();
    }

    public static void sortSampledKeys(List<DecoratedKey> keys, Range<Token> range) {
        if (((Token)range.left).compareTo(range.right) >= 0) {
            final Token right = (Token)range.right;
            Comparator<DecoratedKey> comparator = new Comparator<DecoratedKey>(){

                @Override
                public int compare(DecoratedKey o1, DecoratedKey o2) {
                    if (right.compareTo(o1.getToken()) < 0 && right.compareTo(o2.getToken()) < 0 || right.compareTo(o1.getToken()) > 0 && right.compareTo(o2.getToken()) > 0) {
                        return o1.compareTo(o2);
                    }
                    return o2.compareTo(o1);
                }
            };
            Collections.sort(keys, comparator);
        } else {
            Collections.sort(keys);
        }
    }

    public static String resourceToFile(String filename) throws ConfigurationException {
        ClassLoader loader = FBUtilities.class.getClassLoader();
        URL scpurl = loader.getResource(filename);
        if (scpurl == null) {
            throw new ConfigurationException("unable to locate " + filename);
        }
        return new File(scpurl.getFile()).getAbsolutePath();
    }

    public static File cassandraTriggerDir() {
        File triggerDir = null;
        if (System.getProperty("cassandra.triggers_dir") != null) {
            triggerDir = new File(System.getProperty("cassandra.triggers_dir"));
        } else {
            URL confDir = FBUtilities.class.getClassLoader().getResource(DEFAULT_TRIGGER_DIR);
            if (confDir != null) {
                triggerDir = new File(confDir.getFile());
            }
        }
        if (triggerDir == null || !triggerDir.exists()) {
            logger.warn("Trigger directory doesn't exist, please create it and try again.");
            return null;
        }
        return triggerDir;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getReleaseVersionString() {
        try (InputStream in = FBUtilities.class.getClassLoader().getResourceAsStream("org/apache/cassandra/config/version.properties");){
            if (in == null) {
                String string2 = System.getProperty("cassandra.releaseVersion", "Unknown");
                return string2;
            }
            Properties props = new Properties();
            props.load(in);
            String string = props.getProperty("CassandraVersion");
            return string;
        }
        catch (Exception e) {
            JVMStabilityInspector.inspectThrowable(e);
            logger.warn("Unable to load version.properties", (Throwable)e);
            return "debug version";
        }
    }

    public static long timestampMicros() {
        return System.currentTimeMillis() * 1000L;
    }

    public static int nowInSeconds() {
        return (int)(System.currentTimeMillis() / 1000L);
    }

    public static <T> List<T> waitOnFutures(Iterable<? extends Future<? extends T>> futures) {
        ArrayList<T> results = new ArrayList<T>();
        Throwable fail = null;
        for (Future<T> f : futures) {
            try {
                results.add(f.get());
            }
            catch (Throwable t) {
                fail = Throwables.merge(fail, t);
            }
        }
        Throwables.maybeFail(fail);
        return results;
    }

    public static <T> T waitOnFuture(Future<T> future) {
        try {
            return future.get();
        }
        catch (ExecutionException ee) {
            throw new RuntimeException(ee);
        }
        catch (InterruptedException ie) {
            throw new AssertionError((Object)ie);
        }
    }

    public static void waitOnFutures(List<AsyncOneResponse> results, long ms) throws TimeoutException {
        for (AsyncOneResponse result : results) {
            result.get(ms, TimeUnit.MILLISECONDS);
        }
    }

    public static IPartitioner newPartitioner(Descriptor desc) throws IOException {
        EnumSet<MetadataType> types = EnumSet.of(MetadataType.VALIDATION, MetadataType.HEADER);
        Map<MetadataType, MetadataComponent> sstableMetadata = desc.getMetadataSerializer().deserialize(desc, types);
        ValidationMetadata validationMetadata = (ValidationMetadata)sstableMetadata.get((Object)MetadataType.VALIDATION);
        SerializationHeader.Component header = (SerializationHeader.Component)sstableMetadata.get((Object)MetadataType.HEADER);
        return FBUtilities.newPartitioner(validationMetadata.partitioner, Optional.of(header.getKeyType()));
    }

    public static IPartitioner newPartitioner(String partitionerClassName) throws ConfigurationException {
        return FBUtilities.newPartitioner(partitionerClassName, Optional.empty());
    }

    @VisibleForTesting
    static IPartitioner newPartitioner(String partitionerClassName, Optional<AbstractType<?>> comparator) throws ConfigurationException {
        if (!partitionerClassName.contains(".")) {
            partitionerClassName = "org.apache.cassandra.dht." + partitionerClassName;
        }
        if (partitionerClassName.equals("org.apache.cassandra.dht.LocalPartitioner")) {
            assert (comparator.isPresent()) : "Expected a comparator for local partitioner";
            return new LocalPartitioner(comparator.get());
        }
        return (IPartitioner)FBUtilities.instanceOrConstruct(partitionerClassName, "partitioner");
    }

    public static IAuthorizer newAuthorizer(String className) throws ConfigurationException {
        if (!className.contains(".")) {
            className = "org.apache.cassandra.auth." + className;
        }
        return (IAuthorizer)FBUtilities.construct(className, "authorizer");
    }

    public static IAuthenticator newAuthenticator(String className) throws ConfigurationException {
        if (!className.contains(".")) {
            className = "org.apache.cassandra.auth." + className;
        }
        return (IAuthenticator)FBUtilities.construct(className, "authenticator");
    }

    public static IRoleManager newRoleManager(String className) throws ConfigurationException {
        if (!className.contains(".")) {
            className = "org.apache.cassandra.auth." + className;
        }
        return (IRoleManager)FBUtilities.construct(className, "role manager");
    }

    public static <T> Class<T> classForName(String classname, String readable) throws ConfigurationException {
        try {
            return Class.forName(classname);
        }
        catch (ClassNotFoundException | NoClassDefFoundError e) {
            throw new ConfigurationException(String.format("Unable to find %s class '%s'", readable, classname), e);
        }
    }

    public static <T> T instanceOrConstruct(String classname, String readable) throws ConfigurationException {
        Class<T> cls = FBUtilities.classForName(classname, readable);
        try {
            Field instance = cls.getField("instance");
            return cls.cast(instance.get(null));
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
            return FBUtilities.construct(cls, classname, readable);
        }
    }

    public static <T> T construct(String classname, String readable) throws ConfigurationException {
        Class<T> cls = FBUtilities.classForName(classname, readable);
        return FBUtilities.construct(cls, classname, readable);
    }

    private static <T> T construct(Class<T> cls, String classname, String readable) throws ConfigurationException {
        try {
            return cls.newInstance();
        }
        catch (IllegalAccessException e) {
            throw new ConfigurationException(String.format("Default constructor for %s class '%s' is inaccessible.", readable, classname));
        }
        catch (InstantiationException e) {
            throw new ConfigurationException(String.format("Cannot use abstract class '%s' as %s.", classname, readable));
        }
        catch (Exception e) {
            if (e.getCause() instanceof ConfigurationException) {
                throw (ConfigurationException)e.getCause();
            }
            throw new ConfigurationException(String.format("Error instantiating %s class '%s'.", readable, classname), e);
        }
    }

    public static <T> NavigableSet<T> singleton(T column, Comparator<? super T> comparator) {
        TreeSet<T> s = new TreeSet<T>(comparator);
        s.add(column);
        return s;
    }

    public static <T> NavigableSet<T> emptySortedSet(Comparator<? super T> comparator) {
        return new TreeSet<T>(comparator);
    }

    @Nonnull
    public static String toString(@Nullable Map<?, ?> map) {
        if (map == null) {
            return "";
        }
        Joiner.MapJoiner joiner = Joiner.on((String)", ").withKeyValueSeparator(":");
        return joiner.join(map);
    }

    public static Field getProtectedField(Class klass, String fieldName) {
        try {
            Field field = klass.getDeclaredField(fieldName);
            field.setAccessible(true);
            return field;
        }
        catch (Exception e) {
            throw new AssertionError((Object)e);
        }
    }

    public static <T> CloseableIterator<T> closeableIterator(Iterator<T> iterator) {
        return new WrappedCloseableIterator<T>(iterator);
    }

    public static Map<String, String> fromJsonMap(String json) {
        try {
            return (Map)jsonMapper.readValue(json, Map.class);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static List<String> fromJsonList(String json) {
        try {
            return (List)jsonMapper.readValue(json, List.class);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static String json(Object object) {
        try {
            return jsonMapper.writeValueAsString(object);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static String prettyPrintMemory(long size) {
        return FBUtilities.prettyPrintMemory(size, false);
    }

    public static String prettyPrintMemory(long size, boolean includeSpace) {
        if (size >= 0x40000000L) {
            return String.format("%.3f%sGiB", (double)size / 1.073741824E9, includeSpace ? " " : "");
        }
        if (size >= 0x100000L) {
            return String.format("%.3f%sMiB", (double)size / 1048576.0, includeSpace ? " " : "");
        }
        return String.format("%.3f%sKiB", (double)size / 1024.0, includeSpace ? " " : "");
    }

    public static String prettyPrintMemoryPerSecond(long rate) {
        if (rate >= 0x40000000L) {
            return String.format("%.3fGiB/s", (double)rate / 1.073741824E9);
        }
        if (rate >= 0x100000L) {
            return String.format("%.3fMiB/s", (double)rate / 1048576.0);
        }
        return String.format("%.3fKiB/s", (double)rate / 1024.0);
    }

    public static String prettyPrintMemoryPerSecond(long bytes, long timeInNano) {
        if (timeInNano == 0L) {
            return "NaN  KiB/s";
        }
        long rate = (long)((double)bytes / (double)timeInNano * 1000.0 * 1000.0 * 1000.0);
        return FBUtilities.prettyPrintMemoryPerSecond(rate);
    }

    public static void exec(ProcessBuilder pb) throws IOException {
        Process p = pb.start();
        try {
            int errCode = p.waitFor();
            if (errCode != 0) {
                BufferedReader in = new BufferedReader(new InputStreamReader(p.getInputStream()));
                Throwable throwable = null;
                try {
                    try {
                        BufferedReader err = new BufferedReader(new InputStreamReader(p.getErrorStream()));
                        Throwable throwable2 = null;
                        try {
                            try {
                                String str;
                                String lineSep = System.getProperty("line.separator");
                                StringBuilder sb = new StringBuilder();
                                while ((str = in.readLine()) != null) {
                                    sb.append(str).append(lineSep);
                                }
                                while ((str = err.readLine()) != null) {
                                    sb.append(str).append(lineSep);
                                }
                                throw new IOException("Exception while executing the command: " + StringUtils.join(pb.command(), (String)" ") + ", command error Code: " + errCode + ", command output: " + sb.toString());
                            }
                            catch (Throwable throwable3) {
                                throwable2 = throwable3;
                                throw throwable3;
                            }
                        }
                        catch (Throwable throwable4) {
                            if (err != null) {
                                if (throwable2 != null) {
                                    try {
                                        err.close();
                                    }
                                    catch (Throwable throwable5) {
                                        throwable2.addSuppressed(throwable5);
                                    }
                                } else {
                                    err.close();
                                }
                            }
                            throw throwable4;
                        }
                    }
                    catch (Throwable throwable6) {
                        throwable = throwable6;
                        throw throwable6;
                    }
                }
                catch (Throwable throwable7) {
                    if (in != null) {
                        if (throwable != null) {
                            try {
                                in.close();
                            }
                            catch (Throwable throwable8) {
                                throwable.addSuppressed(throwable8);
                            }
                        } else {
                            in.close();
                        }
                    }
                    throw throwable7;
                }
            }
        }
        catch (InterruptedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static void updateChecksumInt(Checksum checksum, int v) {
        checksum.update(v >>> 24 & 0xFF);
        checksum.update(v >>> 16 & 0xFF);
        checksum.update(v >>> 8 & 0xFF);
        checksum.update(v >>> 0 & 0xFF);
    }

    public static void updateChecksum(CRC32 checksum, ByteBuffer buffer, int offset, int length) {
        int position = buffer.position();
        int limit = buffer.limit();
        buffer.position(offset).limit(offset + length);
        checksum.update(buffer);
        buffer.position(position).limit(limit);
    }

    public static void updateChecksum(CRC32 checksum, ByteBuffer buffer) {
        int position = buffer.position();
        checksum.update(buffer);
        buffer.position(position);
    }

    public static long abs(long index) {
        long negbit = index >> 63;
        return (index ^ negbit) - negbit;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> byte[] serialize(T object, IVersionedSerializer<T> serializer, int version) {
        int size = (int)serializer.serializedSize(object, version);
        try (DataOutputBufferFixed buffer = new DataOutputBufferFixed(size);){
            serializer.serialize(object, buffer, version);
            assert (buffer.getLength() == size && buffer.getData().length == size) : String.format("Final buffer length %s to accommodate data size of %s (predicted %s) for %s", buffer.getData().length, buffer.getLength(), size, object);
            byte[] byArray = buffer.getData();
            return byArray;
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static long copy(InputStream from, OutputStream to, long limit) throws IOException {
        int sofar;
        byte[] buffer = new byte[64];
        long copied = 0L;
        int toCopy = buffer.length;
        do {
            if (limit < (long)buffer.length + copied) {
                toCopy = (int)(limit - copied);
            }
            if ((sofar = from.read(buffer, 0, toCopy)) == -1) break;
            to.write(buffer, 0, sofar);
        } while (limit != (copied += (long)sofar));
        return copied;
    }

    public static File getToolsOutputDirectory() {
        File historyDir = new File(System.getProperty("user.home"), ".cassandra");
        FileUtils.createDirectory(historyDir);
        return historyDir;
    }

    public static void updateWithShort(MessageDigest digest, int val) {
        digest.update((byte)(val >> 8 & 0xFF));
        digest.update((byte)(val & 0xFF));
    }

    public static void updateWithByte(MessageDigest digest, int val) {
        digest.update((byte)(val & 0xFF));
    }

    public static void updateWithInt(MessageDigest digest, int val) {
        digest.update((byte)(val >>> 24 & 0xFF));
        digest.update((byte)(val >>> 16 & 0xFF));
        digest.update((byte)(val >>> 8 & 0xFF));
        digest.update((byte)(val >>> 0 & 0xFF));
    }

    public static void updateWithLong(MessageDigest digest, long val) {
        digest.update((byte)(val >>> 56 & 0xFFL));
        digest.update((byte)(val >>> 48 & 0xFFL));
        digest.update((byte)(val >>> 40 & 0xFFL));
        digest.update((byte)(val >>> 32 & 0xFFL));
        digest.update((byte)(val >>> 24 & 0xFFL));
        digest.update((byte)(val >>> 16 & 0xFFL));
        digest.update((byte)(val >>> 8 & 0xFFL));
        digest.update((byte)(val >>> 0 & 0xFFL));
    }

    public static void updateWithBoolean(MessageDigest digest, boolean val) {
        FBUtilities.updateWithByte(digest, val ? 0 : 1);
    }

    public static void closeAll(List<? extends AutoCloseable> l) throws Exception {
        Exception toThrow = null;
        for (AutoCloseable autoCloseable : l) {
            try {
                autoCloseable.close();
            }
            catch (Exception e) {
                if (toThrow == null) {
                    toThrow = e;
                    continue;
                }
                toThrow.addSuppressed(e);
            }
        }
        if (toThrow != null) {
            throw toThrow;
        }
    }

    public static byte[] toWriteUTFBytes(String s) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(baos);
            dos.writeUTF(s);
            dos.flush();
            return baos.toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void sleepQuietly(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public static long align(long val, int boundary) {
        return val + (long)boundary & (long)(~(boundary - 1));
    }

    @VisibleForTesting
    protected static void reset() {
        localInetAddress = null;
        broadcastInetAddress = null;
        broadcastRpcAddress = null;
    }

    static {
        localMD5Digest = new ThreadLocal<MessageDigest>(){

            @Override
            protected MessageDigest initialValue() {
                return FBUtilities.newMessageDigest("MD5");
            }

            @Override
            public MessageDigest get() {
                MessageDigest digest = (MessageDigest)super.get();
                digest.reset();
                return digest;
            }
        };
    }

    private static final class WrappedCloseableIterator<T>
    extends AbstractIterator<T>
    implements CloseableIterator<T> {
        private final Iterator<T> source;

        public WrappedCloseableIterator(Iterator<T> source) {
            this.source = source;
        }

        @Override
        protected T computeNext() {
            if (!this.source.hasNext()) {
                return (T)this.endOfData();
            }
            return this.source.next();
        }

        @Override
        public void close() {
        }
    }
}

