/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.index.sasi.disk;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.Uninterruptibles;
import java.io.File;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.cassandra.concurrent.JMXEnabledThreadPoolExecutor;
import org.apache.cassandra.concurrent.NamedThreadFactory;
import org.apache.cassandra.config.ColumnDefinition;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.compaction.OperationType;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.rows.Row;
import org.apache.cassandra.db.rows.Unfiltered;
import org.apache.cassandra.index.sasi.analyzer.AbstractAnalyzer;
import org.apache.cassandra.index.sasi.conf.ColumnIndex;
import org.apache.cassandra.index.sasi.disk.OnDiskIndex;
import org.apache.cassandra.index.sasi.disk.OnDiskIndexBuilder;
import org.apache.cassandra.index.sasi.utils.CombinedTermIterator;
import org.apache.cassandra.index.sasi.utils.TypeUtil;
import org.apache.cassandra.io.FSError;
import org.apache.cassandra.io.sstable.Descriptor;
import org.apache.cassandra.io.sstable.format.SSTableFlushObserver;
import org.apache.cassandra.io.util.FileUtils;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PerSSTableIndexWriter
implements SSTableFlushObserver {
    private static final Logger logger = LoggerFactory.getLogger(PerSSTableIndexWriter.class);
    private static final ThreadPoolExecutor INDEX_FLUSHER_MEMTABLE;
    private static final ThreadPoolExecutor INDEX_FLUSHER_GENERAL;
    private final int nowInSec = FBUtilities.nowInSeconds();
    private final Descriptor descriptor;
    private final OperationType source;
    private final AbstractType<?> keyValidator;
    private final Map<ColumnDefinition, ColumnIndex> supportedIndexes;
    @VisibleForTesting
    protected final Map<ColumnDefinition, Index> indexes;
    private DecoratedKey currentKey;
    private long currentKeyPosition;
    private boolean isComplete;

    public PerSSTableIndexWriter(AbstractType<?> keyValidator, Descriptor descriptor, OperationType source, Map<ColumnDefinition, ColumnIndex> supportedIndexes) {
        this.keyValidator = keyValidator;
        this.descriptor = descriptor;
        this.source = source;
        this.supportedIndexes = supportedIndexes;
        this.indexes = new HashMap<ColumnDefinition, Index>();
    }

    @Override
    public void begin() {
    }

    @Override
    public void startPartition(DecoratedKey key, long curPosition) {
        this.currentKey = key;
        this.currentKeyPosition = curPosition;
    }

    @Override
    public void nextUnfilteredCluster(Unfiltered unfiltered) {
        if (!unfiltered.isRow()) {
            return;
        }
        Row row = (Row)unfiltered;
        this.supportedIndexes.keySet().forEach(column -> {
            ByteBuffer value = ColumnIndex.getValueOf(column, row, this.nowInSec);
            if (value == null) {
                return;
            }
            ColumnIndex columnIndex = this.supportedIndexes.get(column);
            if (columnIndex == null) {
                return;
            }
            Index index = this.indexes.get(column);
            if (index == null) {
                index = this.newIndex(columnIndex);
                this.indexes.put((ColumnDefinition)column, index);
            }
            index.add(value.duplicate(), this.currentKey, this.currentKeyPosition);
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void complete() {
        if (this.isComplete) {
            return;
        }
        this.currentKey = null;
        try {
            CountDownLatch latch = new CountDownLatch(this.indexes.size());
            for (Index index : this.indexes.values()) {
                index.complete(latch);
            }
            Uninterruptibles.awaitUninterruptibly((CountDownLatch)latch);
        }
        finally {
            this.indexes.clear();
            this.isComplete = true;
        }
    }

    public Index getIndex(ColumnDefinition columnDef) {
        return this.indexes.get(columnDef);
    }

    public Descriptor getDescriptor() {
        return this.descriptor;
    }

    @VisibleForTesting
    protected Index newIndex(ColumnIndex columnIndex) {
        return new Index(columnIndex);
    }

    protected long maxMemorySize(ColumnIndex columnIndex) {
        return this.source == OperationType.FLUSH ? 0x40000000L : columnIndex.getMode().maxCompactionFlushMemoryInMb;
    }

    public int hashCode() {
        return this.descriptor.hashCode();
    }

    public boolean equals(Object o) {
        return o != null && o instanceof PerSSTableIndexWriter && this.descriptor.equals(((PerSSTableIndexWriter)o).descriptor);
    }

    static {
        INDEX_FLUSHER_GENERAL = new JMXEnabledThreadPoolExecutor(1, 8, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new NamedThreadFactory("SASI-General"), "internal");
        INDEX_FLUSHER_GENERAL.allowCoreThreadTimeOut(true);
        INDEX_FLUSHER_MEMTABLE = new JMXEnabledThreadPoolExecutor(1, 8, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new NamedThreadFactory("SASI-Memtable"), "internal");
        INDEX_FLUSHER_MEMTABLE.allowCoreThreadTimeOut(true);
    }

    @VisibleForTesting
    protected class Index {
        @VisibleForTesting
        protected final String outputFile;
        private final ColumnIndex columnIndex;
        private final AbstractAnalyzer analyzer;
        private final long maxMemorySize;
        @VisibleForTesting
        protected final Set<Future<OnDiskIndex>> segments;
        private int segmentNumber = 0;
        private OnDiskIndexBuilder currentBuilder;

        public Index(ColumnIndex columnIndex) {
            this.columnIndex = columnIndex;
            this.outputFile = PerSSTableIndexWriter.this.descriptor.filenameFor(columnIndex.getComponent());
            this.analyzer = columnIndex.getAnalyzer();
            this.segments = new HashSet<Future<OnDiskIndex>>();
            this.maxMemorySize = PerSSTableIndexWriter.this.maxMemorySize(columnIndex);
            this.currentBuilder = this.newIndexBuilder();
        }

        public void add(ByteBuffer term, DecoratedKey key, long keyPosition) {
            if (term.remaining() == 0) {
                return;
            }
            boolean isAdded = false;
            this.analyzer.reset(term);
            while (this.analyzer.hasNext()) {
                ByteBuffer token = this.analyzer.next();
                int size = token.remaining();
                if (token.remaining() >= 1024) {
                    logger.info("Rejecting value (size {}, maximum {}) for column {} (analyzed {}) at {} SSTable.", new Object[]{FBUtilities.prettyPrintMemory(term.remaining()), FBUtilities.prettyPrintMemory(1024L), this.columnIndex.getColumnName(), this.columnIndex.getMode().isAnalyzed, PerSSTableIndexWriter.this.descriptor});
                    continue;
                }
                if (!TypeUtil.isValid(token, this.columnIndex.getValidator()) && (token = TypeUtil.tryUpcast(token, this.columnIndex.getValidator())) == null) {
                    logger.info("({}) Failed to add {} to index for key: {}, value size was {}, validator is {}.", new Object[]{this.outputFile, this.columnIndex.getColumnName(), PerSSTableIndexWriter.this.keyValidator.getString(key.getKey()), FBUtilities.prettyPrintMemory(size), this.columnIndex.getValidator()});
                    continue;
                }
                this.currentBuilder.add(token, key, keyPosition);
                isAdded = true;
            }
            if (!isAdded || this.currentBuilder.estimatedMemoryUse() < this.maxMemorySize) {
                return;
            }
            this.segments.add(this.getExecutor().submit(this.scheduleSegmentFlush(false)));
        }

        @VisibleForTesting
        protected Callable<OnDiskIndex> scheduleSegmentFlush(boolean isFinal) {
            OnDiskIndexBuilder builder = this.currentBuilder;
            this.currentBuilder = this.newIndexBuilder();
            String segmentFile = this.filename(isFinal);
            return () -> {
                long start = System.nanoTime();
                try {
                    File index = new File(segmentFile);
                    OnDiskIndex onDiskIndex = builder.finish(index) ? new OnDiskIndex(index, this.columnIndex.getValidator(), null) : null;
                    return onDiskIndex;
                }
                catch (Exception | FSError e) {
                    logger.error("Failed to build index segment {}", (Object)segmentFile, (Object)e);
                    OnDiskIndex onDiskIndex = null;
                    return onDiskIndex;
                }
                finally {
                    if (!isFinal) {
                        logger.info("Flushed index segment {}, took {} ms.", (Object)segmentFile, (Object)TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - start));
                    }
                }
            };
        }

        public void complete(CountDownLatch latch) {
            logger.info("Scheduling index flush to {}", (Object)this.outputFile);
            this.getExecutor().submit(() -> {
                long start1 = System.nanoTime();
                OnDiskIndex[] parts = new OnDiskIndex[this.segments.size() + 1];
                try {
                    if (this.segments.isEmpty()) {
                        this.scheduleSegmentFlush(true).call();
                        return;
                    }
                    if (!this.currentBuilder.isEmpty()) {
                        OnDiskIndex last = this.scheduleSegmentFlush(false).call();
                        this.segments.add((Future<OnDiskIndex>)Futures.immediateFuture((Object)last));
                    }
                    int index = 0;
                    ByteBuffer combinedMin = null;
                    ByteBuffer combinedMax = null;
                    for (Future<OnDiskIndex> f : this.segments) {
                        OnDiskIndex part = f.get();
                        if (part == null) continue;
                        parts[index++] = part;
                        combinedMin = combinedMin == null || PerSSTableIndexWriter.this.keyValidator.compare(combinedMin, part.minKey()) > 0 ? part.minKey() : combinedMin;
                        combinedMax = combinedMax == null || PerSSTableIndexWriter.this.keyValidator.compare(combinedMax, part.maxKey()) < 0 ? part.maxKey() : combinedMax;
                    }
                    OnDiskIndexBuilder builder = this.newIndexBuilder();
                    builder.finish(Pair.create(combinedMin, combinedMax), new File(this.outputFile), new CombinedTermIterator(parts));
                }
                catch (Exception | FSError e) {
                    logger.error("Failed to flush index {}.", (Object)this.outputFile, (Object)e);
                    FileUtils.delete(this.outputFile);
                }
                finally {
                    logger.info("Index flush to {} took {} ms.", (Object)this.outputFile, (Object)TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - start1));
                    for (int segment = 0; segment < this.segmentNumber; ++segment) {
                        OnDiskIndex part = parts[segment];
                        if (part != null) {
                            FileUtils.closeQuietly(part);
                        }
                        FileUtils.delete(this.outputFile + "_" + segment);
                    }
                    latch.countDown();
                }
            });
        }

        private ExecutorService getExecutor() {
            return PerSSTableIndexWriter.this.source == OperationType.FLUSH ? INDEX_FLUSHER_MEMTABLE : INDEX_FLUSHER_GENERAL;
        }

        private OnDiskIndexBuilder newIndexBuilder() {
            return new OnDiskIndexBuilder(PerSSTableIndexWriter.this.keyValidator, this.columnIndex.getValidator(), this.columnIndex.getMode().mode);
        }

        public String filename(boolean isFinal) {
            return this.outputFile + (isFinal ? "" : "_" + this.segmentNumber++);
        }
    }
}

