/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.statements;

import org.apache.cassandra.auth.DataResource;
import org.apache.cassandra.auth.IResource;
import org.apache.cassandra.cql3.CQLStatement;
import org.apache.cassandra.cql3.QueryOptions;
import org.apache.cassandra.cql3.statements.ParsedStatement;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.exceptions.RequestExecutionException;
import org.apache.cassandra.exceptions.RequestValidationException;
import org.apache.cassandra.service.ClientState;
import org.apache.cassandra.service.QueryState;
import org.apache.cassandra.transport.messages.ResultMessage;

public abstract class AuthorizationStatement
extends ParsedStatement
implements CQLStatement {
    @Override
    public ParsedStatement.Prepared prepare() {
        return new ParsedStatement.Prepared(this);
    }

    @Override
    public int getBoundTerms() {
        return 0;
    }

    @Override
    public ResultMessage execute(QueryState state, QueryOptions options, long queryStartNanoTime) throws RequestValidationException, RequestExecutionException {
        return this.execute(state.getClientState());
    }

    public abstract ResultMessage execute(ClientState var1) throws RequestValidationException, RequestExecutionException;

    @Override
    public ResultMessage executeInternal(QueryState state, QueryOptions options) {
        throw new UnsupportedOperationException();
    }

    public static IResource maybeCorrectResource(IResource resource, ClientState state) throws InvalidRequestException {
        DataResource dataResource;
        if (DataResource.class.isInstance(resource) && (dataResource = (DataResource)resource).isTableLevel() && dataResource.getKeyspace() == null) {
            return DataResource.table(state.getKeyspace(), dataResource.getTable());
        }
        return resource;
    }
}

