/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.utils;

import com.google.common.base.Function;
import com.google.common.util.concurrent.Uninterruptibles;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.cassandra.concurrent.DebuggableScheduledThreadPoolExecutor;
import org.apache.cassandra.utils.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExpiringMap<K, V> {
    private static final Logger logger = LoggerFactory.getLogger(ExpiringMap.class);
    private volatile boolean shutdown;
    private static final ScheduledExecutorService service = new DebuggableScheduledThreadPoolExecutor("EXPIRING-MAP-REAPER");
    private final ConcurrentMap<K, CacheableObject<V>> cache = new ConcurrentHashMap<K, CacheableObject<V>>();
    private final long defaultExpiration;

    public ExpiringMap(long defaultExpiration) {
        this(defaultExpiration, null);
    }

    public ExpiringMap(long defaultExpiration, final Function<Pair<K, CacheableObject<V>>, ?> postExpireHook) {
        this.defaultExpiration = defaultExpiration;
        if (defaultExpiration <= 0L) {
            throw new IllegalArgumentException("Argument specified must be a positive number");
        }
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                long start = System.nanoTime();
                int n = 0;
                for (Map.Entry entry : ExpiringMap.this.cache.entrySet()) {
                    if (!((CacheableObject)entry.getValue()).isReadyToDieAt(start) || ExpiringMap.this.cache.remove(entry.getKey()) == null) continue;
                    ++n;
                    if (postExpireHook == null) continue;
                    postExpireHook.apply(Pair.create(entry.getKey(), entry.getValue()));
                }
                logger.trace("Expired {} entries", (Object)n);
            }
        };
        service.scheduleWithFixedDelay(runnable, defaultExpiration / 2L, defaultExpiration / 2L, TimeUnit.MILLISECONDS);
    }

    public void shutdownBlocking() {
        service.shutdown();
        try {
            service.awaitTermination(this.defaultExpiration * 2L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public void reset() {
        this.shutdown = false;
        this.cache.clear();
    }

    public V put(K key, V value) {
        return this.put(key, value, this.defaultExpiration);
    }

    public V put(K key, V value, long timeout) {
        CacheableObject previous;
        if (this.shutdown) {
            Uninterruptibles.sleepUninterruptibly((long)Long.MAX_VALUE, (TimeUnit)TimeUnit.NANOSECONDS);
        }
        return (previous = this.cache.put(key, new CacheableObject(value, timeout))) == null ? null : (V)previous.value;
    }

    public V get(K key) {
        CacheableObject co = (CacheableObject)this.cache.get(key);
        return co == null ? null : (V)co.value;
    }

    public V remove(K key) {
        CacheableObject co = (CacheableObject)this.cache.remove(key);
        return co == null ? null : (V)co.value;
    }

    public long getAge(K key) {
        CacheableObject co = (CacheableObject)this.cache.get(key);
        return co == null ? 0L : co.createdAt;
    }

    public int size() {
        return this.cache.size();
    }

    public boolean containsKey(K key) {
        return this.cache.containsKey(key);
    }

    public boolean isEmpty() {
        return this.cache.isEmpty();
    }

    public Set<K> keySet() {
        return this.cache.keySet();
    }

    public static class CacheableObject<T> {
        public final T value;
        public final long timeout;
        private final long createdAt;

        private CacheableObject(T value, long timeout) {
            assert (value != null);
            this.value = value;
            this.timeout = timeout;
            this.createdAt = System.nanoTime();
        }

        private boolean isReadyToDieAt(long atNano) {
            return atNano - this.createdAt > TimeUnit.MILLISECONDS.toNanos(this.timeout);
        }
    }
}

