/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.compaction;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.Callable;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.Directories;
import org.apache.cassandra.db.Memtable;
import org.apache.cassandra.db.SerializationHeader;
import org.apache.cassandra.db.compaction.AbstractCompactionStrategy;
import org.apache.cassandra.db.compaction.AbstractCompactionTask;
import org.apache.cassandra.db.compaction.LeveledCompactionStrategy;
import org.apache.cassandra.db.compaction.LeveledManifest;
import org.apache.cassandra.db.lifecycle.LifecycleTransaction;
import org.apache.cassandra.db.lifecycle.SSTableSet;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.io.sstable.Descriptor;
import org.apache.cassandra.io.sstable.ISSTableScanner;
import org.apache.cassandra.io.sstable.SSTableMultiWriter;
import org.apache.cassandra.io.sstable.format.SSTableReader;
import org.apache.cassandra.io.sstable.metadata.MetadataCollector;
import org.apache.cassandra.notifications.INotification;
import org.apache.cassandra.notifications.INotificationConsumer;
import org.apache.cassandra.notifications.SSTableAddedNotification;
import org.apache.cassandra.notifications.SSTableDeletingNotification;
import org.apache.cassandra.notifications.SSTableListChangedNotification;
import org.apache.cassandra.notifications.SSTableRepairStatusChanged;
import org.apache.cassandra.schema.CompactionParams;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompactionStrategyManager
implements INotificationConsumer {
    private static final Logger logger = LoggerFactory.getLogger(CompactionStrategyManager.class);
    private final ColumnFamilyStore cfs;
    private volatile AbstractCompactionStrategy repaired;
    private volatile AbstractCompactionStrategy unrepaired;
    private volatile boolean enabled = true;
    public boolean isActive = true;
    private volatile CompactionParams params;
    private CompactionParams schemaCompactionParams;

    public CompactionStrategyManager(ColumnFamilyStore cfs) {
        cfs.getTracker().subscribe(this);
        logger.trace("{} subscribed to the data tracker.", (Object)this);
        this.cfs = cfs;
        this.reload(cfs.metadata);
        this.params = cfs.metadata.params.compaction;
        this.enabled = this.params.isEnabled();
    }

    public synchronized AbstractCompactionTask getNextBackgroundTask(int gcBefore) {
        if (!this.isEnabled()) {
            return null;
        }
        this.maybeReload(this.cfs.metadata);
        if (this.repaired.getEstimatedRemainingTasks() > this.unrepaired.getEstimatedRemainingTasks()) {
            AbstractCompactionTask repairedTask = this.repaired.getNextBackgroundTask(gcBefore);
            if (repairedTask != null) {
                return repairedTask;
            }
            return this.unrepaired.getNextBackgroundTask(gcBefore);
        }
        AbstractCompactionTask unrepairedTask = this.unrepaired.getNextBackgroundTask(gcBefore);
        if (unrepairedTask != null) {
            return unrepairedTask;
        }
        return this.repaired.getNextBackgroundTask(gcBefore);
    }

    public boolean isEnabled() {
        return this.enabled && this.isActive;
    }

    public synchronized void resume() {
        this.isActive = true;
    }

    public synchronized void pause() {
        this.isActive = false;
    }

    private void startup() {
        for (SSTableReader sstable : this.cfs.getSSTables(SSTableSet.CANONICAL)) {
            if (sstable.openReason == SSTableReader.OpenReason.EARLY) continue;
            this.getCompactionStrategyFor(sstable).addSSTable(sstable);
        }
        this.repaired.startup();
        this.unrepaired.startup();
    }

    private AbstractCompactionStrategy getCompactionStrategyFor(SSTableReader sstable) {
        if (sstable.isRepaired()) {
            return this.repaired;
        }
        return this.unrepaired;
    }

    public void shutdown() {
        this.isActive = false;
        this.repaired.shutdown();
        this.unrepaired.shutdown();
    }

    public synchronized void maybeReload(CFMetaData metadata) {
        if (metadata.params.compaction.equals(this.schemaCompactionParams)) {
            return;
        }
        this.reload(metadata);
    }

    public synchronized void reload(CFMetaData metadata) {
        boolean disabledWithJMX = !this.enabled && this.shouldBeEnabled();
        this.setStrategy(metadata.params.compaction);
        this.schemaCompactionParams = metadata.params.compaction;
        if (disabledWithJMX || !this.shouldBeEnabled()) {
            this.disable();
        } else {
            this.enable();
        }
        this.startup();
    }

    public void replaceFlushed(Memtable memtable, Collection<SSTableReader> sstables) {
    }

    public int getUnleveledSSTables() {
        if (this.repaired instanceof LeveledCompactionStrategy && this.unrepaired instanceof LeveledCompactionStrategy) {
            int count = 0;
            count += ((LeveledCompactionStrategy)this.repaired).getLevelSize(0);
            return count += ((LeveledCompactionStrategy)this.unrepaired).getLevelSize(0);
        }
        return 0;
    }

    public synchronized int[] getSSTableCountPerLevel() {
        if (this.repaired instanceof LeveledCompactionStrategy && this.unrepaired instanceof LeveledCompactionStrategy) {
            int[] res = new int[LeveledManifest.MAX_LEVEL_COUNT];
            int[] repairedCountPerLevel = ((LeveledCompactionStrategy)this.repaired).getAllLevelSize();
            res = CompactionStrategyManager.sumArrays(res, repairedCountPerLevel);
            int[] unrepairedCountPerLevel = ((LeveledCompactionStrategy)this.unrepaired).getAllLevelSize();
            res = CompactionStrategyManager.sumArrays(res, unrepairedCountPerLevel);
            return res;
        }
        return null;
    }

    private static int[] sumArrays(int[] a, int[] b) {
        int[] res = new int[Math.max(a.length, b.length)];
        for (int i = 0; i < res.length; ++i) {
            res[i] = i < a.length && i < b.length ? a[i] + b[i] : (i < a.length ? a[i] : b[i]);
        }
        return res;
    }

    public boolean shouldDefragment() {
        assert (this.repaired.getClass().equals(this.unrepaired.getClass()));
        return this.repaired.shouldDefragment();
    }

    public Directories getDirectories() {
        assert (this.repaired.getClass().equals(this.unrepaired.getClass()));
        return this.repaired.getDirectories();
    }

    @Override
    public synchronized void handleNotification(INotification notification, Object sender) {
        if (notification instanceof SSTableAddedNotification) {
            SSTableAddedNotification flushedNotification = (SSTableAddedNotification)notification;
            for (SSTableReader sstable : flushedNotification.added) {
                if (sstable.isRepaired()) {
                    this.repaired.addSSTable(sstable);
                    continue;
                }
                this.unrepaired.addSSTable(sstable);
            }
        } else if (notification instanceof SSTableListChangedNotification) {
            SSTableListChangedNotification listChangedNotification = (SSTableListChangedNotification)notification;
            HashSet<SSTableReader> repairedRemoved = new HashSet<SSTableReader>();
            HashSet<SSTableReader> repairedAdded = new HashSet<SSTableReader>();
            HashSet<SSTableReader> unrepairedRemoved = new HashSet<SSTableReader>();
            HashSet<SSTableReader> unrepairedAdded = new HashSet<SSTableReader>();
            for (SSTableReader sstable : listChangedNotification.removed) {
                if (sstable.isRepaired()) {
                    repairedRemoved.add(sstable);
                    continue;
                }
                unrepairedRemoved.add(sstable);
            }
            for (SSTableReader sstable : listChangedNotification.added) {
                if (sstable.isRepaired()) {
                    repairedAdded.add(sstable);
                    continue;
                }
                unrepairedAdded.add(sstable);
            }
            if (!repairedRemoved.isEmpty()) {
                this.repaired.replaceSSTables(repairedRemoved, repairedAdded);
            } else {
                for (SSTableReader sstable : repairedAdded) {
                    this.repaired.addSSTable(sstable);
                }
            }
            if (!unrepairedRemoved.isEmpty()) {
                this.unrepaired.replaceSSTables(unrepairedRemoved, unrepairedAdded);
            } else {
                for (SSTableReader sstable : unrepairedAdded) {
                    this.unrepaired.addSSTable(sstable);
                }
            }
        } else if (notification instanceof SSTableRepairStatusChanged) {
            for (SSTableReader sstable : ((SSTableRepairStatusChanged)notification).sstable) {
                if (sstable.isRepaired()) {
                    this.unrepaired.removeSSTable(sstable);
                    this.repaired.addSSTable(sstable);
                    continue;
                }
                this.repaired.removeSSTable(sstable);
                this.unrepaired.addSSTable(sstable);
            }
        } else if (notification instanceof SSTableDeletingNotification) {
            SSTableReader sstable = ((SSTableDeletingNotification)notification).deleting;
            if (sstable.isRepaired()) {
                this.repaired.removeSSTable(sstable);
            } else {
                this.unrepaired.removeSSTable(sstable);
            }
        }
    }

    public void enable() {
        if (this.repaired != null) {
            this.repaired.enable();
        }
        if (this.unrepaired != null) {
            this.unrepaired.enable();
        }
        this.enabled = true;
    }

    public void disable() {
        this.enabled = false;
        if (this.repaired != null) {
            this.repaired.disable();
        }
        if (this.unrepaired != null) {
            this.unrepaired.disable();
        }
    }

    public synchronized AbstractCompactionStrategy.ScannerList getScanners(Collection<SSTableReader> sstables, Collection<Range<Token>> ranges) {
        ArrayList<SSTableReader> repairedSSTables = new ArrayList<SSTableReader>();
        ArrayList<SSTableReader> unrepairedSSTables = new ArrayList<SSTableReader>();
        for (SSTableReader sstable : sstables) {
            if (sstable.isRepaired()) {
                repairedSSTables.add(sstable);
                continue;
            }
            unrepairedSSTables.add(sstable);
        }
        HashSet<ISSTableScanner> scanners = new HashSet<ISSTableScanner>(sstables.size());
        AbstractCompactionStrategy.ScannerList repairedScanners = this.repaired.getScanners(repairedSSTables, ranges);
        AbstractCompactionStrategy.ScannerList unrepairedScanners = this.unrepaired.getScanners(unrepairedSSTables, ranges);
        scanners.addAll(repairedScanners.scanners);
        scanners.addAll(unrepairedScanners.scanners);
        return new AbstractCompactionStrategy.ScannerList(new ArrayList<ISSTableScanner>(scanners));
    }

    public synchronized AbstractCompactionStrategy.ScannerList getScanners(Collection<SSTableReader> sstables) {
        return this.getScanners(sstables, null);
    }

    public Collection<Collection<SSTableReader>> groupSSTablesForAntiCompaction(Collection<SSTableReader> sstablesToGroup) {
        return this.unrepaired.groupSSTablesForAntiCompaction(sstablesToGroup);
    }

    public long getMaxSSTableBytes() {
        return this.unrepaired.getMaxSSTableBytes();
    }

    public AbstractCompactionTask getCompactionTask(LifecycleTransaction txn, int gcBefore, long maxSSTableBytes) {
        return this.getCompactionStrategyFor(txn.originals().iterator().next()).getCompactionTask(txn, gcBefore, maxSSTableBytes);
    }

    public Collection<AbstractCompactionTask> getMaximalTasks(final int gcBefore, final boolean splitOutput) {
        return this.cfs.runWithCompactionsDisabled(new Callable<Collection<AbstractCompactionTask>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Collection<AbstractCompactionTask> call() throws Exception {
                CompactionStrategyManager compactionStrategyManager = CompactionStrategyManager.this;
                synchronized (compactionStrategyManager) {
                    Collection<AbstractCompactionTask> repairedTasks = CompactionStrategyManager.this.repaired.getMaximalTask(gcBefore, splitOutput);
                    Collection<AbstractCompactionTask> unrepairedTasks = CompactionStrategyManager.this.unrepaired.getMaximalTask(gcBefore, splitOutput);
                    if (repairedTasks == null && unrepairedTasks == null) {
                        return null;
                    }
                    if (repairedTasks == null) {
                        return unrepairedTasks;
                    }
                    if (unrepairedTasks == null) {
                        return repairedTasks;
                    }
                    ArrayList<AbstractCompactionTask> tasks = new ArrayList<AbstractCompactionTask>();
                    tasks.addAll(repairedTasks);
                    tasks.addAll(unrepairedTasks);
                    return tasks;
                }
            }
        }, false, false);
    }

    public AbstractCompactionTask getUserDefinedTask(Collection<SSTableReader> sstables, int gcBefore) {
        return this.getCompactionStrategyFor(sstables.iterator().next()).getUserDefinedTask(sstables, gcBefore);
    }

    public int getEstimatedRemainingTasks() {
        int tasks = 0;
        tasks += this.repaired.getEstimatedRemainingTasks();
        return tasks += this.unrepaired.getEstimatedRemainingTasks();
    }

    public boolean shouldBeEnabled() {
        return this.params.isEnabled();
    }

    public String getName() {
        return this.unrepaired.getName();
    }

    public List<AbstractCompactionStrategy> getStrategies() {
        return Arrays.asList(this.repaired, this.unrepaired);
    }

    public synchronized void setNewLocalCompactionStrategy(CompactionParams params) {
        logger.info("Switching local compaction strategy from {} to {}}", (Object)this.params, (Object)params);
        this.setStrategy(params);
        if (this.shouldBeEnabled()) {
            this.enable();
        } else {
            this.disable();
        }
        this.startup();
    }

    private void setStrategy(CompactionParams params) {
        if (this.repaired != null) {
            this.repaired.shutdown();
        }
        if (this.unrepaired != null) {
            this.unrepaired.shutdown();
        }
        this.repaired = CFMetaData.createCompactionStrategyInstance(this.cfs, params);
        this.unrepaired = CFMetaData.createCompactionStrategyInstance(this.cfs, params);
        this.params = params;
    }

    public CompactionParams getCompactionParams() {
        return this.params;
    }

    public boolean onlyPurgeRepairedTombstones() {
        return Boolean.parseBoolean(this.params.options().get("only_purge_repaired_tombstones"));
    }

    public SSTableMultiWriter createSSTableMultiWriter(Descriptor descriptor, long keyCount, long repairedAt, MetadataCollector collector, SerializationHeader header, LifecycleTransaction txn) {
        if (repairedAt == 0L) {
            return this.unrepaired.createSSTableMultiWriter(descriptor, keyCount, repairedAt, collector, header, txn);
        }
        return this.repaired.createSSTableMultiWriter(descriptor, keyCount, repairedAt, collector, header, txn);
    }

    public boolean supportsEarlyOpen() {
        return this.repaired.supportsEarlyOpen();
    }
}

