/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.cassandra.cql3.AbstractMarker;
import org.apache.cassandra.cql3.AssignmentTestable;
import org.apache.cassandra.cql3.ColumnIdentifier;
import org.apache.cassandra.cql3.ColumnSpecification;
import org.apache.cassandra.cql3.QueryOptions;
import org.apache.cassandra.cql3.Term;
import org.apache.cassandra.cql3.Terms;
import org.apache.cassandra.cql3.VariableSpecifications;
import org.apache.cassandra.cql3.functions.Function;
import org.apache.cassandra.db.marshal.ListType;
import org.apache.cassandra.db.marshal.TupleType;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.serializers.ListSerializer;
import org.apache.cassandra.serializers.MarshalException;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Tuples {
    private static final Logger logger = LoggerFactory.getLogger(Tuples.class);

    private Tuples() {
    }

    public static ColumnSpecification componentSpecOf(ColumnSpecification column, int component) {
        return new ColumnSpecification(column.ksName, column.cfName, new ColumnIdentifier(String.format("%s[%d]", column.name, component), true), ((TupleType)column.type).type(component));
    }

    public static String tupleToString(List<?> items) {
        StringBuilder sb = new StringBuilder("(");
        for (int i = 0; i < items.size(); ++i) {
            sb.append(items.get(i));
            if (i >= items.size() - 1) continue;
            sb.append(", ");
        }
        sb.append(')');
        return sb.toString();
    }

    public static class InMarker
    extends AbstractMarker {
        protected InMarker(int bindIndex, ColumnSpecification receiver) {
            super(bindIndex, receiver);
            assert (receiver.type instanceof ListType);
        }

        @Override
        public InValue bind(QueryOptions options) throws InvalidRequestException {
            ByteBuffer value = options.getValues().get(this.bindIndex);
            if (value == ByteBufferUtil.UNSET_BYTE_BUFFER) {
                throw new InvalidRequestException(String.format("Invalid unset value for %s", this.receiver.name));
            }
            return value == null ? null : InValue.fromSerialized(value, (ListType)this.receiver.type, options);
        }
    }

    public static class Marker
    extends AbstractMarker {
        public Marker(int bindIndex, ColumnSpecification receiver) {
            super(bindIndex, receiver);
        }

        @Override
        public Value bind(QueryOptions options) throws InvalidRequestException {
            ByteBuffer value = options.getValues().get(this.bindIndex);
            if (value == ByteBufferUtil.UNSET_BYTE_BUFFER) {
                throw new InvalidRequestException(String.format("Invalid unset value for tuple %s", this.receiver.name));
            }
            return value == null ? null : Value.fromSerialized(value, (TupleType)this.receiver.type);
        }
    }

    public static class INRaw
    extends AbstractMarker.MultiColumnRaw {
        public INRaw(int bindIndex) {
            super(bindIndex);
        }

        private static ColumnSpecification makeInReceiver(List<? extends ColumnSpecification> receivers) throws InvalidRequestException {
            ArrayList types = new ArrayList(receivers.size());
            StringBuilder inName = new StringBuilder("in(");
            for (int i = 0; i < receivers.size(); ++i) {
                ColumnSpecification receiver = receivers.get(i);
                inName.append(receiver.name);
                if (i < receivers.size() - 1) {
                    inName.append(",");
                }
                if (receiver.type.isCollection() && receiver.type.isMultiCell()) {
                    throw new InvalidRequestException("Non-frozen collection columns do not support IN relations");
                }
                types.add(receiver.type);
            }
            inName.append(')');
            ColumnIdentifier identifier = new ColumnIdentifier(inName.toString(), true);
            TupleType type = new TupleType(types);
            return new ColumnSpecification(receivers.get((int)0).ksName, receivers.get((int)0).cfName, identifier, ListType.getInstance(type, false));
        }

        @Override
        public AbstractMarker prepare(String keyspace, List<? extends ColumnSpecification> receivers) throws InvalidRequestException {
            return new InMarker(this.bindIndex, INRaw.makeInReceiver(receivers));
        }
    }

    public static class Raw
    extends AbstractMarker.MultiColumnRaw {
        public Raw(int bindIndex) {
            super(bindIndex);
        }

        private static ColumnSpecification makeReceiver(List<? extends ColumnSpecification> receivers) {
            ArrayList types = new ArrayList(receivers.size());
            StringBuilder inName = new StringBuilder("(");
            for (int i = 0; i < receivers.size(); ++i) {
                ColumnSpecification receiver = receivers.get(i);
                inName.append(receiver.name);
                if (i < receivers.size() - 1) {
                    inName.append(",");
                }
                types.add(receiver.type);
            }
            inName.append(')');
            ColumnIdentifier identifier = new ColumnIdentifier(inName.toString(), true);
            TupleType type = new TupleType(types);
            return new ColumnSpecification(receivers.get((int)0).ksName, receivers.get((int)0).cfName, identifier, type);
        }

        @Override
        public AbstractMarker prepare(String keyspace, List<? extends ColumnSpecification> receivers) throws InvalidRequestException {
            return new Marker(this.bindIndex, Raw.makeReceiver(receivers));
        }
    }

    public static class InValue
    extends Term.Terminal {
        List<List<ByteBuffer>> elements;

        public InValue(List<List<ByteBuffer>> items) {
            this.elements = items;
        }

        public static InValue fromSerialized(ByteBuffer value, ListType type, QueryOptions options) throws InvalidRequestException {
            try {
                Object l = ((ListSerializer)type.getSerializer()).deserializeForNativeProtocol(value, options.getProtocolVersion());
                assert (type.getElementsType() instanceof TupleType);
                TupleType tupleType = (TupleType)type.getElementsType();
                ArrayList<List<ByteBuffer>> elements = new ArrayList<List<ByteBuffer>>(l.size());
                Iterator iterator = l.iterator();
                while (iterator.hasNext()) {
                    Object element = iterator.next();
                    elements.add(Arrays.asList(tupleType.split(type.getElementsType().decompose(element))));
                }
                return new InValue(elements);
            }
            catch (MarshalException e) {
                throw new InvalidRequestException(e.getMessage());
            }
        }

        @Override
        public ByteBuffer get(int protocolVersion) {
            throw new UnsupportedOperationException();
        }

        public List<List<ByteBuffer>> getSplitValues() {
            return this.elements;
        }
    }

    public static class DelayedValue
    extends Term.NonTerminal {
        public final TupleType type;
        public final List<Term> elements;

        public DelayedValue(TupleType type, List<Term> elements) {
            this.type = type;
            this.elements = elements;
        }

        @Override
        public boolean containsBindMarker() {
            for (Term term : this.elements) {
                if (!term.containsBindMarker()) continue;
                return true;
            }
            return false;
        }

        @Override
        public void collectMarkerSpecification(VariableSpecifications boundNames) {
            for (Term term : this.elements) {
                term.collectMarkerSpecification(boundNames);
            }
        }

        private ByteBuffer[] bindInternal(QueryOptions options) throws InvalidRequestException {
            ByteBuffer[] buffers = new ByteBuffer[this.elements.size()];
            for (int i = 0; i < this.elements.size(); ++i) {
                buffers[i] = this.elements.get(i).bindAndGet(options);
                if (buffers[i] != ByteBufferUtil.UNSET_BYTE_BUFFER) continue;
                throw new InvalidRequestException(String.format("Invalid unset value for tuple field number %d", i));
            }
            return buffers;
        }

        @Override
        public Value bind(QueryOptions options) throws InvalidRequestException {
            return new Value(this.bindInternal(options));
        }

        @Override
        public ByteBuffer bindAndGet(QueryOptions options) throws InvalidRequestException {
            return TupleType.buildValue(this.bindInternal(options));
        }

        public String toString() {
            return Tuples.tupleToString(this.elements);
        }

        @Override
        public void addFunctionsTo(List<Function> functions) {
            Terms.addFunctions(this.elements, functions);
        }
    }

    public static class Value
    extends Term.MultiItemTerminal {
        public final ByteBuffer[] elements;

        public Value(ByteBuffer[] elements) {
            this.elements = elements;
        }

        public static Value fromSerialized(ByteBuffer bytes, TupleType type) {
            return new Value(type.split(bytes));
        }

        @Override
        public ByteBuffer get(int protocolVersion) {
            return TupleType.buildValue(this.elements);
        }

        @Override
        public List<ByteBuffer> getElements() {
            return Arrays.asList(this.elements);
        }
    }

    public static class Literal
    extends Term.MultiColumnRaw {
        private final List<Term.Raw> elements;

        public Literal(List<Term.Raw> elements) {
            this.elements = elements;
        }

        @Override
        public Term prepare(String keyspace, ColumnSpecification receiver) throws InvalidRequestException {
            this.validateAssignableTo(keyspace, receiver);
            ArrayList<Term> values = new ArrayList<Term>(this.elements.size());
            boolean allTerminal = true;
            for (int i = 0; i < this.elements.size(); ++i) {
                Term value = this.elements.get(i).prepare(keyspace, Tuples.componentSpecOf(receiver, i));
                if (value instanceof Term.NonTerminal) {
                    allTerminal = false;
                }
                values.add(value);
            }
            DelayedValue value = new DelayedValue((TupleType)receiver.type, values);
            return allTerminal ? value.bind(QueryOptions.DEFAULT) : value;
        }

        @Override
        public Term prepare(String keyspace, List<? extends ColumnSpecification> receivers) throws InvalidRequestException {
            if (this.elements.size() != receivers.size()) {
                throw new InvalidRequestException(String.format("Expected %d elements in value tuple, but got %d: %s", receivers.size(), this.elements.size(), this));
            }
            ArrayList<Term> values = new ArrayList<Term>(this.elements.size());
            ArrayList types = new ArrayList(this.elements.size());
            boolean allTerminal = true;
            for (int i = 0; i < this.elements.size(); ++i) {
                Term t = this.elements.get(i).prepare(keyspace, receivers.get(i));
                if (t instanceof Term.NonTerminal) {
                    allTerminal = false;
                }
                values.add(t);
                types.add(receivers.get((int)i).type);
            }
            DelayedValue value = new DelayedValue(new TupleType(types), values);
            return allTerminal ? value.bind(QueryOptions.DEFAULT) : value;
        }

        private void validateAssignableTo(String keyspace, ColumnSpecification receiver) throws InvalidRequestException {
            if (!(receiver.type instanceof TupleType)) {
                throw new InvalidRequestException(String.format("Invalid tuple type literal for %s of type %s", receiver.name, receiver.type.asCQL3Type()));
            }
            TupleType tt = (TupleType)receiver.type;
            for (int i = 0; i < this.elements.size(); ++i) {
                ColumnSpecification spec;
                if (i >= tt.size()) {
                    throw new InvalidRequestException(String.format("Invalid tuple literal for %s: too many elements. Type %s expects %d but got %d", receiver.name, tt.asCQL3Type(), tt.size(), this.elements.size()));
                }
                Term.Raw value = this.elements.get(i);
                if (value.testAssignment(keyspace, spec = Tuples.componentSpecOf(receiver, i)).isAssignable()) continue;
                throw new InvalidRequestException(String.format("Invalid tuple literal for %s: component %d is not of type %s", receiver.name, i, spec.type.asCQL3Type()));
            }
        }

        @Override
        public AssignmentTestable.TestResult testAssignment(String keyspace, ColumnSpecification receiver) {
            try {
                this.validateAssignableTo(keyspace, receiver);
                return AssignmentTestable.TestResult.WEAKLY_ASSIGNABLE;
            }
            catch (InvalidRequestException e) {
                return AssignmentTestable.TestResult.NOT_ASSIGNABLE;
            }
        }

        @Override
        public String getText() {
            return this.elements.stream().map(Term.Raw::getText).collect(Collectors.joining(", ", "(", ")"));
        }
    }
}

