/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.sstable.format.big;

import com.google.common.util.concurrent.RateLimiter;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import org.apache.cassandra.cache.KeyCacheKey;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.db.DataRange;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.PartitionPosition;
import org.apache.cassandra.db.RowIndexEntry;
import org.apache.cassandra.db.SerializationHeader;
import org.apache.cassandra.db.columniterator.SSTableIterator;
import org.apache.cassandra.db.columniterator.SSTableReversedIterator;
import org.apache.cassandra.db.filter.ColumnFilter;
import org.apache.cassandra.db.rows.SliceableUnfilteredRowIterator;
import org.apache.cassandra.dht.AbstractBounds;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.io.sstable.Component;
import org.apache.cassandra.io.sstable.CorruptSSTableException;
import org.apache.cassandra.io.sstable.Descriptor;
import org.apache.cassandra.io.sstable.ISSTableScanner;
import org.apache.cassandra.io.sstable.format.SSTableReader;
import org.apache.cassandra.io.sstable.format.big.BigTableScanner;
import org.apache.cassandra.io.sstable.metadata.StatsMetadata;
import org.apache.cassandra.io.util.FileDataInput;
import org.apache.cassandra.tracing.Tracing;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BigTableReader
extends SSTableReader {
    private static final Logger logger = LoggerFactory.getLogger(BigTableReader.class);

    BigTableReader(Descriptor desc, Set<Component> components, CFMetaData metadata, Long maxDataAge, StatsMetadata sstableMetadata, SSTableReader.OpenReason openReason, SerializationHeader header) {
        super(desc, components, metadata, maxDataAge, sstableMetadata, openReason, header);
    }

    @Override
    public SliceableUnfilteredRowIterator iterator(DecoratedKey key, ColumnFilter selectedColumns, boolean reversed, boolean isForThrift) {
        return reversed ? new SSTableReversedIterator(this, key, selectedColumns, isForThrift) : new SSTableIterator(this, key, selectedColumns, isForThrift);
    }

    @Override
    public SliceableUnfilteredRowIterator iterator(FileDataInput file, DecoratedKey key, RowIndexEntry indexEntry, ColumnFilter selectedColumns, boolean reversed, boolean isForThrift) {
        return reversed ? new SSTableReversedIterator(this, file, key, indexEntry, selectedColumns, isForThrift) : new SSTableIterator(this, file, key, indexEntry, selectedColumns, isForThrift);
    }

    @Override
    public ISSTableScanner getScanner(ColumnFilter columns, DataRange dataRange, RateLimiter limiter, boolean isForThrift) {
        return BigTableScanner.getScanner(this, columns, dataRange, limiter, isForThrift);
    }

    @Override
    public ISSTableScanner getScanner(Iterator<AbstractBounds<PartitionPosition>> boundsIterator) {
        return BigTableScanner.getScanner((SSTableReader)this, boundsIterator);
    }

    @Override
    public ISSTableScanner getScanner(RateLimiter limiter) {
        return BigTableScanner.getScanner((SSTableReader)this, limiter);
    }

    @Override
    public ISSTableScanner getScanner(Collection<Range<Token>> ranges, RateLimiter limiter) {
        return BigTableScanner.getScanner(this, ranges, limiter);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected RowIndexEntry getPosition(PartitionPosition key, SSTableReader.Operator op, boolean updateCacheAndStats, boolean permitMatchPastLast) {
        DecoratedKey decoratedKey;
        KeyCacheKey cacheKey;
        RowIndexEntry cachedPosition;
        if (op == SSTableReader.Operator.EQ) {
            assert (key instanceof DecoratedKey);
            if (!this.bf.isPresent((DecoratedKey)key)) {
                Tracing.trace("Bloom filter allows skipping sstable {}", (Object)this.descriptor.generation);
                return null;
            }
        }
        if ((op == SSTableReader.Operator.EQ || op == SSTableReader.Operator.GE) && key instanceof DecoratedKey && (cachedPosition = this.getCachedPosition(cacheKey = new KeyCacheKey(this.metadata.ksAndCFName, this.descriptor, (decoratedKey = (DecoratedKey)key).getKey()), updateCacheAndStats)) != null) {
            Tracing.trace("Key cache hit for sstable {}", (Object)this.descriptor.generation);
            return cachedPosition;
        }
        boolean skip = false;
        if (key.compareTo(this.first) < 0) {
            if (op == SSTableReader.Operator.EQ) {
                skip = true;
            } else {
                key = this.first;
            }
            op = SSTableReader.Operator.EQ;
        } else {
            int l = this.last.compareTo(key);
            boolean bl = skip = l <= 0 && (l < 0 || !permitMatchPastLast && op == SSTableReader.Operator.GT);
        }
        if (skip) {
            if (op == SSTableReader.Operator.EQ && updateCacheAndStats) {
                this.bloomFilterTracker.addFalsePositive();
            }
            Tracing.trace("Check against min and max keys allows skipping sstable {}", (Object)this.descriptor.generation);
            return null;
        }
        int binarySearchResult = this.indexSummary.binarySearch(key);
        long sampledPosition = BigTableReader.getIndexScanPositionFromBinarySearchResult(binarySearchResult, this.indexSummary);
        int sampledIndex = BigTableReader.getIndexSummaryIndexFromBinarySearchResult(binarySearchResult);
        int effectiveInterval = this.indexSummary.getEffectiveIndexIntervalAfterIndex(sampledIndex);
        if (this.ifile == null) {
            return null;
        }
        int i = 0;
        String path = null;
        try (FileDataInput in = this.ifile.createReader(sampledPosition);){
            path = in.getPath();
            while (!in.isEOF()) {
                boolean opSatisfied;
                boolean exactMatch;
                ByteBuffer indexKey = ByteBufferUtil.readWithShortLength(in);
                if (op == SSTableReader.Operator.EQ && ++i <= effectiveInterval) {
                    opSatisfied = exactMatch = indexKey.equals(((DecoratedKey)key).getKey());
                } else {
                    DecoratedKey indexDecoratedKey = this.decorateKey(indexKey);
                    int comparison = indexDecoratedKey.compareTo(key);
                    int v = op.apply(comparison);
                    opSatisfied = v == 0;
                    boolean bl = exactMatch = comparison == 0;
                    if (v < 0) {
                        Tracing.trace("Partition index lookup allows skipping sstable {}", (Object)this.descriptor.generation);
                        RowIndexEntry rowIndexEntry = null;
                        return rowIndexEntry;
                    }
                }
                if (opSatisfied) {
                    RowIndexEntry indexEntry = this.rowIndexEntrySerializer.deserialize(in);
                    if (exactMatch && updateCacheAndStats) {
                        assert (key instanceof DecoratedKey);
                        DecoratedKey decoratedKey2 = (DecoratedKey)key;
                        if (logger.isTraceEnabled()) {
                            try (FileDataInput fdi = this.dfile.createReader(indexEntry.position);){
                                DecoratedKey keyInDisk = this.decorateKey(ByteBufferUtil.readWithShortLength(fdi));
                                if (!keyInDisk.equals(key)) {
                                    throw new AssertionError((Object)String.format("%s != %s in %s", keyInDisk, key, fdi.getPath()));
                                }
                            }
                        }
                        this.cacheKey(decoratedKey2, indexEntry);
                    }
                    if (op == SSTableReader.Operator.EQ && updateCacheAndStats) {
                        this.bloomFilterTracker.addTruePositive();
                    }
                    Tracing.trace("Partition index with {} entries found for sstable {}", (Object)indexEntry.columnsIndex().size(), (Object)this.descriptor.generation);
                    RowIndexEntry rowIndexEntry = indexEntry;
                    return rowIndexEntry;
                }
                RowIndexEntry.Serializer.skip(in, this.descriptor.version);
            }
        }
        catch (IOException e) {
            this.markSuspect();
            throw new CorruptSSTableException((Exception)e, path);
        }
        if (op == SSTableReader.Operator.EQ && updateCacheAndStats) {
            this.bloomFilterTracker.addFalsePositive();
        }
        Tracing.trace("Partition index lookup complete (bloom filter false positive) for sstable {}", (Object)this.descriptor.generation);
        return null;
    }
}

