/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.tools.nodetool;

import com.google.common.collect.LinkedHashMultimap;
import io.airlift.command.Arguments;
import io.airlift.command.Command;
import io.airlift.command.Option;
import java.io.PrintStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.apache.cassandra.tools.NodeProbe;
import org.apache.cassandra.tools.NodeTool;
import org.apache.cassandra.tools.nodetool.HostStat;
import org.apache.cassandra.tools.nodetool.SetHostStat;

@Command(name="ring", description="Print information about the token ring")
public class Ring
extends NodeTool.NodeToolCmd {
    @Arguments(description="Specify a keyspace for accurate ownership information (topology awareness)")
    private String keyspace = null;
    @Option(title="resolve_ip", name={"-r", "--resolve-ip"}, description="Show node domain names instead of IPs")
    private boolean resolveIp = false;

    @Override
    public void execute(NodeProbe probe) {
        Map<InetAddress, Float> ownerships;
        PrintStream out = probe.output().out;
        Map<String, String> tokensToEndpoints = probe.getTokenToEndpointMap();
        LinkedHashMultimap endpointsToTokens = LinkedHashMultimap.create();
        boolean haveVnodes = false;
        for (Map.Entry<String, String> entry : tokensToEndpoints.entrySet()) {
            haveVnodes |= endpointsToTokens.containsKey((Object)entry.getValue());
            endpointsToTokens.put((Object)entry.getValue(), (Object)entry.getKey());
        }
        int maxAddressLength = Collections.max(endpointsToTokens.keys(), new Comparator<String>(){

            @Override
            public int compare(String first, String second) {
                return Integer.compare(first.length(), second.length());
            }
        }).length();
        String formatPlaceholder = "%%-%ds  %%-12s%%-7s%%-8s%%-16s%%-20s%%-44s%%n";
        String format = String.format(formatPlaceholder, maxAddressLength);
        StringBuffer errors = new StringBuffer();
        boolean showEffectiveOwnership = true;
        try {
            ownerships = probe.effectiveOwnership(this.keyspace);
        }
        catch (IllegalStateException ex) {
            ownerships = probe.getOwnership();
            errors.append("Note: " + ex.getMessage() + "%n");
            showEffectiveOwnership = false;
        }
        catch (IllegalArgumentException ex) {
            out.printf("%nError: " + ex.getMessage() + "%n", new Object[0]);
            return;
        }
        out.println();
        for (Map.Entry<String, SetHostStat> entry : NodeTool.getOwnershipByDc(probe, this.resolveIp, tokensToEndpoints, ownerships).entrySet()) {
            this.printDc(probe, format, entry.getKey(), (LinkedHashMultimap<String, String>)endpointsToTokens, entry.getValue(), showEffectiveOwnership);
        }
        if (haveVnodes) {
            out.println("  Warning: \"nodetool ring\" is used to output all the tokens of a node.");
            out.println("  To view status related info of a node use \"nodetool status\" instead.\n");
        }
        out.printf("%n  " + errors.toString(), new Object[0]);
    }

    private void printDc(NodeProbe probe, String format, String dc, LinkedHashMultimap<String, String> endpointsToTokens, SetHostStat hoststats, boolean showEffectiveOwnership) {
        PrintStream out = probe.output().out;
        List<String> liveNodes = probe.getLiveNodes();
        List<String> deadNodes = probe.getUnreachableNodes();
        List<String> joiningNodes = probe.getJoiningNodes();
        List<String> leavingNodes = probe.getLeavingNodes();
        List<String> movingNodes = probe.getMovingNodes();
        Map<String, String> loadMap = probe.getLoadMap();
        out.println("Datacenter: " + dc);
        out.println("==========");
        ArrayList tokens = new ArrayList();
        String lastToken = "";
        for (HostStat stat : hoststats) {
            tokens.addAll(endpointsToTokens.get((Object)stat.endpoint.getHostAddress()));
            lastToken = (String)tokens.get(tokens.size() - 1);
        }
        out.printf(format, "Address", "Rack", "Status", "State", "Load", "Owns", "Token");
        if (hoststats.size() > 1) {
            out.printf(format, "", "", "", "", "", "", lastToken);
        } else {
            out.println();
        }
        for (HostStat stat : hoststats) {
            String rack;
            String endpoint = stat.endpoint.getHostAddress();
            try {
                rack = probe.getEndpointSnitchInfoProxy().getRack(endpoint);
            }
            catch (UnknownHostException e) {
                rack = "Unknown";
            }
            String status = liveNodes.contains(endpoint) ? "Up" : (deadNodes.contains(endpoint) ? "Down" : "?");
            String state = "Normal";
            if (joiningNodes.contains(endpoint)) {
                state = "Joining";
            } else if (leavingNodes.contains(endpoint)) {
                state = "Leaving";
            } else if (movingNodes.contains(endpoint)) {
                state = "Moving";
            }
            String load = loadMap.containsKey(endpoint) ? loadMap.get(endpoint) : "?";
            String owns = stat.owns != null && showEffectiveOwnership ? new DecimalFormat("##0.00%").format(stat.owns) : "?";
            out.printf(format, stat.ipOrDns(), rack, status, state, load, owns, stat.token);
        }
        out.println();
    }
}

