/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.index.internal.composites;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.db.Clusterable;
import org.apache.cassandra.db.Clustering;
import org.apache.cassandra.db.ClusteringComparator;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.DeletionTime;
import org.apache.cassandra.db.ReadCommand;
import org.apache.cassandra.db.ReadOrderGroup;
import org.apache.cassandra.db.SinglePartitionReadCommand;
import org.apache.cassandra.db.filter.ClusteringIndexNamesFilter;
import org.apache.cassandra.db.filter.DataLimits;
import org.apache.cassandra.db.filter.RowFilter;
import org.apache.cassandra.db.partitions.UnfilteredPartitionIterator;
import org.apache.cassandra.db.rows.Row;
import org.apache.cassandra.db.rows.RowIterator;
import org.apache.cassandra.db.rows.Rows;
import org.apache.cassandra.db.rows.UnfilteredRowIterator;
import org.apache.cassandra.db.transform.Transformation;
import org.apache.cassandra.index.internal.CassandraIndex;
import org.apache.cassandra.index.internal.CassandraIndexSearcher;
import org.apache.cassandra.index.internal.IndexEntry;
import org.apache.cassandra.utils.btree.BTreeSet;
import org.apache.cassandra.utils.concurrent.OpOrder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompositesSearcher
extends CassandraIndexSearcher {
    private static final Logger logger = LoggerFactory.getLogger(CompositesSearcher.class);

    public CompositesSearcher(ReadCommand command, RowFilter.Expression expression, CassandraIndex index) {
        super(command, expression, index);
    }

    private boolean isMatchingEntry(DecoratedKey partitionKey, IndexEntry entry, ReadCommand command) {
        return command.selectsKey(partitionKey) && command.selectsClustering(partitionKey, entry.indexedEntryClustering);
    }

    @Override
    protected UnfilteredPartitionIterator queryDataFromIndex(final DecoratedKey indexKey, final RowIterator indexHits, final ReadCommand command, final ReadOrderGroup orderGroup) {
        assert (indexHits.staticRow() == Rows.EMPTY_STATIC_ROW);
        return new UnfilteredPartitionIterator(){
            private IndexEntry nextEntry;
            private UnfilteredRowIterator next;

            @Override
            public boolean isForThrift() {
                return command.isForThrift();
            }

            @Override
            public CFMetaData metadata() {
                return command.metadata();
            }

            @Override
            public boolean hasNext() {
                return this.prepareNext();
            }

            @Override
            public UnfilteredRowIterator next() {
                if (this.next == null) {
                    this.prepareNext();
                }
                UnfilteredRowIterator toReturn = this.next;
                this.next = null;
                return toReturn;
            }

            private boolean prepareNext() {
                if (this.next != null) {
                    return true;
                }
                if (this.nextEntry == null) {
                    if (!indexHits.hasNext()) {
                        return false;
                    }
                    this.nextEntry = CompositesSearcher.this.index.decodeEntry(indexKey, (Row)indexHits.next());
                }
                BTreeSet.Builder<Clusterable> clusterings = BTreeSet.builder(((CompositesSearcher)CompositesSearcher.this).index.baseCfs.getComparator());
                ArrayList<IndexEntry> entries = new ArrayList<IndexEntry>();
                DecoratedKey partitionKey = ((CompositesSearcher)CompositesSearcher.this).index.baseCfs.decorateKey(this.nextEntry.indexedKey);
                while (this.nextEntry != null && partitionKey.getKey().equals(this.nextEntry.indexedKey)) {
                    if (CompositesSearcher.this.isMatchingEntry(partitionKey, this.nextEntry, command)) {
                        clusterings.add(this.nextEntry.indexedEntryClustering);
                        entries.add(this.nextEntry);
                    }
                    this.nextEntry = indexHits.hasNext() ? CompositesSearcher.this.index.decodeEntry(indexKey, (Row)indexHits.next()) : null;
                }
                if (clusterings.isEmpty()) {
                    return this.prepareNext();
                }
                ClusteringIndexNamesFilter filter = new ClusteringIndexNamesFilter(clusterings.build(), false);
                SinglePartitionReadCommand dataCmd = SinglePartitionReadCommand.create(((CompositesSearcher)CompositesSearcher.this).index.baseCfs.metadata, command.nowInSec(), command.columnFilter(), command.rowFilter(), DataLimits.NONE, partitionKey, filter);
                UnfilteredRowIterator dataIter = CompositesSearcher.this.filterStaleEntries(dataCmd.queryMemtableAndDisk(((CompositesSearcher)CompositesSearcher.this).index.baseCfs, orderGroup.baseReadOpOrderGroup()), indexKey.getKey(), entries, orderGroup.writeOpOrderGroup(), command.nowInSec());
                if (dataIter.isEmpty()) {
                    dataIter.close();
                    return this.prepareNext();
                }
                this.next = dataIter;
                return true;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            @Override
            public void close() {
                indexHits.close();
                if (this.next != null) {
                    this.next.close();
                }
            }
        };
    }

    private void deleteAllEntries(List<IndexEntry> entries, OpOrder.Group writeOp, int nowInSec) {
        entries.forEach(entry -> this.index.deleteStaleEntry(entry.indexValue, entry.indexClustering, new DeletionTime(entry.timestamp, nowInSec), writeOp));
    }

    private UnfilteredRowIterator filterStaleEntries(UnfilteredRowIterator dataIter, final ByteBuffer indexValue, final List<IndexEntry> entries, final OpOrder.Group writeOp, final int nowInSec) {
        final ArrayList staleEntries = new ArrayList();
        if (!dataIter.partitionLevelDeletion().isLive()) {
            DeletionTime deletion = dataIter.partitionLevelDeletion();
            entries.forEach(e -> {
                if (deletion.deletes(e.timestamp)) {
                    staleEntries.add(e);
                }
            });
        }
        final ClusteringComparator comparator = dataIter.metadata().comparator;
        class Transform
        extends Transformation {
            private int entriesIdx;

            Transform() {
            }

            @Override
            public Row applyToRow(Row row) {
                IndexEntry entry = this.findEntry(row.clustering());
                if (!CompositesSearcher.this.index.isStale(row, indexValue, nowInSec)) {
                    return row;
                }
                staleEntries.add(entry);
                return null;
            }

            private IndexEntry findEntry(Clustering clustering) {
                assert (this.entriesIdx < entries.size());
                while (this.entriesIdx < entries.size()) {
                    IndexEntry entry = (IndexEntry)entries.get(this.entriesIdx++);
                    int cmp = comparator.compare(entry.indexedEntryClustering, clustering);
                    assert (cmp <= 0);
                    if (cmp == 0) {
                        return entry;
                    }
                    staleEntries.add(entry);
                }
                throw new AssertionError();
            }

            @Override
            public void onPartitionClose() {
                CompositesSearcher.this.deleteAllEntries(staleEntries, writeOp, nowInSec);
            }
        }
        return Transformation.apply(dataIter, new Transform());
    }
}

