/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.tools.nodetool;

import io.airlift.command.Command;
import io.airlift.command.Option;
import java.io.PrintStream;
import java.util.Iterator;
import java.util.Set;
import org.apache.cassandra.io.util.FileUtils;
import org.apache.cassandra.net.MessagingServiceMBean;
import org.apache.cassandra.streaming.ProgressInfo;
import org.apache.cassandra.streaming.SessionInfo;
import org.apache.cassandra.streaming.StreamState;
import org.apache.cassandra.tools.NodeProbe;
import org.apache.cassandra.tools.NodeTool;

@Command(name="netstats", description="Print network information on provided host (connecting node by default)")
public class NetStats
extends NodeTool.NodeToolCmd {
    @Option(title="human_readable", name={"-H", "--human-readable"}, description="Display bytes in human readable form, i.e. KB, MB, GB, TB")
    private boolean humanReadable = false;

    @Override
    public void execute(NodeProbe probe) {
        PrintStream out = probe.output().out;
        out.printf("Mode: %s%n", probe.getOperationMode());
        Set<StreamState> statuses = probe.getStreamStatus();
        if (statuses.isEmpty()) {
            out.println("Not sending any streams.");
        }
        for (StreamState status : statuses) {
            out.printf("%s %s%n", status.description, status.planId.toString());
            for (SessionInfo info : status.sessions) {
                out.printf("    %s", info.peer.toString());
                if (!info.peer.equals(info.connecting)) {
                    out.printf(" (using %s)", info.connecting.toString());
                }
                out.printf("%n", new Object[0]);
                if (!info.receivingSummaries.isEmpty()) {
                    if (this.humanReadable) {
                        out.printf("        Receiving %d files, %s total. Already received %d files, %s total%n", info.getTotalFilesToReceive(), FileUtils.stringifyFileSize(info.getTotalSizeToReceive()), info.getTotalFilesReceived(), FileUtils.stringifyFileSize(info.getTotalSizeReceived()));
                    } else {
                        out.printf("        Receiving %d files, %d bytes total. Already received %d files, %d bytes total%n", info.getTotalFilesToReceive(), info.getTotalSizeToReceive(), info.getTotalFilesReceived(), info.getTotalSizeReceived());
                    }
                    for (ProgressInfo progress : info.getReceivingFiles()) {
                        out.printf("            %s%n", progress.toString());
                    }
                }
                if (info.sendingSummaries.isEmpty()) continue;
                if (this.humanReadable) {
                    out.printf("        Sending %d files, %s total. Already sent %d files, %s total%n", info.getTotalFilesToSend(), FileUtils.stringifyFileSize(info.getTotalSizeToSend()), info.getTotalFilesSent(), FileUtils.stringifyFileSize(info.getTotalSizeSent()));
                } else {
                    out.printf("        Sending %d files, %d bytes total. Already sent %d files, %d bytes total%n", info.getTotalFilesToSend(), info.getTotalSizeToSend(), info.getTotalFilesSent(), info.getTotalSizeSent());
                }
                for (ProgressInfo progress : info.getSendingFiles()) {
                    out.printf("            %s%n", progress.toString());
                }
            }
        }
        if (!probe.isStarting()) {
            out.printf("Read Repair Statistics:%nAttempted: %d%nMismatch (Blocking): %d%nMismatch (Background): %d%n", probe.getReadRepairAttempted(), probe.getReadRepairRepairedBlocking(), probe.getReadRepairRepairedBackground());
            MessagingServiceMBean ms = probe.getMessagingServiceProxy();
            out.printf("%-25s", "Pool Name");
            out.printf("%10s", "Active");
            out.printf("%10s", "Pending");
            out.printf("%15s", "Completed");
            out.printf("%10s%n", "Dropped");
            int pending = 0;
            Iterator<Number> iterator = ms.getLargeMessagePendingTasks().values().iterator();
            while (iterator.hasNext()) {
                int n = iterator.next();
                pending += n;
            }
            long completed = 0L;
            iterator = ms.getLargeMessageCompletedTasks().values().iterator();
            while (iterator.hasNext()) {
                long n = (Long)iterator.next();
                completed += n;
            }
            long dropped = 0L;
            iterator = ms.getLargeMessageDroppedTasks().values().iterator();
            while (iterator.hasNext()) {
                long n = (Long)iterator.next();
                dropped += n;
            }
            out.printf("%-25s%10s%10s%15s%10s%n", "Large messages", "n/a", pending, completed, dropped);
            pending = 0;
            iterator = ms.getSmallMessagePendingTasks().values().iterator();
            while (iterator.hasNext()) {
                int n = (Integer)iterator.next();
                pending += n;
            }
            completed = 0L;
            iterator = ms.getSmallMessageCompletedTasks().values().iterator();
            while (iterator.hasNext()) {
                long n = (Long)iterator.next();
                completed += n;
            }
            dropped = 0L;
            iterator = ms.getSmallMessageDroppedTasks().values().iterator();
            while (iterator.hasNext()) {
                long n = (Long)iterator.next();
                dropped += n;
            }
            out.printf("%-25s%10s%10s%15s%10s%n", "Small messages", "n/a", pending, completed, dropped);
            pending = 0;
            iterator = ms.getGossipMessagePendingTasks().values().iterator();
            while (iterator.hasNext()) {
                int n = (Integer)iterator.next();
                pending += n;
            }
            completed = 0L;
            iterator = ms.getGossipMessageCompletedTasks().values().iterator();
            while (iterator.hasNext()) {
                long n = (Long)iterator.next();
                completed += n;
            }
            dropped = 0L;
            iterator = ms.getGossipMessageDroppedTasks().values().iterator();
            while (iterator.hasNext()) {
                long n = (Long)iterator.next();
                dropped += n;
            }
            out.printf("%-25s%10s%10s%15s%10s%n", "Gossip messages", "n/a", pending, completed, dropped);
        }
    }
}

