/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.rows;

import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.util.Objects;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.db.DeletionTime;
import org.apache.cassandra.db.RangeTombstone;
import org.apache.cassandra.db.Slice;
import org.apache.cassandra.db.rows.AbstractRangeTombstoneMarker;
import org.apache.cassandra.utils.memory.AbstractAllocator;

public class RangeTombstoneBoundMarker
extends AbstractRangeTombstoneMarker {
    private final DeletionTime deletion;

    public RangeTombstoneBoundMarker(RangeTombstone.Bound bound, DeletionTime deletion) {
        super(bound);
        assert (!bound.isBoundary());
        this.deletion = deletion;
    }

    public RangeTombstoneBoundMarker(Slice.Bound bound, DeletionTime deletion) {
        this(new RangeTombstone.Bound(bound.kind(), bound.getRawValues()), deletion);
    }

    public static RangeTombstoneBoundMarker inclusiveOpen(boolean reversed, ByteBuffer[] boundValues, DeletionTime deletion) {
        RangeTombstone.Bound bound = RangeTombstone.Bound.inclusiveOpen(reversed, boundValues);
        return new RangeTombstoneBoundMarker(bound, deletion);
    }

    public static RangeTombstoneBoundMarker exclusiveOpen(boolean reversed, ByteBuffer[] boundValues, DeletionTime deletion) {
        RangeTombstone.Bound bound = RangeTombstone.Bound.exclusiveOpen(reversed, boundValues);
        return new RangeTombstoneBoundMarker(bound, deletion);
    }

    public static RangeTombstoneBoundMarker inclusiveClose(boolean reversed, ByteBuffer[] boundValues, DeletionTime deletion) {
        RangeTombstone.Bound bound = RangeTombstone.Bound.inclusiveClose(reversed, boundValues);
        return new RangeTombstoneBoundMarker(bound, deletion);
    }

    public static RangeTombstoneBoundMarker exclusiveClose(boolean reversed, ByteBuffer[] boundValues, DeletionTime deletion) {
        RangeTombstone.Bound bound = RangeTombstone.Bound.exclusiveClose(reversed, boundValues);
        return new RangeTombstoneBoundMarker(bound, deletion);
    }

    @Override
    public boolean isBoundary() {
        return false;
    }

    public DeletionTime deletionTime() {
        return this.deletion;
    }

    @Override
    public DeletionTime openDeletionTime(boolean reversed) {
        if (!this.isOpen(reversed)) {
            throw new IllegalStateException();
        }
        return this.deletion;
    }

    @Override
    public DeletionTime closeDeletionTime(boolean reversed) {
        if (this.isOpen(reversed)) {
            throw new IllegalStateException();
        }
        return this.deletion;
    }

    @Override
    public boolean openIsInclusive(boolean reversed) {
        if (!this.isOpen(reversed)) {
            throw new IllegalStateException();
        }
        return this.bound.isInclusive();
    }

    @Override
    public boolean closeIsInclusive(boolean reversed) {
        if (this.isOpen(reversed)) {
            throw new IllegalStateException();
        }
        return this.bound.isInclusive();
    }

    @Override
    public RangeTombstone.Bound openBound(boolean reversed) {
        return this.isOpen(reversed) ? this.clustering() : null;
    }

    @Override
    public RangeTombstone.Bound closeBound(boolean reversed) {
        return this.isClose(reversed) ? this.clustering() : null;
    }

    @Override
    public RangeTombstoneBoundMarker copy(AbstractAllocator allocator) {
        return new RangeTombstoneBoundMarker(this.clustering().copy(allocator), this.deletion);
    }

    @Override
    public RangeTombstoneBoundMarker withNewOpeningDeletionTime(boolean reversed, DeletionTime newDeletionTime) {
        if (!this.isOpen(reversed)) {
            throw new IllegalStateException();
        }
        return new RangeTombstoneBoundMarker(this.clustering(), newDeletionTime);
    }

    @Override
    public void digest(MessageDigest digest) {
        this.bound.digest(digest);
        this.deletion.digest(digest);
    }

    @Override
    public String toString(CFMetaData metadata) {
        return String.format("Marker %s@%d/%d", this.bound.toString(metadata), this.deletion.markedForDeleteAt(), this.deletion.localDeletionTime());
    }

    public boolean equals(Object other) {
        if (!(other instanceof RangeTombstoneBoundMarker)) {
            return false;
        }
        RangeTombstoneBoundMarker that = (RangeTombstoneBoundMarker)other;
        return this.bound.equals(that.bound) && this.deletion.equals(that.deletion);
    }

    public int hashCode() {
        return Objects.hash(this.bound, this.deletion);
    }
}

