/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.marshal;

import java.nio.ByteBuffer;
import java.util.concurrent.TimeUnit;
import org.apache.cassandra.cql3.CQL3Type;
import org.apache.cassandra.cql3.Constants;
import org.apache.cassandra.cql3.Term;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.io.util.DataInputPlus;
import org.apache.cassandra.io.util.DataOutputPlus;
import org.apache.cassandra.serializers.EmptySerializer;
import org.apache.cassandra.serializers.MarshalException;
import org.apache.cassandra.serializers.TypeSerializer;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.NoSpamLogger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmptyType
extends AbstractType<Void> {
    private static final Logger logger = LoggerFactory.getLogger(EmptyType.class);
    private static final String KEY_EMPTYTYPE_NONEMPTY_BEHAVIOR = "cassandra.serialization.emptytype.nonempty_behavior";
    private static final NoSpamLogger NON_EMPTY_WRITE_LOGGER = NoSpamLogger.getLogger(logger, 1L, TimeUnit.MINUTES);
    private static final NonEmptyWriteBehavior NON_EMPTY_WRITE_BEHAVIOR = EmptyType.parseNonEmptyWriteBehavior();
    public static final EmptyType instance = new EmptyType();

    private static NonEmptyWriteBehavior parseNonEmptyWriteBehavior() {
        String value = System.getProperty(KEY_EMPTYTYPE_NONEMPTY_BEHAVIOR);
        if (value == null) {
            return NonEmptyWriteBehavior.FAIL;
        }
        try {
            return NonEmptyWriteBehavior.valueOf(value.toUpperCase().trim());
        }
        catch (Exception e) {
            logger.warn("Unable to parse property cassandra.serialization.emptytype.nonempty_behavior, falling back to FAIL", (Throwable)e);
            return NonEmptyWriteBehavior.FAIL;
        }
    }

    private EmptyType() {
        super(AbstractType.ComparisonType.CUSTOM);
    }

    @Override
    public int compareCustom(ByteBuffer o1, ByteBuffer o2) {
        return 0;
    }

    @Override
    public String getString(ByteBuffer bytes) {
        return "";
    }

    @Override
    public ByteBuffer fromString(String source) throws MarshalException {
        if (!source.isEmpty()) {
            throw new MarshalException(String.format("'%s' is not empty", source));
        }
        return ByteBufferUtil.EMPTY_BYTE_BUFFER;
    }

    @Override
    public Term fromJSONObject(Object parsed) throws MarshalException {
        if (!(parsed instanceof String)) {
            throw new MarshalException(String.format("Expected an empty string, but got: %s", parsed));
        }
        if (!((String)parsed).isEmpty()) {
            throw new MarshalException(String.format("'%s' is not empty", parsed));
        }
        return new Constants.Value(ByteBufferUtil.EMPTY_BYTE_BUFFER);
    }

    @Override
    public CQL3Type asCQL3Type() {
        return CQL3Type.Native.EMPTY;
    }

    @Override
    public String toJSONString(ByteBuffer buffer, int protocolVersion) {
        return "\"\"";
    }

    @Override
    public TypeSerializer<Void> getSerializer() {
        return EmptySerializer.instance;
    }

    @Override
    protected int valueLengthIfFixed() {
        return 0;
    }

    @Override
    public ByteBuffer readValue(DataInputPlus in) {
        return ByteBufferUtil.EMPTY_BYTE_BUFFER;
    }

    @Override
    public ByteBuffer readValue(DataInputPlus in, int maxValueSize) {
        return ByteBufferUtil.EMPTY_BYTE_BUFFER;
    }

    @Override
    public void writeValue(ByteBuffer value, DataOutputPlus out) {
        if (!value.hasRemaining()) {
            return;
        }
        switch (NON_EMPTY_WRITE_BEHAVIOR) {
            case LOG_DATA_LOSS: {
                NON_EMPTY_WRITE_LOGGER.warn("Dropping data...", new NonEmptyWriteException("Attempted to write a non-empty value using EmptyType"));
            }
            case SILENT_DATA_LOSS: {
                return;
            }
        }
        throw new AssertionError((Object)"Attempted to write a non-empty value using EmptyType");
    }

    private static final class NonEmptyWriteException
    extends RuntimeException {
        NonEmptyWriteException(String message) {
            super(message);
        }
    }

    private static enum NonEmptyWriteBehavior {
        FAIL,
        LOG_DATA_LOSS,
        SILENT_DATA_LOSS;

    }
}

