/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.PeekingIterator;
import com.google.common.util.concurrent.Striped;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.ClockAndCount;
import org.apache.cassandra.db.Clusterable;
import org.apache.cassandra.db.Clustering;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.ConsistencyLevel;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.IMutation;
import org.apache.cassandra.db.Keyspace;
import org.apache.cassandra.db.Mutation;
import org.apache.cassandra.db.SinglePartitionReadCommand;
import org.apache.cassandra.db.TypeSizes;
import org.apache.cassandra.db.WriteType;
import org.apache.cassandra.db.context.CounterContext;
import org.apache.cassandra.db.filter.ClusteringIndexNamesFilter;
import org.apache.cassandra.db.filter.ColumnFilter;
import org.apache.cassandra.db.partitions.PartitionUpdate;
import org.apache.cassandra.db.rows.Cell;
import org.apache.cassandra.db.rows.ColumnData;
import org.apache.cassandra.db.rows.Row;
import org.apache.cassandra.db.rows.RowIterator;
import org.apache.cassandra.db.rows.UnfilteredRowIterators;
import org.apache.cassandra.exceptions.WriteTimeoutException;
import org.apache.cassandra.io.IVersionedSerializer;
import org.apache.cassandra.io.util.DataInputPlus;
import org.apache.cassandra.io.util.DataOutputPlus;
import org.apache.cassandra.net.MessageOut;
import org.apache.cassandra.net.MessagingService;
import org.apache.cassandra.service.CacheService;
import org.apache.cassandra.tracing.Tracing;
import org.apache.cassandra.utils.CounterId;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.btree.BTreeSet;
import org.apache.cassandra.utils.concurrent.OpOrder;

public class CounterMutation
implements IMutation {
    public static final CounterMutationSerializer serializer = new CounterMutationSerializer();
    private static final Striped<Lock> LOCKS = Striped.lazyWeakLock((int)(DatabaseDescriptor.getConcurrentCounterWriters() * 1024));
    private final Mutation mutation;
    private final ConsistencyLevel consistency;

    public CounterMutation(Mutation mutation, ConsistencyLevel consistency) {
        this.mutation = mutation;
        this.consistency = consistency;
    }

    @Override
    public String getKeyspaceName() {
        return this.mutation.getKeyspaceName();
    }

    @Override
    public Collection<UUID> getColumnFamilyIds() {
        return this.mutation.getColumnFamilyIds();
    }

    @Override
    public Collection<PartitionUpdate> getPartitionUpdates() {
        return this.mutation.getPartitionUpdates();
    }

    public Mutation getMutation() {
        return this.mutation;
    }

    @Override
    public DecoratedKey key() {
        return this.mutation.key();
    }

    public ConsistencyLevel consistency() {
        return this.consistency;
    }

    public MessageOut<CounterMutation> makeMutationMessage() {
        return new MessageOut<CounterMutation>(MessagingService.Verb.COUNTER_MUTATION, this, serializer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Mutation apply() throws WriteTimeoutException {
        Mutation result = new Mutation(this.getKeyspaceName(), this.key());
        Keyspace keyspace = Keyspace.open(this.getKeyspaceName());
        ArrayList<Lock> locks = new ArrayList<Lock>();
        Tracing.trace("Acquiring counter locks");
        try {
            this.grabCounterLocks(keyspace, locks);
            for (PartitionUpdate upd : this.getPartitionUpdates()) {
                result.add(this.processModifications(upd));
            }
            result.apply();
            Mutation mutation = result;
            return mutation;
        }
        finally {
            for (Lock lock : locks) {
                lock.unlock();
            }
        }
    }

    private void grabCounterLocks(Keyspace keyspace, List<Lock> locks) throws WriteTimeoutException {
        long startTime = System.nanoTime();
        for (Lock lock : LOCKS.bulkGet(this.getCounterLockKeys())) {
            long timeout = TimeUnit.MILLISECONDS.toNanos(this.getTimeout()) - (System.nanoTime() - startTime);
            try {
                if (!lock.tryLock(timeout, TimeUnit.NANOSECONDS)) {
                    throw new WriteTimeoutException(WriteType.COUNTER, this.consistency(), 0, this.consistency().blockFor(keyspace));
                }
                locks.add(lock);
            }
            catch (InterruptedException e) {
                throw new WriteTimeoutException(WriteType.COUNTER, this.consistency(), 0, this.consistency().blockFor(keyspace));
            }
        }
    }

    private Iterable<Object> getCounterLockKeys() {
        return Iterables.concat((Iterable)Iterables.transform(this.getPartitionUpdates(), (Function)new Function<PartitionUpdate, Iterable<Object>>(){

            public Iterable<Object> apply(final PartitionUpdate update) {
                return Iterables.concat((Iterable)Iterables.transform((Iterable)update, (Function)new Function<Row, Iterable<Object>>(){

                    public Iterable<Object> apply(final Row row) {
                        return Iterables.concat((Iterable[])new Iterable[]{Iterables.transform((Iterable)row, (Function)new Function<ColumnData, Object>(){

                            public Object apply(ColumnData data) {
                                return Objects.hashCode((Object[])new Object[]{update.metadata().cfId, CounterMutation.this.key(), row.clustering(), data.column()});
                            }
                        })});
                    }
                }));
            }
        }));
    }

    private PartitionUpdate processModifications(PartitionUpdate changes) {
        ColumnFamilyStore cfs = Keyspace.open(this.getKeyspaceName()).getColumnFamilyStore(changes.metadata().cfId);
        List<PartitionUpdate.CounterMark> marks = changes.collectCounterMarks();
        if (CacheService.instance.counterCache.getCapacity() != 0L) {
            Tracing.trace("Fetching {} counter values from cache", (Object)marks.size());
            this.updateWithCurrentValuesFromCache(marks, cfs);
            if (marks.isEmpty()) {
                return changes;
            }
        }
        Tracing.trace("Reading {} counter values from the CF", (Object)marks.size());
        this.updateWithCurrentValuesFromCFS(marks, cfs);
        for (PartitionUpdate.CounterMark mark : marks) {
            this.updateWithCurrentValue(mark, ClockAndCount.BLANK, cfs);
        }
        return changes;
    }

    private void updateWithCurrentValue(PartitionUpdate.CounterMark mark, ClockAndCount currentValue, ColumnFamilyStore cfs) {
        long clock = currentValue.clock + 1L;
        long count = currentValue.count + CounterContext.instance().total(mark.value());
        mark.setValue(CounterContext.instance().createGlobal(CounterId.getLocalId(), clock, count));
        cfs.putCachedCounter(this.key().getKey(), mark.clustering(), mark.column(), mark.path(), ClockAndCount.create(clock, count));
    }

    private void updateWithCurrentValuesFromCache(List<PartitionUpdate.CounterMark> marks, ColumnFamilyStore cfs) {
        Iterator<PartitionUpdate.CounterMark> iter = marks.iterator();
        while (iter.hasNext()) {
            PartitionUpdate.CounterMark mark = iter.next();
            ClockAndCount cached = cfs.getCachedCounter(this.key().getKey(), mark.clustering(), mark.column(), mark.path());
            if (cached == null) continue;
            this.updateWithCurrentValue(mark, cached, cfs);
            iter.remove();
        }
    }

    private void updateWithCurrentValuesFromCFS(List<PartitionUpdate.CounterMark> marks, ColumnFamilyStore cfs) {
        ColumnFilter.Builder builder = ColumnFilter.selectionBuilder();
        BTreeSet.Builder<Clusterable> names = BTreeSet.builder(cfs.metadata.comparator);
        for (PartitionUpdate.CounterMark mark : marks) {
            if (mark.clustering() != Clustering.STATIC_CLUSTERING) {
                names.add(mark.clustering());
            }
            if (mark.path() == null) {
                builder.add(mark.column());
                continue;
            }
            builder.select(mark.column(), mark.path());
        }
        int nowInSec = FBUtilities.nowInSeconds();
        ClusteringIndexNamesFilter filter = new ClusteringIndexNamesFilter(names.build(), false);
        SinglePartitionReadCommand cmd = SinglePartitionReadCommand.create(cfs.metadata, nowInSec, this.key(), builder.build(), filter);
        PeekingIterator markIter = Iterators.peekingIterator(marks.iterator());
        try (OpOrder.Group op = cfs.readOrdering.start();){
            RowIterator partition = UnfilteredRowIterators.filter(cmd.queryMemtableAndDisk(cfs, op), nowInSec);
            Throwable throwable = null;
            try {
                this.updateForRow((PeekingIterator<PartitionUpdate.CounterMark>)markIter, partition.staticRow(), cfs);
            }
            catch (Throwable throwable2) {
                try {
                    throwable = throwable2;
                    throw throwable2;
                }
                catch (Throwable throwable3) {
                    if (partition != null) {
                        if (throwable != null) {
                            try {
                                partition.close();
                            }
                            catch (Throwable throwable4) {
                                throwable.addSuppressed(throwable4);
                            }
                        } else {
                            partition.close();
                        }
                    }
                    throw throwable3;
                }
            }
        }
    }

    private int compare(Clustering c1, Clustering c2, ColumnFamilyStore cfs) {
        if (c1 == Clustering.STATIC_CLUSTERING) {
            return c2 == Clustering.STATIC_CLUSTERING ? 0 : -1;
        }
        if (c2 == Clustering.STATIC_CLUSTERING) {
            return 1;
        }
        return cfs.getComparator().compare(c1, c2);
    }

    private void updateForRow(PeekingIterator<PartitionUpdate.CounterMark> markIter, Row row, ColumnFamilyStore cfs) {
        int cmp = 0;
        while (markIter.hasNext() && (cmp = this.compare(((PartitionUpdate.CounterMark)markIter.peek()).clustering(), row.clustering(), cfs)) < 0) {
            markIter.next();
        }
        if (!markIter.hasNext()) {
            return;
        }
        while (cmp == 0) {
            Cell cell;
            PartitionUpdate.CounterMark mark = (PartitionUpdate.CounterMark)markIter.next();
            Cell cell2 = cell = mark.path() == null ? row.getCell(mark.column()) : row.getCell(mark.column(), mark.path());
            if (cell != null) {
                this.updateWithCurrentValue(mark, CounterContext.instance().getLocalClockAndCount(cell.value()), cfs);
                markIter.remove();
            }
            if (!markIter.hasNext()) {
                return;
            }
            cmp = this.compare(((PartitionUpdate.CounterMark)markIter.peek()).clustering(), row.clustering(), cfs);
        }
    }

    @Override
    public long getTimeout() {
        return DatabaseDescriptor.getCounterWriteRpcTimeout();
    }

    public String toString() {
        return this.toString(false);
    }

    @Override
    public String toString(boolean shallow) {
        return String.format("CounterMutation(%s, %s)", new Object[]{this.mutation.toString(shallow), this.consistency});
    }

    public static class CounterMutationSerializer
    implements IVersionedSerializer<CounterMutation> {
        @Override
        public void serialize(CounterMutation cm, DataOutputPlus out, int version) throws IOException {
            Mutation.serializer.serialize(cm.mutation, out, version);
            out.writeUTF(cm.consistency.name());
        }

        @Override
        public CounterMutation deserialize(DataInputPlus in, int version) throws IOException {
            Mutation m = Mutation.serializer.deserialize(in, version);
            ConsistencyLevel consistency = Enum.valueOf(ConsistencyLevel.class, in.readUTF());
            return new CounterMutation(m, consistency);
        }

        @Override
        public long serializedSize(CounterMutation cm, int version) {
            return Mutation.serializer.serializedSize(cm.mutation, version) + (long)TypeSizes.sizeof(cm.consistency.name());
        }
    }
}

