/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.utils.memory;

import org.apache.cassandra.concurrent.InfiniteLoopExecutor;
import org.apache.cassandra.utils.concurrent.WaitQueue;
import org.apache.cassandra.utils.memory.MemtablePool;

public class MemtableCleanerThread<P extends MemtablePool>
extends InfiniteLoopExecutor {
    private final Runnable trigger = clean.wait::signal;

    private MemtableCleanerThread(Clean<P> clean) {
        super(clean.pool.getClass().getSimpleName() + "Cleaner", clean);
    }

    MemtableCleanerThread(P pool, Runnable cleaner) {
        this(new Clean((MemtablePool)pool, cleaner, null));
    }

    public void trigger() {
        this.trigger.run();
    }

    private static class Clean<P extends MemtablePool>
    implements InfiniteLoopExecutor.InterruptibleRunnable {
        final P pool;
        final Runnable cleaner;
        final WaitQueue wait = new WaitQueue();

        private Clean(P pool, Runnable cleaner) {
            this.pool = pool;
            this.cleaner = cleaner;
        }

        boolean needsCleaning() {
            return ((MemtablePool)this.pool).onHeap.needsCleaning() || ((MemtablePool)this.pool).offHeap.needsCleaning();
        }

        @Override
        public void run() throws InterruptedException {
            if (this.needsCleaning()) {
                this.cleaner.run();
            } else {
                WaitQueue.Signal signal = this.wait.register();
                if (!this.needsCleaning()) {
                    signal.await();
                } else {
                    signal.cancel();
                }
            }
        }

        /* synthetic */ Clean(MemtablePool x0, Runnable x1, 1 x2) {
            this(x0, x1);
        }
    }
}

