/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.NavigableSet;
import java.util.TreeSet;
import org.apache.cassandra.cache.IRowCacheEntry;
import org.apache.cassandra.cache.RowCacheKey;
import org.apache.cassandra.cache.RowCacheSentinel;
import org.apache.cassandra.concurrent.Stage;
import org.apache.cassandra.concurrent.StageManager;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.ColumnDefinition;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.Clusterable;
import org.apache.cassandra.db.Clustering;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.Columns;
import org.apache.cassandra.db.ConsistencyLevel;
import org.apache.cassandra.db.DataRange;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.EmptyIterators;
import org.apache.cassandra.db.Keyspace;
import org.apache.cassandra.db.Memtable;
import org.apache.cassandra.db.Mutation;
import org.apache.cassandra.db.PartitionColumns;
import org.apache.cassandra.db.ReadCommand;
import org.apache.cassandra.db.ReadOrderGroup;
import org.apache.cassandra.db.ReadQuery;
import org.apache.cassandra.db.RowIndexEntry;
import org.apache.cassandra.db.Slice;
import org.apache.cassandra.db.Slices;
import org.apache.cassandra.db.filter.ClusteringIndexFilter;
import org.apache.cassandra.db.filter.ClusteringIndexNamesFilter;
import org.apache.cassandra.db.filter.ClusteringIndexSliceFilter;
import org.apache.cassandra.db.filter.ColumnFilter;
import org.apache.cassandra.db.filter.DataLimits;
import org.apache.cassandra.db.filter.RowFilter;
import org.apache.cassandra.db.lifecycle.SSTableSet;
import org.apache.cassandra.db.lifecycle.View;
import org.apache.cassandra.db.partitions.AbstractBTreePartition;
import org.apache.cassandra.db.partitions.CachedBTreePartition;
import org.apache.cassandra.db.partitions.CachedPartition;
import org.apache.cassandra.db.partitions.ImmutableBTreePartition;
import org.apache.cassandra.db.partitions.Partition;
import org.apache.cassandra.db.partitions.PartitionIterator;
import org.apache.cassandra.db.partitions.PartitionIterators;
import org.apache.cassandra.db.partitions.PartitionUpdate;
import org.apache.cassandra.db.partitions.SingletonUnfilteredPartitionIterator;
import org.apache.cassandra.db.partitions.UnfilteredPartitionIterator;
import org.apache.cassandra.db.rows.Cell;
import org.apache.cassandra.db.rows.Row;
import org.apache.cassandra.db.rows.Rows;
import org.apache.cassandra.db.rows.Unfiltered;
import org.apache.cassandra.db.rows.UnfilteredRowIterator;
import org.apache.cassandra.db.rows.UnfilteredRowIterators;
import org.apache.cassandra.db.rows.WrappingUnfilteredRowIterator;
import org.apache.cassandra.db.transform.RTBoundValidator;
import org.apache.cassandra.exceptions.RequestExecutionException;
import org.apache.cassandra.io.sstable.format.SSTableReader;
import org.apache.cassandra.io.sstable.format.SSTableReadsListener;
import org.apache.cassandra.io.util.DataInputPlus;
import org.apache.cassandra.io.util.DataOutputPlus;
import org.apache.cassandra.metrics.TableMetrics;
import org.apache.cassandra.net.MessageOut;
import org.apache.cassandra.net.MessagingService;
import org.apache.cassandra.schema.IndexMetadata;
import org.apache.cassandra.service.CacheService;
import org.apache.cassandra.service.ClientState;
import org.apache.cassandra.service.StorageProxy;
import org.apache.cassandra.service.pager.MultiPartitionPager;
import org.apache.cassandra.service.pager.PagingState;
import org.apache.cassandra.service.pager.QueryPager;
import org.apache.cassandra.service.pager.SinglePartitionPager;
import org.apache.cassandra.thrift.ThriftResultsMerger;
import org.apache.cassandra.tracing.Tracing;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.SearchIterator;
import org.apache.cassandra.utils.btree.BTreeSet;
import org.apache.cassandra.utils.concurrent.OpOrder;
import org.apache.cassandra.utils.memory.HeapAllocator;

public class SinglePartitionReadCommand
extends ReadCommand {
    protected static final ReadCommand.SelectionDeserializer selectionDeserializer = new Deserializer();
    private final DecoratedKey partitionKey;
    private final ClusteringIndexFilter clusteringIndexFilter;
    private int oldestUnrepairedTombstone = Integer.MAX_VALUE;

    private SinglePartitionReadCommand(boolean isDigest, int digestVersion, boolean isForThrift, CFMetaData metadata, int nowInSec, ColumnFilter columnFilter, RowFilter rowFilter, DataLimits limits, DecoratedKey partitionKey, ClusteringIndexFilter clusteringIndexFilter, IndexMetadata index) {
        super(ReadCommand.Kind.SINGLE_PARTITION, isDigest, digestVersion, isForThrift, metadata, nowInSec, columnFilter, rowFilter, limits, index);
        assert (partitionKey.getPartitioner() == metadata.partitioner);
        this.partitionKey = partitionKey;
        this.clusteringIndexFilter = clusteringIndexFilter;
    }

    public static SinglePartitionReadCommand create(boolean isForThrift, CFMetaData metadata, int nowInSec, ColumnFilter columnFilter, RowFilter rowFilter, DataLimits limits, DecoratedKey partitionKey, ClusteringIndexFilter clusteringIndexFilter, IndexMetadata indexMetadata) {
        return new SinglePartitionReadCommand(false, 0, isForThrift, metadata, nowInSec, columnFilter, rowFilter, limits, partitionKey, clusteringIndexFilter, indexMetadata);
    }

    public static SinglePartitionReadCommand create(CFMetaData metadata, int nowInSec, ColumnFilter columnFilter, RowFilter rowFilter, DataLimits limits, DecoratedKey partitionKey, ClusteringIndexFilter clusteringIndexFilter) {
        return SinglePartitionReadCommand.create(false, metadata, nowInSec, columnFilter, rowFilter, limits, partitionKey, clusteringIndexFilter);
    }

    public static SinglePartitionReadCommand create(boolean isForThrift, CFMetaData metadata, int nowInSec, ColumnFilter columnFilter, RowFilter rowFilter, DataLimits limits, DecoratedKey partitionKey, ClusteringIndexFilter clusteringIndexFilter) {
        return SinglePartitionReadCommand.create(isForThrift, metadata, nowInSec, columnFilter, rowFilter, limits, partitionKey, clusteringIndexFilter, SinglePartitionReadCommand.findIndex(metadata, rowFilter));
    }

    public static SinglePartitionReadCommand create(CFMetaData metadata, int nowInSec, DecoratedKey key, ColumnFilter columnFilter, ClusteringIndexFilter filter) {
        return SinglePartitionReadCommand.create(metadata, nowInSec, columnFilter, RowFilter.NONE, DataLimits.NONE, key, filter);
    }

    public static SinglePartitionReadCommand fullPartitionRead(CFMetaData metadata, int nowInSec, DecoratedKey key) {
        return SinglePartitionReadCommand.create(metadata, nowInSec, key, Slices.ALL);
    }

    public static SinglePartitionReadCommand fullPartitionRead(CFMetaData metadata, int nowInSec, ByteBuffer key) {
        return SinglePartitionReadCommand.create(metadata, nowInSec, metadata.decorateKey(key), Slices.ALL);
    }

    public static SinglePartitionReadCommand create(CFMetaData metadata, int nowInSec, DecoratedKey key, Slice slice) {
        return SinglePartitionReadCommand.create(metadata, nowInSec, key, Slices.with(metadata.comparator, slice));
    }

    public static SinglePartitionReadCommand create(CFMetaData metadata, int nowInSec, DecoratedKey key, Slices slices) {
        ClusteringIndexSliceFilter filter = new ClusteringIndexSliceFilter(slices, false);
        return SinglePartitionReadCommand.create(metadata, nowInSec, ColumnFilter.all(metadata), RowFilter.NONE, DataLimits.NONE, key, filter);
    }

    public static SinglePartitionReadCommand create(CFMetaData metadata, int nowInSec, ByteBuffer key, Slices slices) {
        return SinglePartitionReadCommand.create(metadata, nowInSec, metadata.decorateKey(key), slices);
    }

    public static SinglePartitionReadCommand create(CFMetaData metadata, int nowInSec, DecoratedKey key, NavigableSet<Clustering> names) {
        ClusteringIndexNamesFilter filter = new ClusteringIndexNamesFilter(names, false);
        return SinglePartitionReadCommand.create(metadata, nowInSec, ColumnFilter.all(metadata), RowFilter.NONE, DataLimits.NONE, key, filter);
    }

    public static SinglePartitionReadCommand create(CFMetaData metadata, int nowInSec, DecoratedKey key, Clustering name) {
        return SinglePartitionReadCommand.create(metadata, nowInSec, key, FBUtilities.singleton(name, metadata.comparator));
    }

    @Override
    public SinglePartitionReadCommand copy() {
        return new SinglePartitionReadCommand(this.isDigestQuery(), this.digestVersion(), this.isForThrift(), this.metadata(), this.nowInSec(), this.columnFilter(), this.rowFilter(), this.limits(), this.partitionKey(), this.clusteringIndexFilter(), this.indexMetadata());
    }

    @Override
    public SinglePartitionReadCommand copyAsDigestQuery() {
        return new SinglePartitionReadCommand(true, this.digestVersion(), this.isForThrift(), this.metadata(), this.nowInSec(), this.columnFilter(), this.rowFilter(), this.limits(), this.partitionKey(), this.clusteringIndexFilter(), this.indexMetadata());
    }

    public SinglePartitionReadCommand withUpdatedClusteringIndexFilter(ClusteringIndexFilter filter) {
        return new SinglePartitionReadCommand(this.isDigestQuery(), this.digestVersion(), this.isForThrift(), this.metadata(), this.nowInSec(), this.columnFilter(), this.rowFilter(), this.limits(), this.partitionKey(), filter, this.indexMetadata());
    }

    static SinglePartitionReadCommand legacySliceCommand(boolean isDigest, int digestVersion, CFMetaData metadata, int nowInSec, ColumnFilter columnFilter, DataLimits limits, DecoratedKey partitionKey, ClusteringIndexSliceFilter filter) {
        return new SinglePartitionReadCommand(isDigest, digestVersion, true, metadata, nowInSec, columnFilter, RowFilter.NONE, limits, partitionKey, filter, null);
    }

    static SinglePartitionReadCommand legacyNamesCommand(boolean isDigest, int digestVersion, CFMetaData metadata, int nowInSec, ColumnFilter columnFilter, DecoratedKey partitionKey, ClusteringIndexNamesFilter filter) {
        return new SinglePartitionReadCommand(isDigest, digestVersion, true, metadata, nowInSec, columnFilter, RowFilter.NONE, DataLimits.NONE, partitionKey, filter, null);
    }

    public DecoratedKey partitionKey() {
        return this.partitionKey;
    }

    public ClusteringIndexFilter clusteringIndexFilter() {
        return this.clusteringIndexFilter;
    }

    @Override
    public ClusteringIndexFilter clusteringIndexFilter(DecoratedKey key) {
        return this.clusteringIndexFilter;
    }

    @Override
    public long getTimeout() {
        return DatabaseDescriptor.getReadRpcTimeout();
    }

    @Override
    public boolean isReversed() {
        return this.clusteringIndexFilter.isReversed();
    }

    @Override
    public boolean selectsKey(DecoratedKey key) {
        if (!this.partitionKey().equals(key)) {
            return false;
        }
        return this.rowFilter().partitionKeyRestrictionsAreSatisfiedBy(key, this.metadata().getKeyValidator());
    }

    @Override
    public boolean selectsClustering(DecoratedKey key, Clustering clustering) {
        if (clustering == Clustering.STATIC_CLUSTERING) {
            return !this.columnFilter().fetchedColumns().statics.isEmpty();
        }
        if (!this.clusteringIndexFilter().selects(clustering)) {
            return false;
        }
        return this.rowFilter().clusteringKeyRestrictionsAreSatisfiedBy(clustering);
    }

    public SinglePartitionReadCommand forPaging(Clustering lastReturned, int pageSize) {
        assert (!this.isDigestQuery());
        return SinglePartitionReadCommand.create(this.isForThrift(), this.metadata(), this.nowInSec(), this.columnFilter(), this.rowFilter(), this.limits().forPaging(pageSize), this.partitionKey(), lastReturned == null ? this.clusteringIndexFilter() : this.clusteringIndexFilter.forPaging(this.metadata().comparator, lastReturned, false));
    }

    @Override
    public PartitionIterator execute(ConsistencyLevel consistency, ClientState clientState) throws RequestExecutionException {
        return StorageProxy.read(Group.one(this), consistency, clientState);
    }

    @Override
    public SinglePartitionPager getPager(PagingState pagingState, int protocolVersion) {
        return SinglePartitionReadCommand.getPager(this, pagingState, protocolVersion);
    }

    private static SinglePartitionPager getPager(SinglePartitionReadCommand command, PagingState pagingState, int protocolVersion) {
        return new SinglePartitionPager(command, pagingState, protocolVersion);
    }

    @Override
    protected void recordLatency(TableMetrics metric, long latencyNanos) {
        metric.readLatency.addNano(latencyNanos);
    }

    @Override
    protected UnfilteredPartitionIterator queryStorage(ColumnFamilyStore cfs, ReadOrderGroup orderGroup) {
        UnfilteredRowIterator partition = cfs.isRowCacheEnabled() ? this.getThroughCache(cfs, orderGroup.baseReadOpOrderGroup()) : this.queryMemtableAndDisk(cfs, orderGroup.baseReadOpOrderGroup());
        return new SingletonUnfilteredPartitionIterator(partition, this.isForThrift());
    }

    private UnfilteredRowIterator getThroughCache(ColumnFamilyStore cfs, OpOrder.Group readOp) {
        boolean cacheFullPartitions;
        assert (!cfs.isIndex());
        assert (cfs.isRowCacheEnabled()) : String.format("Row cache is not enabled on table [%s]", cfs.name);
        RowCacheKey key = new RowCacheKey(this.metadata().ksAndCFName, this.partitionKey());
        IRowCacheEntry cached = (IRowCacheEntry)CacheService.instance.rowCache.get(key);
        if (cached != null) {
            if (cached instanceof RowCacheSentinel) {
                Tracing.trace("Row cache miss (race)");
                cfs.metric.rowCacheMiss.inc();
                return this.queryMemtableAndDisk(cfs, readOp);
            }
            CachedPartition cachedPartition = (CachedPartition)cached;
            if (cfs.isFilterFullyCoveredBy(this.clusteringIndexFilter(), this.limits(), cachedPartition, this.nowInSec())) {
                cfs.metric.rowCacheHit.inc();
                Tracing.trace("Row cache hit");
                UnfilteredRowIterator unfilteredRowIterator = this.clusteringIndexFilter().getUnfilteredRowIterator(this.columnFilter(), cachedPartition);
                cfs.metric.updateSSTableIterated(0);
                return unfilteredRowIterator;
            }
            cfs.metric.rowCacheHitOutOfRange.inc();
            Tracing.trace("Ignoring row cache as cached value could not satisfy query");
            return this.queryMemtableAndDisk(cfs, readOp);
        }
        cfs.metric.rowCacheMiss.inc();
        Tracing.trace("Row cache miss");
        boolean bl = cacheFullPartitions = this.metadata().clusteringColumns().size() > 0 ? this.metadata().params.caching.cacheAllRows() : this.metadata().params.caching.cacheRows();
        if (cacheFullPartitions || this.clusteringIndexFilter().isHeadFilter()) {
            RowCacheSentinel sentinel = new RowCacheSentinel();
            boolean sentinelSuccess = CacheService.instance.rowCache.putIfAbsent(key, sentinel);
            boolean sentinelReplaced = false;
            try {
                UnfilteredRowIterator cacheIterator;
                UnfilteredRowIterator iter;
                block16: {
                    final int rowsToCache = this.metadata().params.caching.rowsPerPartitionToCache();
                    final boolean enforceStrictLiveness = this.metadata().enforceStrictLiveness();
                    iter = SinglePartitionReadCommand.fullPartitionRead(this.metadata(), this.nowInSec(), this.partitionKey()).queryMemtableAndDisk(cfs, readOp);
                    try {
                        WrappingUnfilteredRowIterator toCacheIterator = new WrappingUnfilteredRowIterator(iter){
                            private int rowsCounted;
                            {
                                super(wrapped);
                                this.rowsCounted = 0;
                            }

                            @Override
                            public boolean hasNext() {
                                return this.rowsCounted < rowsToCache && super.hasNext();
                            }

                            @Override
                            public Unfiltered next() {
                                Row row;
                                Unfiltered unfiltered = super.next();
                                if (unfiltered.isRow() && (row = (Row)unfiltered).hasLiveData(SinglePartitionReadCommand.this.nowInSec(), enforceStrictLiveness)) {
                                    ++this.rowsCounted;
                                }
                                return unfiltered;
                            }
                        };
                        CachedBTreePartition toCache = CachedBTreePartition.create((UnfilteredRowIterator)toCacheIterator, this.nowInSec());
                        if (sentinelSuccess && !toCache.isEmpty()) {
                            Tracing.trace("Caching {} rows", (Object)toCache.rowCount());
                            CacheService.instance.rowCache.replace(key, sentinel, toCache);
                            sentinelReplaced = true;
                        }
                        cacheIterator = this.clusteringIndexFilter().getUnfilteredRowIterator(this.columnFilter(), toCache);
                        if (!cacheFullPartitions) break block16;
                        assert (!iter.hasNext());
                        iter.close();
                        UnfilteredRowIterator unfilteredRowIterator = cacheIterator;
                        return unfilteredRowIterator;
                    }
                    catch (Error | RuntimeException e) {
                        iter.close();
                        throw e;
                    }
                }
                UnfilteredRowIterator unfilteredRowIterator = UnfilteredRowIterators.concat(cacheIterator, this.clusteringIndexFilter().filterNotIndexed(this.columnFilter(), iter));
                return unfilteredRowIterator;
            }
            finally {
                if (sentinelSuccess && !sentinelReplaced) {
                    cfs.invalidateCachedPartition(key);
                }
            }
        }
        Tracing.trace("Fetching data but not populating cache as query does not query from the start of the partition");
        return this.queryMemtableAndDisk(cfs, readOp);
    }

    public UnfilteredRowIterator queryMemtableAndDisk(ColumnFamilyStore cfs, OpOrder.Group readOp) {
        Tracing.trace("Executing single-partition query on {}", (Object)cfs.name);
        boolean copyOnHeap = Memtable.MEMORY_POOL.needToCopyOnHeap();
        return this.queryMemtableAndDiskInternal(cfs, copyOnHeap);
    }

    @Override
    protected int oldestUnrepairedTombstone() {
        return this.oldestUnrepairedTombstone;
    }

    private UnfilteredRowIterator queryMemtableAndDiskInternal(ColumnFamilyStore cfs, boolean copyOnHeap) {
        if (this.clusteringIndexFilter() instanceof ClusteringIndexNamesFilter && !this.queriesMulticellType()) {
            return this.queryMemtableAndSSTablesInTimestampOrder(cfs, copyOnHeap, (ClusteringIndexNamesFilter)this.clusteringIndexFilter());
        }
        Tracing.trace("Acquiring sstable references");
        ColumnFamilyStore.ViewFragment view = cfs.select(View.select(SSTableSet.LIVE, this.partitionKey()));
        ArrayList<UnfilteredRowIterator> iterators = new ArrayList<UnfilteredRowIterator>(Iterables.size(view.memtables) + view.sstables.size());
        ClusteringIndexFilter filter = this.clusteringIndexFilter();
        try {
            for (Memtable memtable : view.memtables) {
                Partition partition = memtable.getPartition(this.partitionKey());
                if (partition == null) continue;
                UnfilteredRowIterator iter = filter.getUnfilteredRowIterator(this.columnFilter(), partition);
                if (copyOnHeap) {
                    iter = UnfilteredRowIterators.cloningIterator(iter, HeapAllocator.instance);
                }
                this.oldestUnrepairedTombstone = Math.min(this.oldestUnrepairedTombstone, partition.stats().minLocalDeletionTime);
                if (this.isForThrift()) {
                    iter = ThriftResultsMerger.maybeWrap(iter, this.nowInSec());
                }
                iterators.add(RTBoundValidator.validate(iter, RTBoundValidator.Stage.MEMTABLE, false));
            }
            Collections.sort(view.sstables, SSTableReader.maxTimestampComparator);
            long mostRecentPartitionTombstone = Long.MIN_VALUE;
            int nonIntersectingSSTables = 0;
            int includedDueToTombstones = 0;
            SSTableReadMetricsCollector metricsCollector = new SSTableReadMetricsCollector();
            for (SSTableReader sstable : view.sstables) {
                UnfilteredRowIterator iter;
                if (sstable.getMaxTimestamp() < mostRecentPartitionTombstone) break;
                if (this.shouldInclude(sstable)) {
                    if (!sstable.isRepaired()) {
                        this.oldestUnrepairedTombstone = Math.min(this.oldestUnrepairedTombstone, sstable.getMinLocalDeletionTime());
                    }
                    iter = filter.filter(sstable.iterator(this.partitionKey(), this.columnFilter(), filter.isReversed(), this.isForThrift(), metricsCollector));
                    if (this.isForThrift()) {
                        iter = ThriftResultsMerger.maybeWrap(iter, this.nowInSec());
                    }
                    iterators.add(RTBoundValidator.validate(iter, RTBoundValidator.Stage.SSTABLE, false));
                    mostRecentPartitionTombstone = Math.max(mostRecentPartitionTombstone, iter.partitionLevelDeletion().markedForDeleteAt());
                    continue;
                }
                ++nonIntersectingSSTables;
                if (!sstable.hasTombstones()) continue;
                iter = filter.filter(sstable.iterator(this.partitionKey(), this.columnFilter(), filter.isReversed(), this.isForThrift(), metricsCollector));
                if (!iter.partitionLevelDeletion().isLive()) {
                    ++includedDueToTombstones;
                    iterators.add(RTBoundValidator.validate(iter, RTBoundValidator.Stage.SSTABLE, false));
                    if (!sstable.isRepaired()) {
                        this.oldestUnrepairedTombstone = Math.min(this.oldestUnrepairedTombstone, sstable.getMinLocalDeletionTime());
                    }
                    mostRecentPartitionTombstone = Math.max(mostRecentPartitionTombstone, iter.partitionLevelDeletion().markedForDeleteAt());
                    continue;
                }
                iter.close();
            }
            if (Tracing.isTracing()) {
                Tracing.trace("Skipped {}/{} non-slice-intersecting sstables, included {} due to tombstones", nonIntersectingSSTables, view.sstables.size(), includedDueToTombstones);
            }
            cfs.metric.updateSSTableIterated(metricsCollector.getMergedSSTables());
            if (iterators.isEmpty()) {
                return EmptyIterators.unfilteredRow(cfs.metadata, this.partitionKey(), filter.isReversed());
            }
            Tracing.trace("Merging data from memtables and {} sstables", (Object)metricsCollector.getMergedSSTables());
            UnfilteredRowIterator merged = UnfilteredRowIterators.merge(iterators, this.nowInSec());
            if (!merged.isEmpty()) {
                DecoratedKey key = merged.partitionKey();
                cfs.metric.samplers.get((Object)TableMetrics.Sampler.READS).addSample(key.getKey(), key.hashCode(), 1);
            }
            return merged;
        }
        catch (Error | RuntimeException e) {
            try {
                FBUtilities.closeAll(iterators);
            }
            catch (Exception suppressed) {
                e.addSuppressed(suppressed);
            }
            throw e;
        }
    }

    private boolean shouldInclude(SSTableReader sstable) {
        if (!this.columnFilter().fetchedColumns().statics.isEmpty()) {
            return true;
        }
        return this.clusteringIndexFilter().shouldInclude(sstable);
    }

    private boolean queriesMulticellType() {
        for (ColumnDefinition column : this.columnFilter().fetchedColumns()) {
            if (!column.type.isMultiCell() && !column.type.isCounter()) continue;
            return true;
        }
        return false;
    }

    private UnfilteredRowIterator queryMemtableAndSSTablesInTimestampOrder(ColumnFamilyStore cfs, boolean copyOnHeap, ClusteringIndexNamesFilter filter) {
        UnfilteredRowIterator iter;
        Tracing.trace("Acquiring sstable references");
        ColumnFamilyStore.ViewFragment view = cfs.select(View.select(SSTableSet.LIVE, this.partitionKey()));
        AbstractBTreePartition result = null;
        Tracing.trace("Merging memtable contents");
        for (Memtable memtable : view.memtables) {
            Partition partition = memtable.getPartition(this.partitionKey());
            if (partition == null) continue;
            iter = filter.getUnfilteredRowIterator(this.columnFilter(), partition);
            Throwable throwable = null;
            try {
                if (iter.isEmpty()) continue;
                UnfilteredRowIterator clonedIter = copyOnHeap ? UnfilteredRowIterators.cloningIterator(iter, HeapAllocator.instance) : iter;
                result = this.add(RTBoundValidator.validate(this.isForThrift() ? ThriftResultsMerger.maybeWrap(clonedIter, this.nowInSec()) : clonedIter, RTBoundValidator.Stage.MEMTABLE, false), (ImmutableBTreePartition)result, filter, false);
            }
            catch (Throwable clonedIter) {
                throwable = clonedIter;
                throw clonedIter;
            }
            finally {
                if (iter == null) continue;
                if (throwable != null) {
                    try {
                        iter.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    continue;
                }
                iter.close();
            }
        }
        Collections.sort(view.sstables, SSTableReader.maxTimestampComparator);
        boolean onlyUnrepaired = true;
        SSTableReadMetricsCollector metricsCollector = new SSTableReadMetricsCollector();
        for (SSTableReader sstable : view.sstables) {
            Throwable throwable;
            UnfilteredRowIterator iter2;
            long currentMaxTs;
            if (result != null && sstable.getMaxTimestamp() < result.partitionLevelDeletion().markedForDeleteAt() || (filter = this.reduceFilter(filter, result, currentMaxTs = sstable.getMaxTimestamp())) == null) break;
            if (!this.shouldInclude(sstable)) {
                if (!sstable.hasTombstones()) continue;
                iter2 = filter.filter(sstable.iterator(this.partitionKey(), this.columnFilter(), filter.isReversed(), this.isForThrift(), metricsCollector));
                throwable = null;
                try {
                    if (!iter2.partitionLevelDeletion().isLive()) {
                        result = this.add(UnfilteredRowIterators.noRowsIterator(iter2.metadata(), iter2.partitionKey(), Rows.EMPTY_STATIC_ROW, iter2.partitionLevelDeletion(), filter.isReversed()), (ImmutableBTreePartition)result, filter, sstable.isRepaired());
                        continue;
                    }
                    result = this.add(RTBoundValidator.validate(iter2, RTBoundValidator.Stage.SSTABLE, false), (ImmutableBTreePartition)result, filter, sstable.isRepaired());
                    continue;
                }
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
                finally {
                    if (iter2 == null) continue;
                    if (throwable != null) {
                        try {
                            iter2.close();
                        }
                        catch (Throwable throwable4) {
                            throwable.addSuppressed(throwable4);
                        }
                        continue;
                    }
                    iter2.close();
                    continue;
                }
            }
            Tracing.trace("Merging data from sstable {}", (Object)sstable.descriptor.generation);
            iter2 = filter.filter(sstable.iterator(this.partitionKey(), this.columnFilter(), filter.isReversed(), this.isForThrift(), metricsCollector));
            throwable = null;
            try {
                if (iter2.isEmpty()) continue;
                if (sstable.isRepaired()) {
                    onlyUnrepaired = false;
                }
                result = this.add(RTBoundValidator.validate(this.isForThrift() ? ThriftResultsMerger.maybeWrap(iter2, this.nowInSec()) : iter2, RTBoundValidator.Stage.SSTABLE, false), (ImmutableBTreePartition)result, filter, sstable.isRepaired());
            }
            catch (Throwable throwable5) {
                throwable = throwable5;
                throw throwable5;
            }
            finally {
                if (iter2 == null) continue;
                if (throwable != null) {
                    try {
                        iter2.close();
                    }
                    catch (Throwable throwable6) {
                        throwable.addSuppressed(throwable6);
                    }
                    continue;
                }
                iter2.close();
            }
        }
        cfs.metric.updateSSTableIterated(metricsCollector.getMergedSSTables());
        if (result == null || result.isEmpty()) {
            return EmptyIterators.unfilteredRow(this.metadata(), this.partitionKey(), false);
        }
        DecoratedKey key = result.partitionKey();
        cfs.metric.samplers.get((Object)TableMetrics.Sampler.READS).addSample(key.getKey(), key.hashCode(), 1);
        if (metricsCollector.getMergedSSTables() > cfs.getMinimumCompactionThreshold() && onlyUnrepaired && !cfs.isAutoCompactionDisabled() && cfs.getCompactionStrategyManager().shouldDefragment()) {
            Tracing.trace("Defragmenting requested data");
            iter = result.unfilteredIterator(this.columnFilter(), Slices.ALL, false);
            Throwable throwable = null;
            try {
                final Mutation mutation = new Mutation(PartitionUpdate.fromIterator(iter));
                StageManager.getStage(Stage.MUTATION).execute(new Runnable(){

                    @Override
                    public void run() {
                        Keyspace.open(mutation.getKeyspaceName()).apply(mutation, false, false);
                    }
                });
            }
            catch (Throwable throwable7) {
                throwable = throwable7;
                throw throwable7;
            }
            finally {
                if (iter != null) {
                    if (throwable != null) {
                        try {
                            iter.close();
                        }
                        catch (Throwable throwable8) {
                            throwable.addSuppressed(throwable8);
                        }
                    } else {
                        iter.close();
                    }
                }
            }
        }
        return result.unfilteredIterator(this.columnFilter(), Slices.ALL, this.clusteringIndexFilter().isReversed());
    }

    private ImmutableBTreePartition add(UnfilteredRowIterator iter, ImmutableBTreePartition result, ClusteringIndexNamesFilter filter, boolean isRepaired) {
        if (!isRepaired) {
            this.oldestUnrepairedTombstone = Math.min(this.oldestUnrepairedTombstone, iter.stats().minLocalDeletionTime);
        }
        int maxRows = Math.max(filter.requestedRows().size(), 1);
        if (result == null) {
            return ImmutableBTreePartition.create(iter, maxRows);
        }
        try (UnfilteredRowIterator merged = UnfilteredRowIterators.merge(Arrays.asList(iter, result.unfilteredIterator(this.columnFilter(), Slices.ALL, filter.isReversed())), this.nowInSec());){
            ImmutableBTreePartition immutableBTreePartition = ImmutableBTreePartition.create(merged, maxRows);
            return immutableBTreePartition;
        }
    }

    private ClusteringIndexNamesFilter reduceFilter(ClusteringIndexNamesFilter filter, Partition result, long sstableTimestamp) {
        boolean hasNoMoreClusterings;
        if (result == null) {
            return filter;
        }
        SearchIterator<Clustering, Row> searchIter = result.searchIterator(this.columnFilter(), false);
        PartitionColumns columns = this.columnFilter().fetchedColumns();
        NavigableSet<Clustering> clusterings = filter.requestedRows();
        boolean removeStatic = false;
        if (!columns.statics.isEmpty()) {
            Row staticRow = searchIter.next(Clustering.STATIC_CLUSTERING);
            removeStatic = staticRow != null && this.canRemoveRow(staticRow, columns.statics, sstableTimestamp);
        }
        TreeSet<Clusterable> toRemove = null;
        for (Clustering clustering : clusterings) {
            Row row = searchIter.next(clustering);
            if (row == null || !this.canRemoveRow(row, columns.regulars, sstableTimestamp)) continue;
            if (toRemove == null) {
                toRemove = new TreeSet<Clusterable>(result.metadata().comparator);
            }
            toRemove.add(clustering);
        }
        if (!removeStatic && toRemove == null) {
            return filter;
        }
        boolean hasNoMoreStatic = columns.statics.isEmpty() || removeStatic;
        boolean bl = hasNoMoreClusterings = clusterings.isEmpty() || toRemove != null && toRemove.size() == clusterings.size();
        if (hasNoMoreStatic && hasNoMoreClusterings) {
            return null;
        }
        if (toRemove != null) {
            BTreeSet.Builder<Clusterable> newClusterings = BTreeSet.builder(result.metadata().comparator);
            newClusterings.addAll((Collection<Clusterable>)Sets.difference(clusterings, toRemove));
            clusterings = newClusterings.build();
        }
        return new ClusteringIndexNamesFilter(clusterings, filter.isReversed());
    }

    private boolean canRemoveRow(Row row, Columns requestedColumns, long sstableTimestamp) {
        if (row.primaryKeyLivenessInfo().isEmpty() || row.primaryKeyLivenessInfo().timestamp() <= sstableTimestamp) {
            return false;
        }
        for (ColumnDefinition column : requestedColumns) {
            Cell cell = row.getCell(column);
            if (cell != null && cell.timestamp() > sstableTimestamp) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean selectsFullPartition() {
        return this.metadata().isStaticCompactTable() || this.clusteringIndexFilter.selectsAllPartition() && !this.rowFilter().hasExpressionOnClusteringOrRegularColumns();
    }

    public String toString() {
        return String.format("Read(%s.%s columns=%s rowFilter=%s limits=%s key=%s filter=%s, nowInSec=%d)", this.metadata().ksName, this.metadata().cfName, this.columnFilter(), this.rowFilter(), this.limits(), this.metadata().getKeyValidator().getString(this.partitionKey().getKey()), this.clusteringIndexFilter.toString(this.metadata()), this.nowInSec());
    }

    @Override
    public MessageOut<ReadCommand> createMessage(int version) {
        return new MessageOut<ReadCommand>(MessagingService.Verb.READ, this, readSerializer);
    }

    @Override
    protected void appendCQLWhereClause(StringBuilder sb) {
        String filterString;
        sb.append(" WHERE ");
        sb.append(ColumnDefinition.toCQLString(this.metadata().partitionKeyColumns())).append(" = ");
        DataRange.appendKeyString(sb, this.metadata().getKeyValidator(), this.partitionKey().getKey());
        if (!this.rowFilter().isEmpty()) {
            sb.append(" AND ").append(this.rowFilter());
        }
        if (!(filterString = this.clusteringIndexFilter().toCQLString(this.metadata())).isEmpty()) {
            sb.append(" AND ").append(filterString);
        }
    }

    @Override
    protected void serializeSelection(DataOutputPlus out, int version) throws IOException {
        this.metadata().getKeyValidator().writeValue(this.partitionKey().getKey(), out);
        ClusteringIndexFilter.serializer.serialize(this.clusteringIndexFilter(), out, version);
    }

    @Override
    protected long selectionSerializedSize(int version) {
        return this.metadata().getKeyValidator().writtenLength(this.partitionKey().getKey()) + ClusteringIndexFilter.serializer.serializedSize(this.clusteringIndexFilter(), version);
    }

    @Override
    public boolean isLimitedToOnePartition() {
        return true;
    }

    private static final class SSTableReadMetricsCollector
    implements SSTableReadsListener {
        private int mergedSSTables;

        private SSTableReadMetricsCollector() {
        }

        @Override
        public void onSSTableSelected(SSTableReader sstable, RowIndexEntry<?> indexEntry, SSTableReadsListener.SelectionReason reason) {
            sstable.incrementReadCount();
            ++this.mergedSSTables;
        }

        public int getMergedSSTables() {
            return this.mergedSSTables;
        }
    }

    private static class Deserializer
    extends ReadCommand.SelectionDeserializer {
        private Deserializer() {
        }

        @Override
        public ReadCommand deserialize(DataInputPlus in, int version, boolean isDigest, int digestVersion, boolean isForThrift, CFMetaData metadata, int nowInSec, ColumnFilter columnFilter, RowFilter rowFilter, DataLimits limits, IndexMetadata index) throws IOException {
            DecoratedKey key = metadata.decorateKey(metadata.getKeyValidator().readValue(in, DatabaseDescriptor.getMaxValueSize()));
            ClusteringIndexFilter filter = ClusteringIndexFilter.serializer.deserialize(in, version, metadata);
            return new SinglePartitionReadCommand(isDigest, digestVersion, isForThrift, metadata, nowInSec, columnFilter, rowFilter, limits, key, filter, index);
        }
    }

    public static class Group
    implements ReadQuery {
        public final List<SinglePartitionReadCommand> commands;
        private final DataLimits limits;
        private final int nowInSec;
        private final boolean selectsFullPartitions;

        public Group(List<SinglePartitionReadCommand> commands, DataLimits limits) {
            assert (!commands.isEmpty());
            this.commands = commands;
            this.limits = limits;
            SinglePartitionReadCommand firstCommand = commands.get(0);
            this.nowInSec = firstCommand.nowInSec();
            this.selectsFullPartitions = firstCommand.selectsFullPartition();
            for (int i = 1; i < commands.size(); ++i) {
                assert (commands.get(i).nowInSec() == this.nowInSec);
            }
        }

        public static Group one(SinglePartitionReadCommand command) {
            return new Group(Collections.singletonList(command), command.limits());
        }

        @Override
        public PartitionIterator execute(ConsistencyLevel consistency, ClientState clientState) throws RequestExecutionException {
            return StorageProxy.read(this, consistency, clientState);
        }

        public int nowInSec() {
            return this.nowInSec;
        }

        @Override
        public DataLimits limits() {
            return this.limits;
        }

        public CFMetaData metadata() {
            return this.commands.get(0).metadata();
        }

        @Override
        public boolean selectsFullPartition() {
            return this.selectsFullPartitions;
        }

        @Override
        public ReadOrderGroup startOrderGroup() {
            return this.commands.get(0).startOrderGroup();
        }

        @Override
        public PartitionIterator executeInternal(ReadOrderGroup orderGroup) {
            ArrayList<PartitionIterator> partitions = new ArrayList<PartitionIterator>(this.commands.size());
            for (SinglePartitionReadCommand cmd : this.commands) {
                partitions.add(cmd.executeInternal(orderGroup));
            }
            boolean enforceStrictLiveness = this.commands.get(0).metadata().enforceStrictLiveness();
            return this.limits.filter(PartitionIterators.concat(partitions), this.nowInSec, this.selectsFullPartitions, enforceStrictLiveness);
        }

        @Override
        public QueryPager getPager(PagingState pagingState, int protocolVersion) {
            if (this.commands.size() == 1) {
                return SinglePartitionReadCommand.getPager(this.commands.get(0), pagingState, protocolVersion);
            }
            return new MultiPartitionPager(this, pagingState, protocolVersion);
        }

        @Override
        public boolean selectsKey(DecoratedKey key) {
            return Iterables.any(this.commands, c -> c.selectsKey(key));
        }

        @Override
        public boolean selectsClustering(DecoratedKey key, Clustering clustering) {
            return Iterables.any(this.commands, c -> c.selectsClustering(key, clustering));
        }

        public String toString() {
            return this.commands.toString();
        }
    }
}

