/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.concurrent;

import com.google.common.annotations.VisibleForTesting;
import java.util.EnumMap;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.cassandra.concurrent.ExecutorLocals;
import org.apache.cassandra.concurrent.JMXEnabledThreadPoolExecutor;
import org.apache.cassandra.concurrent.LocalAwareExecutorService;
import org.apache.cassandra.concurrent.NamedThreadFactory;
import org.apache.cassandra.concurrent.SharedExecutorPool;
import org.apache.cassandra.concurrent.Stage;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.net.MessagingService;
import org.apache.cassandra.utils.ExecutorUtils;
import org.apache.cassandra.utils.FBUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StageManager {
    private static final Logger logger = LoggerFactory.getLogger(StageManager.class);
    private static final EnumMap<Stage, LocalAwareExecutorService> stages = new EnumMap(Stage.class);
    public static final long KEEPALIVE = 60L;
    public static final Runnable NO_OP_TASK;

    private static ExecuteOnlyExecutor tracingExecutor() {
        RejectedExecutionHandler reh = new RejectedExecutionHandler(){

            @Override
            public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
                MessagingService.instance().incrementDroppedMessages(MessagingService.Verb._TRACE);
            }
        };
        return new ExecuteOnlyExecutor(1, 1, 60L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(1000), new NamedThreadFactory(Stage.TRACING.getJmxName()), reh);
    }

    private static JMXEnabledThreadPoolExecutor multiThreadedStage(Stage stage, int numThreads) {
        return new JMXEnabledThreadPoolExecutor(numThreads, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new NamedThreadFactory(stage.getJmxName()), stage.getJmxType());
    }

    private static LocalAwareExecutorService multiThreadedLowSignalStage(Stage stage, int numThreads) {
        return SharedExecutorPool.SHARED.newExecutor(numThreads, Integer.MAX_VALUE, stage.getJmxType(), stage.getJmxName());
    }

    public static LocalAwareExecutorService getStage(Stage stage) {
        return stages.get((Object)stage);
    }

    public static void shutdownNow() {
        for (Stage stage : Stage.values()) {
            stages.get((Object)stage).shutdownNow();
        }
    }

    @VisibleForTesting
    public static void shutdownAndWait(long timeout, TimeUnit unit) throws InterruptedException, TimeoutException {
        ExecutorUtils.shutdownNowAndWait(timeout, unit, stages.values());
    }

    static {
        stages.put(Stage.MUTATION, StageManager.multiThreadedLowSignalStage(Stage.MUTATION, DatabaseDescriptor.getConcurrentWriters()));
        stages.put(Stage.COUNTER_MUTATION, StageManager.multiThreadedLowSignalStage(Stage.COUNTER_MUTATION, DatabaseDescriptor.getConcurrentCounterWriters()));
        stages.put(Stage.VIEW_MUTATION, StageManager.multiThreadedLowSignalStage(Stage.VIEW_MUTATION, DatabaseDescriptor.getConcurrentViewWriters()));
        stages.put(Stage.READ, StageManager.multiThreadedLowSignalStage(Stage.READ, DatabaseDescriptor.getConcurrentReaders()));
        stages.put(Stage.REQUEST_RESPONSE, StageManager.multiThreadedLowSignalStage(Stage.REQUEST_RESPONSE, FBUtilities.getAvailableProcessors()));
        stages.put(Stage.INTERNAL_RESPONSE, StageManager.multiThreadedStage(Stage.INTERNAL_RESPONSE, FBUtilities.getAvailableProcessors()));
        stages.put(Stage.GOSSIP, new JMXEnabledThreadPoolExecutor(Stage.GOSSIP));
        stages.put(Stage.ANTI_ENTROPY, new JMXEnabledThreadPoolExecutor(Stage.ANTI_ENTROPY));
        stages.put(Stage.MIGRATION, new JMXEnabledThreadPoolExecutor(Stage.MIGRATION));
        stages.put(Stage.MISC, new JMXEnabledThreadPoolExecutor(Stage.MISC));
        stages.put(Stage.READ_REPAIR, StageManager.multiThreadedStage(Stage.READ_REPAIR, FBUtilities.getAvailableProcessors()));
        stages.put(Stage.TRACING, StageManager.tracingExecutor());
        NO_OP_TASK = new Runnable(){

            @Override
            public void run() {
            }
        };
    }

    private static class ExecuteOnlyExecutor
    extends ThreadPoolExecutor
    implements LocalAwareExecutorService {
        public ExecuteOnlyExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, ThreadFactory threadFactory, RejectedExecutionHandler handler) {
            super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, threadFactory, handler);
        }

        @Override
        public void execute(Runnable command, ExecutorLocals locals) {
            assert (locals == null);
            super.execute(command);
        }

        @Override
        public void maybeExecuteImmediately(Runnable command) {
            this.execute(command);
        }

        @Override
        public Future<?> submit(Runnable task) {
            if (task.equals(NO_OP_TASK)) {
                assert (this.getMaximumPoolSize() == 1) : "Cannot wait for pending tasks if running more than 1 thread";
                return super.submit(task);
            }
            throw new UnsupportedOperationException();
        }

        @Override
        public <T> Future<T> submit(Runnable task, T result) {
            throw new UnsupportedOperationException();
        }

        @Override
        public <T> Future<T> submit(Callable<T> task) {
            throw new UnsupportedOperationException();
        }
    }
}

