/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Iterables;
import com.google.common.collect.PeekingIterator;
import java.io.IOError;
import java.io.IOException;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.function.Supplier;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.db.ClusteringPrefix;
import org.apache.cassandra.db.DeletionTime;
import org.apache.cassandra.db.LegacyLayout;
import org.apache.cassandra.db.RangeTombstone;
import org.apache.cassandra.db.SerializationHeader;
import org.apache.cassandra.db.Slice;
import org.apache.cassandra.db.UnknownColumnException;
import org.apache.cassandra.db.rows.BTreeRow;
import org.apache.cassandra.db.rows.RangeTombstoneBoundMarker;
import org.apache.cassandra.db.rows.RangeTombstoneBoundaryMarker;
import org.apache.cassandra.db.rows.RangeTombstoneMarker;
import org.apache.cassandra.db.rows.Row;
import org.apache.cassandra.db.rows.SerializationHelper;
import org.apache.cassandra.db.rows.Unfiltered;
import org.apache.cassandra.db.rows.UnfilteredSerializer;
import org.apache.cassandra.io.util.DataInputPlus;
import org.apache.cassandra.io.util.FileDataInput;

public abstract class UnfilteredDeserializer {
    protected final CFMetaData metadata;
    protected final DataInputPlus in;
    protected final SerializationHelper helper;

    protected UnfilteredDeserializer(CFMetaData metadata, DataInputPlus in, SerializationHelper helper) {
        this.metadata = metadata;
        this.in = in;
        this.helper = helper;
    }

    public static UnfilteredDeserializer create(CFMetaData metadata, DataInputPlus in, SerializationHeader header, SerializationHelper helper, DeletionTime partitionDeletion, boolean readAllAsDynamic) {
        if (helper.version >= 10) {
            return new CurrentDeserializer(metadata, in, header, helper);
        }
        return new OldFormatDeserializer(metadata, in, helper, partitionDeletion, readAllAsDynamic);
    }

    public abstract boolean hasNext() throws IOException;

    public abstract int compareNextTo(Slice.Bound var1) throws IOException;

    public abstract boolean nextIsRow() throws IOException;

    public abstract boolean nextIsStatic() throws IOException;

    public abstract Unfiltered readNext() throws IOException;

    public abstract void clearState() throws IOException;

    public abstract void skipNext() throws IOException;

    public abstract long bytesReadForUnconsumedData();

    public static class OldFormatDeserializer
    extends UnfilteredDeserializer {
        private final boolean readAllAsDynamic;
        private boolean skipStatic;
        private Unfiltered next;
        private long nextConsumedPosition;
        private Stash stash;
        private boolean couldBeStartOfPartition = true;
        private final UnfilteredIterator iterator;
        private long lastConsumedPosition;
        private long bytesReadForNextAtom = 0L;

        private OldFormatDeserializer(CFMetaData metadata, DataInputPlus in, SerializationHelper helper, DeletionTime partitionDeletion, boolean readAllAsDynamic) {
            super(metadata, in, helper);
            this.iterator = new UnfilteredIterator(metadata, partitionDeletion, helper, this::readAtom);
            this.readAllAsDynamic = readAllAsDynamic;
            this.lastConsumedPosition = this.currentPosition();
        }

        /*
         * Loose catch block
         */
        private LegacyLayout.LegacyAtom readAtom() {
            while (true) {
                try {
                    long pos = this.currentPosition();
                    LegacyLayout.LegacyAtom atom = LegacyLayout.readLegacyAtom(this.metadata, this.in, this.readAllAsDynamic);
                    this.bytesReadForNextAtom = this.currentPosition() - pos;
                    return atom;
                }
                catch (UnknownColumnException pos) {
                    continue;
                }
                break;
            }
            catch (IOException e) {
                throw new IOError(e);
            }
        }

        public void setSkipStatic() {
            this.skipStatic = true;
        }

        private boolean isStatic(Unfiltered unfiltered) {
            return unfiltered.isRow() && ((Row)unfiltered).isStatic();
        }

        @Override
        public boolean hasNext() throws IOException {
            try {
                while (this.next == null) {
                    if (null != this.stash) {
                        this.next = this.stash.unfiltered;
                        this.nextConsumedPosition = this.stash.consumedPosition;
                        this.stash = null;
                    } else {
                        if (!this.iterator.hasNext()) {
                            return false;
                        }
                        this.next = this.iterator.next();
                        this.nextConsumedPosition = this.currentPosition() - this.bytesReadForNextAtom;
                    }
                    if (this.couldBeStartOfPartition && this.next.isRangeTombstoneMarker() && this.next.clustering().size() == 0 && this.iterator.hasNext()) {
                        Unfiltered unfiltered = this.iterator.next();
                        long consumedPosition = this.currentPosition() - this.bytesReadForNextAtom;
                        this.stash = new Stash(unfiltered, consumedPosition);
                        if (this.isStatic(unfiltered)) {
                            this.stash.unfiltered = this.next;
                            this.next = unfiltered;
                        }
                    }
                    this.couldBeStartOfPartition = false;
                    if (!this.skipStatic || !this.isStatic(this.next)) continue;
                    this.next = null;
                }
                return true;
            }
            catch (IOError e) {
                if (e.getCause() != null && e.getCause() instanceof IOException) {
                    throw (IOException)e.getCause();
                }
                throw e;
            }
        }

        @Override
        public int compareNextTo(Slice.Bound bound) throws IOException {
            if (!this.hasNext()) {
                throw new IllegalStateException();
            }
            return this.metadata.comparator.compare(this.next.clustering(), bound);
        }

        @Override
        public boolean nextIsRow() throws IOException {
            if (!this.hasNext()) {
                throw new IllegalStateException();
            }
            return this.next.isRow();
        }

        @Override
        public boolean nextIsStatic() throws IOException {
            return this.nextIsRow() && ((Row)this.next).isStatic();
        }

        private long currentPosition() {
            return this.in instanceof FileDataInput ? ((FileDataInput)this.in).getFilePointer() : 0L;
        }

        @Override
        public Unfiltered readNext() throws IOException {
            if (!this.hasNext()) {
                throw new IllegalStateException();
            }
            Unfiltered toReturn = this.next;
            this.next = null;
            this.lastConsumedPosition = this.nextConsumedPosition;
            return toReturn;
        }

        @Override
        public void skipNext() throws IOException {
            this.readNext();
        }

        @Override
        public long bytesReadForUnconsumedData() {
            if (!(this.in instanceof FileDataInput)) {
                throw new AssertionError();
            }
            return this.currentPosition() - this.lastConsumedPosition;
        }

        @Override
        public void clearState() {
            this.next = null;
            this.stash = null;
            this.couldBeStartOfPartition = true;
            this.iterator.clearState();
            this.lastConsumedPosition = this.currentPosition();
            this.bytesReadForNextAtom = 0L;
        }

        @VisibleForTesting
        static class UnfilteredIterator
        implements PeekingIterator<Unfiltered> {
            private final AtomIterator atoms;
            private final LegacyLayout.CellGrouper grouper;
            private final TombstoneTracker tombstoneTracker;
            private final CFMetaData metadata;
            private final SerializationHelper helper;
            private Unfiltered next;

            UnfilteredIterator(CFMetaData metadata, DeletionTime partitionDeletion, SerializationHelper helper, Supplier<LegacyLayout.LegacyAtom> atomReader) {
                this.metadata = metadata;
                this.helper = helper;
                this.grouper = new LegacyLayout.CellGrouper(metadata, helper);
                this.tombstoneTracker = new TombstoneTracker(partitionDeletion);
                this.atoms = new AtomIterator(atomReader);
            }

            private boolean isRow(LegacyLayout.LegacyAtom atom) {
                if (atom.isCell()) {
                    return true;
                }
                LegacyLayout.LegacyRangeTombstone tombstone = atom.asRangeTombstone();
                return tombstone.isCollectionTombstone() || tombstone.isRowDeletion(this.metadata);
            }

            public boolean hasNext() {
                while (this.next == null) {
                    if (this.atoms.hasNext()) {
                        if (this.tombstoneTracker.hasOpeningMarkerBefore(this.atoms.peek())) {
                            this.next = this.tombstoneTracker.popOpeningMarker();
                            continue;
                        }
                        if (this.tombstoneTracker.hasClosingMarkerBefore(this.atoms.peek())) {
                            this.next = this.tombstoneTracker.popClosingMarker();
                            continue;
                        }
                        LegacyLayout.LegacyAtom atom = this.atoms.next();
                        if (this.tombstoneTracker.isShadowed(atom)) continue;
                        if (this.isRow(atom)) {
                            this.next = this.readRow(atom);
                            continue;
                        }
                        this.tombstoneTracker.openNew(atom.asRangeTombstone());
                        continue;
                    }
                    if (this.tombstoneTracker.hasOpenTombstones()) {
                        this.next = this.tombstoneTracker.popMarker();
                        continue;
                    }
                    return false;
                }
                return this.next != null;
            }

            private Unfiltered readRow(LegacyLayout.LegacyAtom first) {
                LegacyLayout.CellGrouper grouper = first.isStatic() ? LegacyLayout.CellGrouper.staticGrouper(this.metadata, this.helper) : this.grouper;
                grouper.reset();
                grouper.addAtom(first);
                while (this.atoms.hasNext() && grouper.addAtom(this.atoms.peek())) {
                    this.atoms.next();
                }
                return grouper.getRow();
            }

            public Unfiltered next() {
                if (!this.hasNext()) {
                    throw new UnsupportedOperationException();
                }
                Unfiltered toReturn = this.next;
                this.next = null;
                return toReturn;
            }

            public Unfiltered peek() {
                if (!this.hasNext()) {
                    throw new UnsupportedOperationException();
                }
                return this.next;
            }

            public void clearState() {
                this.atoms.clearState();
                this.tombstoneTracker.clearState();
                this.next = null;
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }

            private class TombstoneTracker {
                private final DeletionTime partitionDeletion;
                private RangeTombstoneMarker openMarkerToReturn;
                private final SortedSet<LegacyLayout.LegacyRangeTombstone> openTombstones;

                public TombstoneTracker(DeletionTime partitionDeletion) {
                    this.partitionDeletion = partitionDeletion;
                    this.openTombstones = new TreeSet<LegacyLayout.LegacyRangeTombstone>((rt1, rt2) -> ((UnfilteredIterator)UnfilteredIterator.this).metadata.comparator.compare(rt1.stop.bound, rt2.stop.bound));
                }

                public boolean isShadowed(LegacyLayout.LegacyAtom atom) {
                    long timestamp;
                    assert (!this.hasClosingMarkerBefore(atom));
                    long l = timestamp = atom.isCell() ? atom.asCell().timestamp : atom.asRangeTombstone().deletionTime.markedForDeleteAt();
                    if (this.partitionDeletion.deletes(timestamp)) {
                        return true;
                    }
                    SortedSet<LegacyLayout.LegacyRangeTombstone> coveringTombstones = UnfilteredIterator.this.isRow(atom) ? this.openTombstones : this.openTombstones.tailSet(atom.asRangeTombstone());
                    return Iterables.any(coveringTombstones, tombstone -> tombstone.deletionTime.deletes(timestamp));
                }

                public boolean hasOpeningMarkerBefore(LegacyLayout.LegacyAtom atom) {
                    return this.openMarkerToReturn != null && ((UnfilteredIterator)UnfilteredIterator.this).metadata.comparator.compare(this.openMarkerToReturn.openBound(false), atom.clustering()) < 0;
                }

                public Unfiltered popOpeningMarker() {
                    assert (this.openMarkerToReturn != null);
                    RangeTombstoneMarker toReturn = this.openMarkerToReturn;
                    this.openMarkerToReturn = null;
                    return toReturn;
                }

                public boolean hasClosingMarkerBefore(LegacyLayout.LegacyAtom atom) {
                    return !this.openTombstones.isEmpty() && ((UnfilteredIterator)UnfilteredIterator.this).metadata.comparator.compare(this.openTombstones.first().stop.bound, atom.clustering()) < 0;
                }

                public Unfiltered popClosingMarker() {
                    assert (!this.openTombstones.isEmpty());
                    Iterator iter = this.openTombstones.iterator();
                    LegacyLayout.LegacyRangeTombstone first = (LegacyLayout.LegacyRangeTombstone)iter.next();
                    iter.remove();
                    if (!iter.hasNext()) {
                        return new RangeTombstoneBoundMarker(first.stop.bound, first.deletionTime);
                    }
                    LegacyLayout.LegacyRangeTombstone next = (LegacyLayout.LegacyRangeTombstone)iter.next();
                    return RangeTombstoneBoundaryMarker.makeBoundary(false, first.stop.bound, first.stop.bound.invert(), first.deletionTime, next.deletionTime);
                }

                public Unfiltered popMarker() {
                    assert (this.hasOpenTombstones());
                    return this.openMarkerToReturn == null ? this.popClosingMarker() : this.popOpeningMarker();
                }

                public void openNew(LegacyLayout.LegacyRangeTombstone tombstone) {
                    if (this.openTombstones.isEmpty()) {
                        assert (this.openMarkerToReturn == null);
                        this.openTombstones.add(tombstone);
                        this.openMarkerToReturn = new RangeTombstoneBoundMarker(tombstone.start.bound, tombstone.deletionTime);
                        return;
                    }
                    if (this.openMarkerToReturn != null) {
                        if (tombstone.deletionTime.supersedes(this.openMarkerToReturn.openDeletionTime(false))) {
                            this.openMarkerToReturn = this.openMarkerToReturn.withNewOpeningDeletionTime(false, tombstone.deletionTime);
                        }
                    } else {
                        DeletionTime currentOpenDeletion = this.openTombstones.first().deletionTime;
                        if (tombstone.deletionTime.supersedes(currentOpenDeletion)) {
                            this.openMarkerToReturn = RangeTombstoneBoundaryMarker.makeBoundary(false, tombstone.start.bound.invert(), tombstone.start.bound, currentOpenDeletion, tombstone.deletionTime);
                        }
                    }
                    this.add(tombstone);
                }

                private void add(LegacyLayout.LegacyRangeTombstone tombstone) {
                    Iterator iter = this.openTombstones.iterator();
                    while (iter.hasNext()) {
                        LegacyLayout.LegacyRangeTombstone existing = (LegacyLayout.LegacyRangeTombstone)iter.next();
                        if (((UnfilteredIterator)UnfilteredIterator.this).metadata.comparator.compare(tombstone.stop.bound, existing.stop.bound) < 0) break;
                        if (existing.deletionTime.supersedes(tombstone.deletionTime)) continue;
                        iter.remove();
                    }
                    this.openTombstones.add(tombstone);
                }

                public boolean hasOpenTombstones() {
                    return this.openMarkerToReturn != null || !this.openTombstones.isEmpty();
                }

                public void clearState() {
                    this.openMarkerToReturn = null;
                    this.openTombstones.clear();
                }
            }

            private static class AtomIterator
            implements PeekingIterator<LegacyLayout.LegacyAtom> {
                private final Supplier<LegacyLayout.LegacyAtom> atomReader;
                private boolean isDone;
                private LegacyLayout.LegacyAtom next;

                private AtomIterator(Supplier<LegacyLayout.LegacyAtom> atomReader) {
                    this.atomReader = atomReader;
                }

                public boolean hasNext() {
                    if (this.isDone) {
                        return false;
                    }
                    if (this.next == null) {
                        this.next = this.atomReader.get();
                        if (this.next == null) {
                            this.isDone = true;
                            return false;
                        }
                    }
                    return true;
                }

                public LegacyLayout.LegacyAtom next() {
                    if (!this.hasNext()) {
                        throw new UnsupportedOperationException();
                    }
                    LegacyLayout.LegacyAtom toReturn = this.next;
                    this.next = null;
                    return toReturn;
                }

                public LegacyLayout.LegacyAtom peek() {
                    if (!this.hasNext()) {
                        throw new UnsupportedOperationException();
                    }
                    return this.next;
                }

                public void clearState() {
                    this.next = null;
                    this.isDone = false;
                }

                public void remove() {
                    throw new UnsupportedOperationException();
                }
            }
        }

        private static final class Stash {
            private Unfiltered unfiltered;
            long consumedPosition;

            private Stash(Unfiltered unfiltered, long consumedPosition) {
                this.unfiltered = unfiltered;
                this.consumedPosition = consumedPosition;
            }
        }
    }

    private static class CurrentDeserializer
    extends UnfilteredDeserializer {
        private final ClusteringPrefix.Deserializer clusteringDeserializer;
        private final SerializationHeader header;
        private int nextFlags;
        private int nextExtendedFlags;
        private boolean isReady;
        private boolean isDone;
        private final Row.Builder builder;

        private CurrentDeserializer(CFMetaData metadata, DataInputPlus in, SerializationHeader header, SerializationHelper helper) {
            super(metadata, in, helper);
            this.header = header;
            this.clusteringDeserializer = new ClusteringPrefix.Deserializer(metadata.comparator, in, header);
            this.builder = BTreeRow.sortedBuilder();
        }

        @Override
        public boolean hasNext() throws IOException {
            if (this.isReady) {
                return true;
            }
            this.prepareNext();
            return !this.isDone;
        }

        private void prepareNext() throws IOException {
            if (this.isDone) {
                return;
            }
            this.nextFlags = this.in.readUnsignedByte();
            if (UnfilteredSerializer.isEndOfPartition(this.nextFlags)) {
                this.isDone = true;
                this.isReady = false;
                return;
            }
            this.nextExtendedFlags = UnfilteredSerializer.readExtendedFlags(this.in, this.nextFlags);
            this.clusteringDeserializer.prepare(this.nextFlags, this.nextExtendedFlags);
            this.isReady = true;
        }

        @Override
        public int compareNextTo(Slice.Bound bound) throws IOException {
            if (!this.isReady) {
                this.prepareNext();
            }
            assert (!this.isDone);
            return this.clusteringDeserializer.compareNextTo(bound);
        }

        @Override
        public boolean nextIsRow() throws IOException {
            if (!this.isReady) {
                this.prepareNext();
            }
            return UnfilteredSerializer.kind(this.nextFlags) == Unfiltered.Kind.ROW;
        }

        @Override
        public boolean nextIsStatic() throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public Unfiltered readNext() throws IOException {
            this.isReady = false;
            if (UnfilteredSerializer.kind(this.nextFlags) == Unfiltered.Kind.RANGE_TOMBSTONE_MARKER) {
                RangeTombstone.Bound bound = this.clusteringDeserializer.deserializeNextBound();
                return UnfilteredSerializer.serializer.deserializeMarkerBody(this.in, this.header, bound);
            }
            this.builder.newRow(this.clusteringDeserializer.deserializeNextClustering());
            return UnfilteredSerializer.serializer.deserializeRowBody(this.in, this.header, this.helper, this.nextFlags, this.nextExtendedFlags, this.builder);
        }

        @Override
        public void skipNext() throws IOException {
            this.isReady = false;
            this.clusteringDeserializer.skipNext();
            if (UnfilteredSerializer.kind(this.nextFlags) == Unfiltered.Kind.RANGE_TOMBSTONE_MARKER) {
                UnfilteredSerializer.serializer.skipMarkerBody(this.in);
            } else {
                UnfilteredSerializer.serializer.skipRowBody(this.in);
            }
        }

        @Override
        public void clearState() {
            this.isReady = false;
            this.isDone = false;
        }

        @Override
        public long bytesReadForUnconsumedData() {
            return 0L;
        }
    }
}

