/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Objects;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.db.AbstractClusteringPrefix;
import org.apache.cassandra.db.CBuilder;
import org.apache.cassandra.db.Clustering;
import org.apache.cassandra.db.ClusteringComparator;
import org.apache.cassandra.db.ClusteringPrefix;
import org.apache.cassandra.db.RangeTombstone;
import org.apache.cassandra.db.TypeSizes;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.io.util.DataInputPlus;
import org.apache.cassandra.io.util.DataOutputPlus;

public class Slice {
    public static final Serializer serializer = new Serializer();
    public static final Slice ALL = new Slice(Bound.BOTTOM, Bound.TOP){

        @Override
        public boolean selects(ClusteringComparator comparator, Clustering clustering) {
            return true;
        }

        @Override
        public boolean intersects(ClusteringComparator comparator, List<ByteBuffer> minClusteringValues, List<ByteBuffer> maxClusteringValues) {
            return true;
        }

        @Override
        public String toString(ClusteringComparator comparator) {
            return "ALL";
        }
    };
    private final Bound start;
    private final Bound end;

    private Slice(Bound start, Bound end) {
        assert (start.isStart() && end.isEnd());
        this.start = start;
        this.end = end;
    }

    public static Slice make(Bound start, Bound end) {
        if (start == Bound.BOTTOM && end == Bound.TOP) {
            return ALL;
        }
        return new Slice(start, end);
    }

    public static Slice make(ClusteringComparator comparator, Object ... values) {
        CBuilder builder = CBuilder.create(comparator);
        for (Object val : values) {
            if (val instanceof ByteBuffer) {
                builder.add((ByteBuffer)val);
                continue;
            }
            builder.add(val);
        }
        return new Slice(builder.buildBound(true, true), builder.buildBound(false, true));
    }

    public static Slice make(Clustering clustering) {
        assert (clustering != Clustering.STATIC_CLUSTERING);
        ByteBuffer[] values = Slice.extractValues(clustering);
        return new Slice(Bound.inclusiveStartOf(values), Bound.inclusiveEndOf(values));
    }

    public static Slice make(Clustering start, Clustering end) {
        assert (start != Clustering.STATIC_CLUSTERING && end != Clustering.STATIC_CLUSTERING);
        ByteBuffer[] startValues = Slice.extractValues(start);
        ByteBuffer[] endValues = Slice.extractValues(end);
        return new Slice(Bound.inclusiveStartOf(startValues), Bound.inclusiveEndOf(endValues));
    }

    private static ByteBuffer[] extractValues(ClusteringPrefix clustering) {
        ByteBuffer[] values = new ByteBuffer[clustering.size()];
        for (int i = 0; i < clustering.size(); ++i) {
            values[i] = clustering.get(i);
        }
        return values;
    }

    public Bound start() {
        return this.start;
    }

    public Bound end() {
        return this.end;
    }

    public Bound open(boolean reversed) {
        return reversed ? this.end : this.start;
    }

    public Bound close(boolean reversed) {
        return reversed ? this.start : this.end;
    }

    public boolean isEmpty(ClusteringComparator comparator) {
        return Slice.isEmpty(comparator, this.start(), this.end());
    }

    public static boolean isEmpty(ClusteringComparator comparator, Bound start, Bound end) {
        assert (start.isStart() && end.isEnd());
        return comparator.compare(end, start) <= 0;
    }

    public boolean selects(ClusteringComparator comparator, Clustering clustering) {
        return comparator.compare(this.start, (ClusteringPrefix)clustering) <= 0 && comparator.compare((ClusteringPrefix)clustering, this.end) <= 0;
    }

    public boolean includes(ClusteringComparator comparator, Bound bound) {
        return comparator.compare(this.start, bound) <= 0 && comparator.compare(bound, this.end) <= 0;
    }

    public Slice forPaging(ClusteringComparator comparator, Clustering lastReturned, boolean inclusive, boolean reversed) {
        if (lastReturned == null) {
            return this;
        }
        if (reversed) {
            int cmp = comparator.compare((ClusteringPrefix)lastReturned, this.start);
            if (cmp < 0 || !inclusive && cmp == 0) {
                return null;
            }
            cmp = comparator.compare(this.end, (ClusteringPrefix)lastReturned);
            if (cmp < 0 || inclusive && cmp == 0) {
                return this;
            }
            ByteBuffer[] values = Slice.extractValues(lastReturned);
            return new Slice(this.start, inclusive ? Bound.inclusiveEndOf(values) : Bound.exclusiveEndOf(values));
        }
        int cmp = comparator.compare(this.end, (ClusteringPrefix)lastReturned);
        if (cmp < 0 || !inclusive && cmp == 0) {
            return null;
        }
        cmp = comparator.compare((ClusteringPrefix)lastReturned, this.start);
        if (cmp < 0 || inclusive && cmp == 0) {
            return this;
        }
        ByteBuffer[] values = Slice.extractValues(lastReturned);
        return new Slice(inclusive ? Bound.inclusiveStartOf(values) : Bound.exclusiveStartOf(values), this.end);
    }

    public boolean intersects(ClusteringComparator comparator, List<ByteBuffer> minClusteringValues, List<ByteBuffer> maxClusteringValues) {
        return this.start.compareTo(comparator, maxClusteringValues) <= 0 && this.end.compareTo(comparator, minClusteringValues) >= 0;
    }

    public String toString(CFMetaData metadata) {
        return this.toString(metadata.comparator);
    }

    public String toString(ClusteringComparator comparator) {
        int i;
        StringBuilder sb = new StringBuilder();
        sb.append(this.start.isInclusive() ? "[" : "(");
        for (i = 0; i < this.start.size(); ++i) {
            if (i > 0) {
                sb.append(':');
            }
            sb.append(comparator.subtype(i).getString(this.start.get(i)));
        }
        sb.append(", ");
        for (i = 0; i < this.end.size(); ++i) {
            if (i > 0) {
                sb.append(':');
            }
            sb.append(comparator.subtype(i).getString(this.end.get(i)));
        }
        sb.append(this.end.isInclusive() ? "]" : ")");
        return sb.toString();
    }

    public boolean equals(Object other) {
        if (!(other instanceof Slice)) {
            return false;
        }
        Slice that = (Slice)other;
        return this.start().equals(that.start()) && this.end().equals(that.end());
    }

    public int hashCode() {
        return Objects.hash(this.start(), this.end());
    }

    public static class Bound
    extends AbstractClusteringPrefix {
        public static final Serializer serializer = new Serializer();
        public static final Bound BOTTOM = RangeTombstone.Bound.BOTTOM;
        public static final Bound TOP = RangeTombstone.Bound.TOP;

        protected Bound(ClusteringPrefix.Kind kind, ByteBuffer[] values) {
            super(kind, values);
        }

        public static Bound create(ClusteringPrefix.Kind kind, ByteBuffer[] values) {
            assert (!kind.isBoundary());
            return new Bound(kind, values);
        }

        public static ClusteringPrefix.Kind boundKind(boolean isStart, boolean isInclusive) {
            return isStart ? (isInclusive ? ClusteringPrefix.Kind.INCL_START_BOUND : ClusteringPrefix.Kind.EXCL_START_BOUND) : (isInclusive ? ClusteringPrefix.Kind.INCL_END_BOUND : ClusteringPrefix.Kind.EXCL_END_BOUND);
        }

        public static Bound inclusiveStartOf(ByteBuffer ... values) {
            return Bound.create(ClusteringPrefix.Kind.INCL_START_BOUND, values);
        }

        public static Bound inclusiveEndOf(ByteBuffer ... values) {
            return Bound.create(ClusteringPrefix.Kind.INCL_END_BOUND, values);
        }

        public static Bound exclusiveStartOf(ByteBuffer ... values) {
            return Bound.create(ClusteringPrefix.Kind.EXCL_START_BOUND, values);
        }

        public static Bound exclusiveEndOf(ByteBuffer ... values) {
            return Bound.create(ClusteringPrefix.Kind.EXCL_END_BOUND, values);
        }

        public static Bound inclusiveStartOf(ClusteringPrefix prefix) {
            ByteBuffer[] values = new ByteBuffer[prefix.size()];
            for (int i = 0; i < prefix.size(); ++i) {
                values[i] = prefix.get(i);
            }
            return Bound.inclusiveStartOf(values);
        }

        public static Bound exclusiveStartOf(ClusteringPrefix prefix) {
            ByteBuffer[] values = new ByteBuffer[prefix.size()];
            for (int i = 0; i < prefix.size(); ++i) {
                values[i] = prefix.get(i);
            }
            return Bound.exclusiveStartOf(values);
        }

        public static Bound inclusiveEndOf(ClusteringPrefix prefix) {
            ByteBuffer[] values = new ByteBuffer[prefix.size()];
            for (int i = 0; i < prefix.size(); ++i) {
                values[i] = prefix.get(i);
            }
            return Bound.inclusiveEndOf(values);
        }

        public static Bound create(ClusteringComparator comparator, boolean isStart, boolean isInclusive, Object ... values) {
            CBuilder builder = CBuilder.create(comparator);
            for (Object val : values) {
                if (val instanceof ByteBuffer) {
                    builder.add((ByteBuffer)val);
                    continue;
                }
                builder.add(val);
            }
            return builder.buildBound(isStart, isInclusive);
        }

        public Bound withNewKind(ClusteringPrefix.Kind kind) {
            assert (!kind.isBoundary());
            return new Bound(kind, this.values);
        }

        public boolean isStart() {
            return this.kind().isStart();
        }

        public boolean isEnd() {
            return !this.isStart();
        }

        public boolean isInclusive() {
            return this.kind == ClusteringPrefix.Kind.INCL_START_BOUND || this.kind == ClusteringPrefix.Kind.INCL_END_BOUND;
        }

        public boolean isExclusive() {
            return this.kind == ClusteringPrefix.Kind.EXCL_START_BOUND || this.kind == ClusteringPrefix.Kind.EXCL_END_BOUND;
        }

        public Bound invert() {
            return this.withNewKind(this.kind().invert());
        }

        private int compareTo(ClusteringComparator comparator, List<ByteBuffer> sstableBound) {
            for (int i = 0; i < sstableBound.size(); ++i) {
                if (i >= this.size()) {
                    return this.isStart() ? -1 : 1;
                }
                int cmp = comparator.compareComponent(i, this.get(i), sstableBound.get(i));
                if (cmp == 0) continue;
                return cmp;
            }
            if (this.size() > sstableBound.size()) {
                return this.isStart() ? -1 : 1;
            }
            return this.isInclusive() ? 0 : (this.isStart() ? 1 : -1);
        }

        @Override
        public String toString(CFMetaData metadata) {
            return this.toString(metadata.comparator);
        }

        public String toString(ClusteringComparator comparator) {
            StringBuilder sb = new StringBuilder();
            sb.append((Object)this.kind()).append('(');
            for (int i = 0; i < this.size(); ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append(comparator.subtype(i).getString(this.get(i)));
            }
            return sb.append(')').toString();
        }

        public static class Serializer {
            public void serialize(Bound bound, DataOutputPlus out, int version, List<AbstractType<?>> types) throws IOException {
                out.writeByte(bound.kind().ordinal());
                out.writeShort(bound.size());
                ClusteringPrefix.serializer.serializeValuesWithoutSize(bound, out, version, types);
            }

            public long serializedSize(Bound bound, int version, List<AbstractType<?>> types) {
                return (long)(1 + TypeSizes.sizeof((short)bound.size())) + ClusteringPrefix.serializer.valuesWithoutSizeSerializedSize(bound, version, types);
            }

            public Bound deserialize(DataInputPlus in, int version, List<AbstractType<?>> types) throws IOException {
                ClusteringPrefix.Kind kind = ClusteringPrefix.Kind.values()[in.readByte()];
                return this.deserializeValues(in, kind, version, types);
            }

            public Bound deserializeValues(DataInputPlus in, ClusteringPrefix.Kind kind, int version, List<AbstractType<?>> types) throws IOException {
                int size = in.readUnsignedShort();
                if (size == 0) {
                    return kind.isStart() ? BOTTOM : TOP;
                }
                ByteBuffer[] values = ClusteringPrefix.serializer.deserializeValuesWithoutSize(in, size, version, types);
                return Bound.create(kind, values);
            }
        }
    }

    public static class Serializer {
        public void serialize(Slice slice, DataOutputPlus out, int version, List<AbstractType<?>> types) throws IOException {
            Bound.serializer.serialize(slice.start, out, version, types);
            Bound.serializer.serialize(slice.end, out, version, types);
        }

        public long serializedSize(Slice slice, int version, List<AbstractType<?>> types) {
            return Bound.serializer.serializedSize(slice.start, version, types) + Bound.serializer.serializedSize(slice.end, version, types);
        }

        public Slice deserialize(DataInputPlus in, int version, List<AbstractType<?>> types) throws IOException {
            Bound start = Bound.serializer.deserialize(in, version, types);
            Bound end = Bound.serializer.deserialize(in, version, types);
            return new Slice(start, end);
        }
    }
}

