/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3;

import com.google.common.collect.MapMaker;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.ConcurrentMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.cassandra.cache.IMeasurableMemory;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.ColumnDefinition;
import org.apache.cassandra.cql3.ReservedKeywords;
import org.apache.cassandra.cql3.selection.Selectable;
import org.apache.cassandra.cql3.selection.Selector;
import org.apache.cassandra.cql3.selection.SimpleSelector;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.UTF8Type;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.ObjectSizes;
import org.apache.cassandra.utils.memory.AbstractAllocator;

public class ColumnIdentifier
extends Selectable
implements IMeasurableMemory,
Comparable<ColumnIdentifier> {
    private static final Pattern PATTERN_DOUBLE_QUOTE = Pattern.compile("\"", 16);
    public final ByteBuffer bytes;
    private final String text;
    public final long prefixComparison;
    private final boolean interned;
    private static final Pattern UNQUOTED_IDENTIFIER = Pattern.compile("[a-z][a-z0-9_]*");
    private static final long EMPTY_SIZE = ObjectSizes.measure(new ColumnIdentifier(ByteBufferUtil.EMPTY_BYTE_BUFFER, "", false));
    private static final ConcurrentMap<InternedKey, ColumnIdentifier> internedInstances = new MapMaker().weakValues().makeMap();

    private static long prefixComparison(ByteBuffer bytes) {
        int i;
        long prefix = 0L;
        ByteBuffer read = bytes.duplicate();
        for (i = 0; read.hasRemaining() && i < 8; ++i) {
            prefix <<= 8;
            prefix |= (long)(read.get() & 0xFF);
        }
        prefix <<= (8 - i) * 8;
        return prefix ^= Long.MIN_VALUE;
    }

    public ColumnIdentifier(String rawText, boolean keepCase) {
        this.text = keepCase ? rawText : rawText.toLowerCase(Locale.US);
        this.bytes = ByteBufferUtil.bytes(this.text);
        this.prefixComparison = ColumnIdentifier.prefixComparison(this.bytes);
        this.interned = false;
    }

    public ColumnIdentifier(ByteBuffer bytes, AbstractType<?> type) {
        this(bytes, type.getString(bytes), false);
    }

    public ColumnIdentifier(ByteBuffer bytes, String text) {
        this(bytes, text, false);
    }

    private ColumnIdentifier(ByteBuffer bytes, String text, boolean interned) {
        this.bytes = bytes;
        this.text = text;
        this.interned = interned;
        this.prefixComparison = ColumnIdentifier.prefixComparison(bytes);
    }

    public static ColumnIdentifier getInterned(ByteBuffer bytes, AbstractType<?> type) {
        return ColumnIdentifier.getInterned(type, bytes, type.getString(bytes));
    }

    public static ColumnIdentifier getInterned(String rawText, boolean keepCase) {
        String text = keepCase ? rawText : rawText.toLowerCase(Locale.US);
        ByteBuffer bytes = ByteBufferUtil.bytes(text);
        return ColumnIdentifier.getInterned(UTF8Type.instance, bytes, text);
    }

    public static ColumnIdentifier getInterned(AbstractType<?> type, ByteBuffer bytes, String text) {
        InternedKey key = new InternedKey(type, bytes = ByteBufferUtil.minimalBufferFor(bytes));
        ColumnIdentifier id = (ColumnIdentifier)internedInstances.get(key);
        if (id != null) {
            return id;
        }
        ColumnIdentifier created = new ColumnIdentifier(bytes, text, true);
        ColumnIdentifier previous = internedInstances.putIfAbsent(key, created);
        return previous == null ? created : previous;
    }

    public boolean isInterned() {
        return this.interned;
    }

    public final int hashCode() {
        return this.bytes.hashCode();
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ColumnIdentifier)) {
            return false;
        }
        ColumnIdentifier that = (ColumnIdentifier)o;
        return this.bytes.equals(that.bytes);
    }

    public String toString() {
        return this.text;
    }

    public String toCQLString() {
        return ColumnIdentifier.maybeQuote(this.text);
    }

    @Override
    public long unsharedHeapSize() {
        return EMPTY_SIZE + ObjectSizes.sizeOnHeapOf(this.bytes) + ObjectSizes.sizeOf(this.text);
    }

    public long unsharedHeapSizeExcludingData() {
        return EMPTY_SIZE + ObjectSizes.sizeOnHeapExcludingData(this.bytes) + ObjectSizes.sizeOf(this.text);
    }

    public ColumnIdentifier clone(AbstractAllocator allocator) {
        return this.interned ? this : new ColumnIdentifier(allocator.clone(this.bytes), this.text, false);
    }

    @Override
    public Selector.Factory newSelectorFactory(CFMetaData cfm, List<ColumnDefinition> defs) throws InvalidRequestException {
        ColumnDefinition def = cfm.getColumnDefinition(this);
        if (def == null) {
            throw new InvalidRequestException(String.format("Undefined name %s in selection clause", this));
        }
        return SimpleSelector.newFactory(def, ColumnIdentifier.addAndGetIndex(def, defs));
    }

    @Override
    public int compareTo(ColumnIdentifier that) {
        int c = Long.compare(this.prefixComparison, that.prefixComparison);
        if (c != 0) {
            return c;
        }
        if (this == that) {
            return 0;
        }
        return ByteBufferUtil.compareUnsigned(this.bytes, that.bytes);
    }

    public static String maybeQuote(String text) {
        if (UNQUOTED_IDENTIFIER.matcher(text).matches() && !ReservedKeywords.isReserved(text)) {
            return text;
        }
        return '\"' + PATTERN_DOUBLE_QUOTE.matcher(text).replaceAll(Matcher.quoteReplacement("\"\"")) + '\"';
    }

    public static class ColumnIdentifierValue
    implements Raw {
        private final ColumnIdentifier identifier;

        public ColumnIdentifierValue(ColumnIdentifier identifier) {
            this.identifier = identifier;
        }

        @Override
        public ColumnIdentifier prepare(CFMetaData cfm) {
            return this.identifier;
        }

        @Override
        public boolean processesSelection() {
            return false;
        }

        public final int hashCode() {
            return this.identifier.hashCode();
        }

        public final boolean equals(Object o) {
            if (!(o instanceof ColumnIdentifierValue)) {
                return false;
            }
            ColumnIdentifierValue that = (ColumnIdentifierValue)o;
            return this.identifier.equals(that.identifier);
        }

        public String toString() {
            return this.identifier.toString();
        }

        @Override
        public String toCQLString() {
            return ColumnIdentifier.maybeQuote(this.identifier.text);
        }
    }

    public static class Literal
    implements Raw {
        private final String rawText;
        private final String text;

        public Literal(String rawText, boolean keepCase) {
            this.rawText = rawText;
            this.text = keepCase ? rawText : rawText.toLowerCase(Locale.US);
        }

        @Override
        public ColumnIdentifier prepare(CFMetaData cfm) {
            if (!cfm.isStaticCompactTable()) {
                return ColumnIdentifier.getInterned(this.text, true);
            }
            AbstractType<?> thriftColumnNameType = cfm.thriftColumnNameType();
            if (thriftColumnNameType instanceof UTF8Type) {
                return ColumnIdentifier.getInterned(this.text, true);
            }
            ByteBuffer bufferName = ByteBufferUtil.bytes(this.text);
            for (ColumnDefinition def : cfm.allColumns()) {
                if (!def.name.bytes.equals(bufferName)) continue;
                return def.name;
            }
            return ColumnIdentifier.getInterned(thriftColumnNameType, thriftColumnNameType.fromString(this.rawText), this.text);
        }

        @Override
        public boolean processesSelection() {
            return false;
        }

        public final int hashCode() {
            return this.text.hashCode();
        }

        public final boolean equals(Object o) {
            if (!(o instanceof Literal)) {
                return false;
            }
            Literal that = (Literal)o;
            return this.text.equals(that.text);
        }

        public String toString() {
            return this.text;
        }

        @Override
        public String toCQLString() {
            return ColumnIdentifier.maybeQuote(this.text);
        }
    }

    public static interface Raw
    extends Selectable.Raw {
        @Override
        public ColumnIdentifier prepare(CFMetaData var1);

        public String toCQLString();
    }

    private static final class InternedKey {
        private final AbstractType<?> type;
        private final ByteBuffer bytes;

        InternedKey(AbstractType<?> type, ByteBuffer bytes) {
            this.type = type;
            this.bytes = bytes;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            InternedKey that = (InternedKey)o;
            return this.bytes.equals(that.bytes) && this.type.equals(that.type);
        }

        public int hashCode() {
            return this.bytes.hashCode() + 31 * this.type.hashCode();
        }
    }
}

