/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.rows;

import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.util.Objects;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.db.ClusteringPrefix;
import org.apache.cassandra.db.DeletionTime;
import org.apache.cassandra.db.RangeTombstone;
import org.apache.cassandra.db.Slice;
import org.apache.cassandra.db.rows.AbstractRangeTombstoneMarker;
import org.apache.cassandra.db.rows.RangeTombstoneBoundMarker;
import org.apache.cassandra.utils.memory.AbstractAllocator;

public class RangeTombstoneBoundaryMarker
extends AbstractRangeTombstoneMarker {
    private final DeletionTime endDeletion;
    private final DeletionTime startDeletion;

    public RangeTombstoneBoundaryMarker(RangeTombstone.Bound bound, DeletionTime endDeletion, DeletionTime startDeletion) {
        super(bound);
        assert (bound.isBoundary());
        this.endDeletion = endDeletion;
        this.startDeletion = startDeletion;
    }

    public static RangeTombstoneBoundaryMarker exclusiveCloseInclusiveOpen(boolean reversed, ByteBuffer[] boundValues, DeletionTime closeDeletion, DeletionTime openDeletion) {
        RangeTombstone.Bound bound = RangeTombstone.Bound.exclusiveCloseInclusiveOpen(reversed, boundValues);
        DeletionTime endDeletion = reversed ? openDeletion : closeDeletion;
        DeletionTime startDeletion = reversed ? closeDeletion : openDeletion;
        return new RangeTombstoneBoundaryMarker(bound, endDeletion, startDeletion);
    }

    public static RangeTombstoneBoundaryMarker inclusiveCloseExclusiveOpen(boolean reversed, ByteBuffer[] boundValues, DeletionTime closeDeletion, DeletionTime openDeletion) {
        RangeTombstone.Bound bound = RangeTombstone.Bound.inclusiveCloseExclusiveOpen(reversed, boundValues);
        DeletionTime endDeletion = reversed ? openDeletion : closeDeletion;
        DeletionTime startDeletion = reversed ? closeDeletion : openDeletion;
        return new RangeTombstoneBoundaryMarker(bound, endDeletion, startDeletion);
    }

    public DeletionTime endDeletionTime() {
        return this.endDeletion;
    }

    public DeletionTime startDeletionTime() {
        return this.startDeletion;
    }

    @Override
    public DeletionTime closeDeletionTime(boolean reversed) {
        return reversed ? this.startDeletion : this.endDeletion;
    }

    @Override
    public DeletionTime openDeletionTime(boolean reversed) {
        return reversed ? this.endDeletion : this.startDeletion;
    }

    @Override
    public boolean openIsInclusive(boolean reversed) {
        return this.bound.kind() == ClusteringPrefix.Kind.EXCL_END_INCL_START_BOUNDARY ^ reversed;
    }

    @Override
    public RangeTombstone.Bound openBound(boolean reversed) {
        return this.bound.withNewKind(this.bound.kind().openBoundOfBoundary(reversed));
    }

    @Override
    public RangeTombstone.Bound closeBound(boolean reversed) {
        return this.bound.withNewKind(this.bound.kind().closeBoundOfBoundary(reversed));
    }

    @Override
    public boolean closeIsInclusive(boolean reversed) {
        return this.bound.kind() == ClusteringPrefix.Kind.INCL_END_EXCL_START_BOUNDARY ^ reversed;
    }

    @Override
    public boolean isOpen(boolean reversed) {
        return true;
    }

    @Override
    public boolean isClose(boolean reversed) {
        return true;
    }

    @Override
    public RangeTombstoneBoundaryMarker copy(AbstractAllocator allocator) {
        return new RangeTombstoneBoundaryMarker(this.clustering().copy(allocator), this.endDeletion, this.startDeletion);
    }

    @Override
    public RangeTombstoneBoundaryMarker withNewOpeningDeletionTime(boolean reversed, DeletionTime newDeletionTime) {
        return new RangeTombstoneBoundaryMarker(this.clustering(), reversed ? newDeletionTime : this.endDeletion, reversed ? this.startDeletion : newDeletionTime);
    }

    public static RangeTombstoneBoundaryMarker makeBoundary(boolean reversed, Slice.Bound close, Slice.Bound open, DeletionTime closeDeletion, DeletionTime openDeletion) {
        assert (ClusteringPrefix.Kind.compare(close.kind(), open.kind()) == 0) : "Both bound don't form a boundary";
        boolean isExclusiveClose = close.isExclusive() || close.isInclusive() && open.isInclusive() && openDeletion.supersedes(closeDeletion);
        return isExclusiveClose ? RangeTombstoneBoundaryMarker.exclusiveCloseInclusiveOpen(reversed, close.getRawValues(), closeDeletion, openDeletion) : RangeTombstoneBoundaryMarker.inclusiveCloseExclusiveOpen(reversed, close.getRawValues(), closeDeletion, openDeletion);
    }

    public RangeTombstoneBoundMarker createCorrespondingCloseMarker(boolean reversed) {
        return new RangeTombstoneBoundMarker(this.closeBound(reversed), this.endDeletion);
    }

    public RangeTombstoneBoundMarker createCorrespondingOpenMarker(boolean reversed) {
        return new RangeTombstoneBoundMarker(this.openBound(reversed), this.startDeletion);
    }

    @Override
    public void digest(MessageDigest digest) {
        this.bound.digest(digest);
        this.endDeletion.digest(digest);
        this.startDeletion.digest(digest);
    }

    @Override
    public String toString(CFMetaData metadata) {
        return String.format("Marker %s@%d/%d-%d/%d", this.bound.toString(metadata), this.endDeletion.markedForDeleteAt(), this.endDeletion.localDeletionTime(), this.startDeletion.markedForDeleteAt(), this.startDeletion.localDeletionTime());
    }

    public boolean equals(Object other) {
        if (!(other instanceof RangeTombstoneBoundaryMarker)) {
            return false;
        }
        RangeTombstoneBoundaryMarker that = (RangeTombstoneBoundaryMarker)other;
        return this.bound.equals(that.bound) && this.endDeletion.equals(that.endDeletion) && this.startDeletion.equals(that.startDeletion);
    }

    public int hashCode() {
        return Objects.hash(this.bound, this.endDeletion, this.startDeletion);
    }
}

