/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.config;

import java.lang.invoke.LambdaMetafactory;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import org.antlr.runtime.RecognitionException;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.Schema;
import org.apache.cassandra.cql3.CQLFragmentParser;
import org.apache.cassandra.cql3.ColumnIdentifier;
import org.apache.cassandra.cql3.QueryProcessor;
import org.apache.cassandra.cql3.Relation;
import org.apache.cassandra.cql3.WhereClause;
import org.apache.cassandra.cql3.statements.SelectStatement;
import org.apache.cassandra.db.view.View;
import org.apache.cassandra.exceptions.SyntaxException;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;

public class ViewDefinition {
    public final String ksName;
    public final String viewName;
    public final UUID baseTableId;
    public final String baseTableName;
    public final boolean includeAllColumns;
    public final CFMetaData metadata;
    public SelectStatement.RawStatement select;
    public String whereClause;

    public ViewDefinition(ViewDefinition def) {
        this(def.ksName, def.viewName, def.baseTableId, def.baseTableName, def.includeAllColumns, def.select, def.whereClause, def.metadata);
    }

    public ViewDefinition(String ksName, String viewName, UUID baseTableId, String baseTableName, boolean includeAllColumns, SelectStatement.RawStatement select, String whereClause, CFMetaData metadata) {
        this.ksName = ksName;
        this.viewName = viewName;
        this.baseTableId = baseTableId;
        this.baseTableName = baseTableName;
        this.includeAllColumns = includeAllColumns;
        this.select = select;
        this.whereClause = whereClause;
        this.metadata = metadata;
    }

    public boolean includes(ColumnIdentifier column) {
        return this.metadata.getColumnDefinition(column) != null;
    }

    public ViewDefinition copy() {
        return new ViewDefinition(this.ksName, this.viewName, this.baseTableId, this.baseTableName, this.includeAllColumns, this.select, this.whereClause, this.metadata.copy());
    }

    public CFMetaData baseTableMetadata() {
        return Schema.instance.getCFMetaData(this.baseTableId);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ViewDefinition)) {
            return false;
        }
        ViewDefinition other = (ViewDefinition)o;
        return Objects.equals(this.ksName, other.ksName) && Objects.equals(this.viewName, other.viewName) && Objects.equals(this.baseTableId, other.baseTableId) && Objects.equals(this.includeAllColumns, other.includeAllColumns) && Objects.equals(this.whereClause, other.whereClause) && Objects.equals(this.metadata, other.metadata);
    }

    public int hashCode() {
        return new HashCodeBuilder(29, 1597).append((Object)this.ksName).append((Object)this.viewName).append((Object)this.baseTableId).append(this.includeAllColumns).append((Object)this.whereClause).append((Object)this.metadata).toHashCode();
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("ksName", (Object)this.ksName).append("viewName", (Object)this.viewName).append("baseTableId", (Object)this.baseTableId).append("baseTableName", (Object)this.baseTableName).append("includeAllColumns", this.includeAllColumns).append("whereClause", (Object)this.whereClause).append("metadata", (Object)this.metadata).toString();
    }

    public void renameColumn(ColumnIdentifier from, ColumnIdentifier to) {
        this.metadata.renameColumn(from, to);
        List<Relation> relations = ViewDefinition.whereClauseToRelations(this.whereClause);
        ColumnIdentifier.Literal fromRaw = new ColumnIdentifier.Literal(from.toString(), true);
        ColumnIdentifier.Literal toRaw = new ColumnIdentifier.Literal(to.toString(), true);
        List<Relation> newRelations = relations.stream().map(r -> r.renameIdentifier(fromRaw, toRaw)).collect(Collectors.toList());
        this.whereClause = View.relationsToWhereClause(newRelations);
        String rawSelect = View.buildSelectStatement(this.baseTableName, this.metadata.allColumns(), this.whereClause);
        this.select = (SelectStatement.RawStatement)QueryProcessor.parseStatement(rawSelect);
    }

    private static List<Relation> whereClauseToRelations(String whereClause) {
        try {
            List<Relation> relations = CQLFragmentParser.parseAnyUnhandled((CQLFragmentParser.CQLParserFunction<WhereClause.Builder>)LambdaMetafactory.metafactory(null, null, null, (Lorg/apache/cassandra/cql3/CqlParser;)Ljava/lang/Object;, whereClause(), (Lorg/apache/cassandra/cql3/CqlParser;)Lorg/apache/cassandra/cql3/WhereClause$Builder;)(), (String)whereClause).build().relations;
            return relations;
        }
        catch (RecognitionException | SyntaxException exc) {
            throw new RuntimeException("Unexpected error parsing materialized view's where clause while handling column rename: ", exc);
        }
    }
}

