/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.partitions;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.ColumnDefinition;
import org.apache.cassandra.db.Clusterable;
import org.apache.cassandra.db.Clustering;
import org.apache.cassandra.db.Columns;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.DeletionTime;
import org.apache.cassandra.db.LegacyLayout;
import org.apache.cassandra.db.MutableDeletionInfo;
import org.apache.cassandra.db.PartitionColumns;
import org.apache.cassandra.db.RangeTombstone;
import org.apache.cassandra.db.filter.ColumnFilter;
import org.apache.cassandra.db.partitions.AbstractBTreePartition;
import org.apache.cassandra.db.rows.BTreeRow;
import org.apache.cassandra.db.rows.Cell;
import org.apache.cassandra.db.rows.CellPath;
import org.apache.cassandra.db.rows.ColumnData;
import org.apache.cassandra.db.rows.ComplexColumnData;
import org.apache.cassandra.db.rows.EncodingStats;
import org.apache.cassandra.db.rows.RangeTombstoneMarker;
import org.apache.cassandra.db.rows.Row;
import org.apache.cassandra.db.rows.RowIterator;
import org.apache.cassandra.db.rows.Rows;
import org.apache.cassandra.db.rows.SerializationHelper;
import org.apache.cassandra.db.rows.SliceableUnfilteredRowIterator;
import org.apache.cassandra.db.rows.Unfiltered;
import org.apache.cassandra.db.rows.UnfilteredRowIterator;
import org.apache.cassandra.db.rows.UnfilteredRowIteratorSerializer;
import org.apache.cassandra.db.rows.UnfilteredRowIterators;
import org.apache.cassandra.io.util.DataInputBuffer;
import org.apache.cassandra.io.util.DataInputPlus;
import org.apache.cassandra.io.util.DataOutputBuffer;
import org.apache.cassandra.io.util.DataOutputPlus;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.btree.BTree;
import org.apache.cassandra.utils.btree.UpdateFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PartitionUpdate
extends AbstractBTreePartition {
    protected static final Logger logger = LoggerFactory.getLogger(PartitionUpdate.class);
    public static final PartitionUpdateSerializer serializer = new PartitionUpdateSerializer();
    private final int createdAtInSec = FBUtilities.nowInSeconds();
    private boolean isBuilt;
    private boolean canReOpen = true;
    private AbstractBTreePartition.Holder holder;
    private BTree.Builder<Row> rowBuilder;
    private MutableDeletionInfo deletionInfo;
    private final boolean canHaveShadowedData;

    private PartitionUpdate(CFMetaData metadata, DecoratedKey key, PartitionColumns columns, MutableDeletionInfo deletionInfo, int initialRowCapacity, boolean canHaveShadowedData) {
        super(metadata, key);
        this.deletionInfo = deletionInfo;
        this.holder = new AbstractBTreePartition.Holder(columns, BTree.empty(), deletionInfo, Rows.EMPTY_STATIC_ROW, EncodingStats.NO_STATS);
        this.canHaveShadowedData = canHaveShadowedData;
        this.rowBuilder = this.builder(initialRowCapacity);
    }

    private PartitionUpdate(CFMetaData metadata, DecoratedKey key, AbstractBTreePartition.Holder holder, MutableDeletionInfo deletionInfo, boolean canHaveShadowedData) {
        super(metadata, key);
        this.holder = holder;
        this.deletionInfo = deletionInfo;
        this.isBuilt = true;
        this.canHaveShadowedData = canHaveShadowedData;
    }

    public PartitionUpdate(CFMetaData metadata, DecoratedKey key, PartitionColumns columns, int initialRowCapacity) {
        this(metadata, key, columns, MutableDeletionInfo.live(), initialRowCapacity, true);
    }

    public PartitionUpdate(CFMetaData metadata, ByteBuffer key, PartitionColumns columns, int initialRowCapacity) {
        this(metadata, metadata.decorateKey(key), columns, initialRowCapacity);
    }

    public static PartitionUpdate emptyUpdate(CFMetaData metadata, DecoratedKey key) {
        MutableDeletionInfo deletionInfo = MutableDeletionInfo.live();
        AbstractBTreePartition.Holder holder = new AbstractBTreePartition.Holder(PartitionColumns.NONE, BTree.empty(), deletionInfo, Rows.EMPTY_STATIC_ROW, EncodingStats.NO_STATS);
        return new PartitionUpdate(metadata, key, holder, deletionInfo, false);
    }

    public static PartitionUpdate fullPartitionDelete(CFMetaData metadata, DecoratedKey key, long timestamp, int nowInSec) {
        MutableDeletionInfo deletionInfo = new MutableDeletionInfo(timestamp, nowInSec);
        AbstractBTreePartition.Holder holder = new AbstractBTreePartition.Holder(PartitionColumns.NONE, BTree.empty(), deletionInfo, Rows.EMPTY_STATIC_ROW, EncodingStats.NO_STATS);
        return new PartitionUpdate(metadata, key, holder, deletionInfo, false);
    }

    public static PartitionUpdate singleRowUpdate(CFMetaData metadata, DecoratedKey key, Row row) {
        MutableDeletionInfo deletionInfo = MutableDeletionInfo.live();
        if (row.isStatic()) {
            AbstractBTreePartition.Holder holder = new AbstractBTreePartition.Holder(new PartitionColumns(Columns.from(row.columns()), Columns.NONE), BTree.empty(), deletionInfo, row, EncodingStats.NO_STATS);
            return new PartitionUpdate(metadata, key, holder, deletionInfo, false);
        }
        AbstractBTreePartition.Holder holder = new AbstractBTreePartition.Holder(new PartitionColumns(Columns.NONE, Columns.from(row.columns())), BTree.singleton(row), deletionInfo, Rows.EMPTY_STATIC_ROW, EncodingStats.NO_STATS);
        return new PartitionUpdate(metadata, key, holder, deletionInfo, false);
    }

    public static PartitionUpdate singleRowUpdate(CFMetaData metadata, ByteBuffer key, Row row) {
        return PartitionUpdate.singleRowUpdate(metadata, metadata.decorateKey(key), row);
    }

    public static PartitionUpdate fromIterator(UnfilteredRowIterator iterator) {
        AbstractBTreePartition.Holder holder = PartitionUpdate.build(iterator, 16);
        MutableDeletionInfo deletionInfo = (MutableDeletionInfo)holder.deletionInfo;
        return new PartitionUpdate(iterator.metadata(), iterator.partitionKey(), holder, deletionInfo, false);
    }

    public static PartitionUpdate fromIterator(RowIterator iterator) {
        MutableDeletionInfo deletionInfo = MutableDeletionInfo.live();
        AbstractBTreePartition.Holder holder = PartitionUpdate.build(iterator, deletionInfo, true, 16);
        return new PartitionUpdate(iterator.metadata(), iterator.partitionKey(), holder, deletionInfo, false);
    }

    @Override
    protected boolean canHaveShadowedData() {
        return this.canHaveShadowedData;
    }

    public static PartitionUpdate fromBytes(ByteBuffer bytes, int version, DecoratedKey key) {
        if (bytes == null) {
            return null;
        }
        try {
            return serializer.deserialize((DataInputPlus)new DataInputBuffer(bytes, true), version, SerializationHelper.Flag.LOCAL, version < 10 ? key : null);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ByteBuffer toBytes(PartitionUpdate update, int version) {
        try (DataOutputBuffer out = new DataOutputBuffer();){
            serializer.serialize(update, out, version);
            ByteBuffer byteBuffer = ByteBuffer.wrap(out.getData(), 0, out.getLength());
            return byteBuffer;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static PartitionUpdate fullPartitionDelete(CFMetaData metadata, ByteBuffer key, long timestamp, int nowInSec) {
        return PartitionUpdate.fullPartitionDelete(metadata, metadata.decorateKey(key), timestamp, nowInSec);
    }

    public static PartitionUpdate merge(List<PartitionUpdate> updates) {
        assert (!updates.isEmpty());
        int size = updates.size();
        if (size == 1) {
            return (PartitionUpdate)Iterables.getOnlyElement(updates);
        }
        int nowInSecs = FBUtilities.nowInSeconds();
        List asIterators = Lists.transform(updates, AbstractBTreePartition::unfilteredIterator);
        return PartitionUpdate.fromIterator(UnfilteredRowIterators.merge(asIterators, nowInSecs));
    }

    public void updateAllTimestamp(long newTimestamp) {
        AbstractBTreePartition.Holder holder = this.holder();
        this.deletionInfo.updateAllTimestamp(newTimestamp - 1L);
        Object[] tree = BTree.transformAndFilter(holder.tree, x -> x.updateAllTimestamp(newTimestamp));
        Row staticRow = holder.staticRow.updateAllTimestamp(newTimestamp);
        EncodingStats newStats = EncodingStats.Collector.collect(staticRow, BTree.iterator(tree), this.deletionInfo);
        this.holder = new AbstractBTreePartition.Holder(holder.columns, tree, this.deletionInfo, staticRow, newStats);
    }

    public int operationCount() {
        return this.rowCount() + (this.staticRow().isEmpty() ? 0 : 1) + this.deletionInfo.rangeCount() + (this.deletionInfo.getPartitionDeletion().isLive() ? 0 : 1);
    }

    public int dataSize() {
        int size = 0;
        for (Row row : this) {
            size += row.clustering().dataSize();
            for (ColumnData cd : row) {
                size += cd.dataSize();
            }
        }
        return size;
    }

    @Override
    public PartitionColumns columns() {
        return this.holder.columns;
    }

    @Override
    protected AbstractBTreePartition.Holder holder() {
        this.maybeBuild();
        return this.holder;
    }

    @Override
    public EncodingStats stats() {
        return this.holder().stats;
    }

    public synchronized void allowNewUpdates() {
        if (!this.canReOpen) {
            throw new IllegalStateException("You cannot do more updates on collectCounterMarks has been called");
        }
        this.isBuilt = false;
        if (this.rowBuilder == null) {
            this.rowBuilder = this.builder(16);
        }
    }

    private BTree.Builder<Row> builder(int initialCapacity) {
        return BTree.builder(this.metadata.comparator, initialCapacity).setQuickResolver((a, b) -> Rows.merge(a, b, this.createdAtInSec));
    }

    @Override
    public Iterator<Row> iterator() {
        this.maybeBuild();
        return super.iterator();
    }

    @Override
    public SliceableUnfilteredRowIterator sliceableUnfilteredIterator(ColumnFilter columns, boolean reversed) {
        this.maybeBuild();
        return super.sliceableUnfilteredIterator(columns, reversed);
    }

    public void validate() {
        for (Row row : this) {
            this.metadata().comparator.validate(row.clustering());
            for (ColumnData cd : row) {
                cd.validate();
            }
        }
    }

    public long maxTimestamp() {
        this.maybeBuild();
        long maxTimestamp = this.deletionInfo.maxTimestamp();
        for (Row row : this) {
            maxTimestamp = Math.max(maxTimestamp, row.primaryKeyLivenessInfo().timestamp());
            for (ColumnData cd : row) {
                if (cd.column().isSimple()) {
                    maxTimestamp = Math.max(maxTimestamp, ((Cell)cd).timestamp());
                    continue;
                }
                ComplexColumnData complexData = (ComplexColumnData)cd;
                maxTimestamp = Math.max(maxTimestamp, complexData.complexDeletion().markedForDeleteAt());
                for (Cell cell : complexData) {
                    maxTimestamp = Math.max(maxTimestamp, cell.timestamp());
                }
            }
        }
        return maxTimestamp;
    }

    public List<CounterMark> collectCounterMarks() {
        assert (this.metadata().isCounter());
        this.maybeBuild();
        this.canReOpen = false;
        ArrayList<CounterMark> marks = new ArrayList<CounterMark>();
        this.addMarksForRow(this.staticRow(), marks);
        for (Row row : this) {
            this.addMarksForRow(row, marks);
        }
        return marks;
    }

    private void addMarksForRow(Row row, List<CounterMark> marks) {
        for (Cell cell : row.cells()) {
            if (!cell.isCounterCell()) continue;
            marks.add(new CounterMark(row, cell.column(), cell.path()));
        }
    }

    private void assertNotBuilt() {
        if (this.isBuilt) {
            throw new IllegalStateException("An update should not be written again once it has been read");
        }
    }

    public void addPartitionDeletion(DeletionTime deletionTime) {
        this.assertNotBuilt();
        this.deletionInfo.add(deletionTime);
    }

    public void add(RangeTombstone range) {
        this.assertNotBuilt();
        this.deletionInfo.add(range, this.metadata.comparator);
    }

    public void add(Row row) {
        if (row.isEmpty()) {
            return;
        }
        this.assertNotBuilt();
        if (row.isStatic()) {
            assert (this.columns().statics.containsAll(row.columns())) : this.columns().statics + " is not superset of " + row.columns();
            Row staticRow = this.holder.staticRow.isEmpty() ? row : Rows.merge(this.holder.staticRow, row, this.createdAtInSec);
            this.holder = new AbstractBTreePartition.Holder(this.holder.columns, this.holder.tree, this.holder.deletionInfo, staticRow, this.holder.stats);
        } else {
            assert (this.columns().regulars.containsAll(row.columns())) : this.columns().regulars + " is not superset of " + row.columns();
            this.rowBuilder.add(row);
        }
    }

    private void maybeBuild() {
        if (this.isBuilt) {
            return;
        }
        this.build();
    }

    private synchronized void build() {
        if (this.isBuilt) {
            return;
        }
        AbstractBTreePartition.Holder holder = this.holder;
        Object[] cur = holder.tree;
        Object[] add = this.rowBuilder.build();
        Object[] merged = BTree.merge(cur, add, this.metadata.comparator, UpdateFunction.Simple.of((a, b) -> Rows.merge(a, b, this.createdAtInSec)));
        assert (this.deletionInfo == holder.deletionInfo);
        EncodingStats newStats = EncodingStats.Collector.collect(holder.staticRow, BTree.iterator(merged), this.deletionInfo);
        this.holder = new AbstractBTreePartition.Holder(holder.columns, merged, holder.deletionInfo, holder.staticRow, newStats);
        this.rowBuilder = null;
        this.isBuilt = true;
    }

    @Override
    public String toString() {
        if (this.isBuilt) {
            return super.toString();
        }
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("[%s.%s] key=%s columns=%s", this.metadata.ksName, this.metadata.cfName, this.metadata.getKeyValidator().getString(this.partitionKey().getKey()), this.columns()));
        sb.append("\n    deletionInfo=").append(this.deletionInfo);
        sb.append(" (not built)");
        return sb.toString();
    }

    public static class CounterMark {
        private final Row row;
        private final ColumnDefinition column;
        private final CellPath path;

        private CounterMark(Row row, ColumnDefinition column, CellPath path) {
            this.row = row;
            this.column = column;
            this.path = path;
        }

        public Clustering clustering() {
            return this.row.clustering();
        }

        public ColumnDefinition column() {
            return this.column;
        }

        public CellPath path() {
            return this.path;
        }

        public ByteBuffer value() {
            return this.path == null ? this.row.getCell(this.column).value() : this.row.getCell(this.column, this.path).value();
        }

        public void setValue(ByteBuffer value) {
            assert (this.row instanceof BTreeRow);
            ((BTreeRow)this.row).setValue(this.column, this.path, value);
        }
    }

    public static class PartitionUpdateSerializer {
        public void serialize(PartitionUpdate update, DataOutputPlus out, int version) throws IOException {
            try (SliceableUnfilteredRowIterator iter = update.sliceableUnfilteredIterator();){
                assert (!iter.isReverseOrder());
                if (version < 10) {
                    LegacyLayout.serializeAsLegacyPartition(null, iter, out, version);
                } else {
                    CFMetaData.serializer.serialize(update.metadata(), out, version);
                    UnfilteredRowIteratorSerializer.serializer.serialize(iter, null, out, version, update.rowCount());
                }
            }
        }

        public PartitionUpdate deserialize(DataInputPlus in, int version, SerializationHelper.Flag flag, ByteBuffer key) throws IOException {
            if (version >= 10) {
                assert (key == null);
                return PartitionUpdateSerializer.deserialize30(in, version, flag);
            }
            assert (key != null);
            return PartitionUpdateSerializer.deserializePre30(in, version, flag, key);
        }

        public PartitionUpdate deserialize(DataInputPlus in, int version, SerializationHelper.Flag flag, DecoratedKey key) throws IOException {
            if (version >= 10) {
                return PartitionUpdateSerializer.deserialize30(in, version, flag);
            }
            assert (key != null);
            return PartitionUpdateSerializer.deserializePre30(in, version, flag, key.getKey());
        }

        private static PartitionUpdate deserialize30(DataInputPlus in, int version, SerializationHelper.Flag flag) throws IOException {
            CFMetaData metadata = CFMetaData.serializer.deserialize(in, version);
            UnfilteredRowIteratorSerializer.Header header = UnfilteredRowIteratorSerializer.serializer.deserializeHeader(metadata, null, in, version, flag);
            if (header.isEmpty) {
                return PartitionUpdate.emptyUpdate(metadata, header.key);
            }
            assert (!header.isReversed);
            assert (header.rowEstimate >= 0);
            MutableDeletionInfo.Builder deletionBuilder = MutableDeletionInfo.builder(header.partitionDeletion, metadata.comparator, false);
            BTree.Builder<Clusterable> rows = BTree.builder(metadata.comparator, header.rowEstimate);
            rows.auto(false);
            try (UnfilteredRowIterator partition = UnfilteredRowIteratorSerializer.serializer.deserialize(in, version, metadata, flag, header);){
                while (partition.hasNext()) {
                    Unfiltered unfiltered = (Unfiltered)partition.next();
                    if (unfiltered.kind() == Unfiltered.Kind.ROW) {
                        rows.add((Row)unfiltered);
                        continue;
                    }
                    deletionBuilder.add((RangeTombstoneMarker)unfiltered);
                }
            }
            MutableDeletionInfo deletionInfo = deletionBuilder.build();
            return new PartitionUpdate(metadata, header.key, new AbstractBTreePartition.Holder(header.sHeader.columns(), rows.build(), deletionInfo, header.staticRow, header.sHeader.stats()), deletionInfo, false);
        }

        private static PartitionUpdate deserializePre30(DataInputPlus in, int version, SerializationHelper.Flag flag, ByteBuffer key) throws IOException {
            try (UnfilteredRowIterator iterator = LegacyLayout.deserializeLegacyPartition(in, version, flag, key);){
                assert (iterator != null);
                PartitionUpdate partitionUpdate = PartitionUpdate.fromIterator(iterator);
                return partitionUpdate;
            }
        }

        public long serializedSize(PartitionUpdate update, int version) {
            try (SliceableUnfilteredRowIterator iter = update.sliceableUnfilteredIterator();){
                if (version < 10) {
                    long l = LegacyLayout.serializedSizeAsLegacyPartition(null, iter, version);
                    return l;
                }
                long l = CFMetaData.serializer.serializedSize(update.metadata(), version) + UnfilteredRowIteratorSerializer.serializer.serializedSize(iter, null, version, update.rowCount());
                return l;
            }
        }
    }
}

