/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.lifecycle;

import java.io.File;
import org.apache.cassandra.db.lifecycle.LogRecord;
import org.apache.cassandra.db.lifecycle.LogTransaction;
import org.apache.cassandra.io.util.FileUtils;
import org.apache.cassandra.utils.NativeLibrary;

final class LogReplica
implements AutoCloseable {
    private final File file;
    private int folderDescriptor;

    static LogReplica create(File folder, String fileName) {
        return new LogReplica(new File(fileName), NativeLibrary.tryOpenDirectory(folder.getPath()));
    }

    static LogReplica open(File file) {
        return new LogReplica(file, NativeLibrary.tryOpenDirectory(file.getParentFile().getPath()));
    }

    LogReplica(File file, int folderDescriptor) {
        this.file = file;
        this.folderDescriptor = folderDescriptor;
    }

    File file() {
        return this.file;
    }

    void append(LogRecord record) {
        boolean existed = this.exists();
        FileUtils.appendAndSync(this.file, record.toString());
        if (!existed) {
            this.syncFolder();
        }
    }

    void syncFolder() {
        if (this.folderDescriptor >= 0) {
            NativeLibrary.trySync(this.folderDescriptor);
        }
    }

    void delete() {
        LogTransaction.delete(this.file);
        this.syncFolder();
    }

    boolean exists() {
        return this.file.exists();
    }

    @Override
    public void close() {
        if (this.folderDescriptor >= 0) {
            NativeLibrary.tryCloseFD(this.folderDescriptor);
            this.folderDescriptor = -1;
        }
    }

    public String toString() {
        return String.format("[%s] ", this.file);
    }
}

