/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.columniterator;

import java.io.IOException;
import java.util.NoSuchElementException;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.RowIndexEntry;
import org.apache.cassandra.db.Slice;
import org.apache.cassandra.db.columniterator.AbstractSSTableIterator;
import org.apache.cassandra.db.filter.ColumnFilter;
import org.apache.cassandra.db.rows.RangeTombstoneBoundMarker;
import org.apache.cassandra.db.rows.RangeTombstoneMarker;
import org.apache.cassandra.db.rows.Unfiltered;
import org.apache.cassandra.io.sstable.format.SSTableReader;
import org.apache.cassandra.io.util.FileDataInput;

public class SSTableIterator
extends AbstractSSTableIterator {
    public SSTableIterator(SSTableReader sstable, DecoratedKey key, ColumnFilter columns, boolean isForThrift) {
        this(sstable, null, key, sstable.getPosition(key, SSTableReader.Operator.EQ), columns, isForThrift);
    }

    public SSTableIterator(SSTableReader sstable, FileDataInput file, DecoratedKey key, RowIndexEntry indexEntry, ColumnFilter columns, boolean isForThrift) {
        super(sstable, file, key, indexEntry, columns, isForThrift);
    }

    @Override
    protected AbstractSSTableIterator.Reader createReader(RowIndexEntry indexEntry, FileDataInput file, boolean shouldCloseFile) {
        return indexEntry.isIndexed() ? new ForwardIndexedReader(indexEntry, file, shouldCloseFile) : new ForwardReader(file, shouldCloseFile);
    }

    @Override
    public boolean isReverseOrder() {
        return false;
    }

    private class ForwardIndexedReader
    extends ForwardReader {
        private final AbstractSSTableIterator.IndexState indexState;
        private int lastBlockIdx;

        private ForwardIndexedReader(RowIndexEntry indexEntry, FileDataInput file, boolean shouldCloseFile) {
            super(file, shouldCloseFile);
            this.indexState = new AbstractSSTableIterator.IndexState(this, SSTableIterator.this.sstable.metadata.comparator, indexEntry, false);
            this.lastBlockIdx = this.indexState.blocksCount();
        }

        @Override
        public void setForSlice(Slice slice) throws IOException {
            super.setForSlice(slice);
            if (this.indexState.isDone()) {
                this.sliceDone = true;
                return;
            }
            int startIdx = this.indexState.findBlockIndex(slice.start(), this.indexState.currentBlockIdx());
            if (startIdx >= this.indexState.blocksCount()) {
                this.sliceDone = true;
                return;
            }
            this.lastBlockIdx = this.indexState.findBlockIndex(slice.end(), startIdx);
            if (this.lastBlockIdx < 0) {
                assert (startIdx < 0);
                this.sliceDone = true;
                return;
            }
            if (startIdx < 0) {
                startIdx = 0;
            }
            if (startIdx != this.indexState.currentBlockIdx()) {
                this.indexState.setToBlock(startIdx);
            }
            if (this.indexState.currentBlockIdx() == this.lastBlockIdx && SSTableIterator.this.metadata().comparator.compare(slice.end(), this.indexState.currentIndex().firstName) < 0 && this.openMarker == null && SSTableIterator.this.sstable.descriptor.version.storeRows()) {
                this.sliceDone = true;
            }
        }

        @Override
        protected Unfiltered computeNext() throws IOException {
            Unfiltered next;
            do {
                this.indexState.updateBlock();
                if (!this.indexState.isDone() && this.indexState.currentBlockIdx() <= this.lastBlockIdx && this.deserializer.hasNext() && (this.indexState.currentBlockIdx() != this.lastBlockIdx || this.deserializer.compareNextTo(this.end) < 0)) continue;
                return null;
            } while ((next = this.deserializer.readNext()).isEmpty());
            if (next.kind() == Unfiltered.Kind.RANGE_TOMBSTONE_MARKER) {
                this.updateOpenMarker((RangeTombstoneMarker)next);
            }
            return next;
        }
    }

    private class ForwardReader
    extends AbstractSSTableIterator.Reader {
        protected Slice.Bound start;
        protected Slice.Bound end;
        protected Unfiltered next;
        protected boolean sliceDone;

        private ForwardReader(FileDataInput file, boolean shouldCloseFile) {
            super(file, shouldCloseFile);
            this.end = Slice.Bound.TOP;
        }

        @Override
        public void setForSlice(Slice slice) throws IOException {
            this.start = slice.start() == Slice.Bound.BOTTOM ? null : slice.start();
            this.end = slice.end();
            this.sliceDone = false;
            this.next = null;
        }

        private Unfiltered handlePreSliceData() throws IOException {
            assert (this.deserializer != null);
            while (this.deserializer.hasNext() && this.deserializer.compareNextTo(this.start) <= 0) {
                if (this.deserializer.nextIsRow()) {
                    this.deserializer.skipNext();
                    continue;
                }
                this.updateOpenMarker((RangeTombstoneMarker)this.deserializer.readNext());
            }
            Slice.Bound sliceStart = this.start;
            this.start = null;
            if (this.openMarker != null) {
                return new RangeTombstoneBoundMarker(sliceStart, this.openMarker);
            }
            return null;
        }

        protected Unfiltered computeNext() throws IOException {
            Unfiltered next;
            assert (this.deserializer != null);
            do {
                if (this.deserializer.hasNext() && this.deserializer.compareNextTo(this.end) < 0) continue;
                return null;
            } while ((next = this.deserializer.readNext()).isEmpty());
            if (next.kind() == Unfiltered.Kind.RANGE_TOMBSTONE_MARKER) {
                this.updateOpenMarker((RangeTombstoneMarker)next);
            }
            return next;
        }

        @Override
        protected boolean hasNextInternal() throws IOException {
            Unfiltered unfiltered;
            if (this.next != null) {
                return true;
            }
            if (this.sliceDone) {
                return false;
            }
            if (this.start != null && (unfiltered = this.handlePreSliceData()) != null) {
                this.next = unfiltered;
                return true;
            }
            this.next = this.computeNext();
            if (this.next != null) {
                return true;
            }
            if (this.openMarker != null) {
                this.next = new RangeTombstoneBoundMarker(this.end, this.getAndClearOpenMarker());
                return true;
            }
            this.sliceDone = true;
            return false;
        }

        @Override
        protected Unfiltered nextInternal() throws IOException {
            if (!this.hasNextInternal()) {
                throw new NoSuchElementException();
            }
            Unfiltered toReturn = this.next;
            this.next = null;
            return toReturn;
        }
    }
}

