/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.repair;

import com.google.common.util.concurrent.AbstractFuture;
import java.io.IOException;
import java.net.InetAddress;
import java.util.Collection;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.SystemKeyspace;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.gms.ApplicationState;
import org.apache.cassandra.gms.EndpointState;
import org.apache.cassandra.gms.FailureDetector;
import org.apache.cassandra.gms.IEndpointStateChangeSubscriber;
import org.apache.cassandra.gms.IFailureDetectionEventListener;
import org.apache.cassandra.gms.VersionedValue;
import org.apache.cassandra.net.IAsyncCallbackWithFailure;
import org.apache.cassandra.net.MessageIn;
import org.apache.cassandra.net.MessagingService;
import org.apache.cassandra.repair.RepairSession;
import org.apache.cassandra.repair.messages.AnticompactionRequest;
import org.apache.cassandra.utils.CassandraVersion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnticompactionTask
extends AbstractFuture<InetAddress>
implements Runnable,
IEndpointStateChangeSubscriber,
IFailureDetectionEventListener {
    private static final CassandraVersion VERSION_CHECKER = new CassandraVersion("2.1.5");
    private static Logger logger = LoggerFactory.getLogger(RepairSession.class);
    private final UUID parentSession;
    private final InetAddress neighbor;
    private final Collection<Range<Token>> successfulRanges;
    private final AtomicBoolean isFinished = new AtomicBoolean(false);

    public AnticompactionTask(UUID parentSession, InetAddress neighbor, Collection<Range<Token>> successfulRanges) {
        this.parentSession = parentSession;
        this.neighbor = neighbor;
        this.successfulRanges = successfulRanges;
    }

    @Override
    public void run() {
        if (FailureDetector.instance.isAlive(this.neighbor)) {
            AnticompactionRequest acr = new AnticompactionRequest(this.parentSession, this.successfulRanges);
            CassandraVersion peerVersion = SystemKeyspace.getReleaseVersion(this.neighbor);
            if (peerVersion != null && peerVersion.compareTo(VERSION_CHECKER) > 0) {
                MessagingService.instance().sendRR(acr.createMessage(), this.neighbor, new AnticompactionCallback(this), TimeUnit.DAYS.toMillis(1L), true);
            } else {
                MessagingService.instance().sendOneWay(acr.createMessage(), this.neighbor);
                this.maybeSetResult(this.neighbor);
            }
        } else {
            this.maybeSetException(new IOException(this.neighbor + " is down"));
        }
    }

    private boolean maybeSetException(Throwable t) {
        if (this.isFinished.compareAndSet(false, true)) {
            this.setException(t);
            return true;
        }
        return false;
    }

    private boolean maybeSetResult(InetAddress o) {
        if (this.isFinished.compareAndSet(false, true)) {
            this.set(o);
            return true;
        }
        return false;
    }

    @Override
    public void onJoin(InetAddress endpoint, EndpointState epState) {
    }

    @Override
    public void beforeChange(InetAddress endpoint, EndpointState currentState, ApplicationState newStateKey, VersionedValue newValue) {
    }

    @Override
    public void onChange(InetAddress endpoint, ApplicationState state, VersionedValue value) {
    }

    @Override
    public void onAlive(InetAddress endpoint, EndpointState state) {
    }

    @Override
    public void onDead(InetAddress endpoint, EndpointState state) {
    }

    @Override
    public void onRemove(InetAddress endpoint) {
        this.convict(endpoint, Double.MAX_VALUE);
    }

    @Override
    public void onRestart(InetAddress endpoint, EndpointState epState) {
        this.convict(endpoint, Double.MAX_VALUE);
    }

    @Override
    public void convict(InetAddress endpoint, double phi) {
        if (!this.neighbor.equals(endpoint)) {
            return;
        }
        if (phi < 2.0 * DatabaseDescriptor.getPhiConvictThreshold()) {
            return;
        }
        IOException exception = new IOException(String.format("Endpoint %s died during anti-compaction.", endpoint));
        if (this.maybeSetException(exception)) {
            logger.error("[repair #{}] Endpoint {} died during anti-compaction", new Object[]{endpoint, this.parentSession, exception});
        }
    }

    public class AnticompactionCallback
    implements IAsyncCallbackWithFailure {
        final AnticompactionTask task;

        public AnticompactionCallback(AnticompactionTask task) {
            this.task = task;
        }

        @Override
        public void response(MessageIn msg) {
            AnticompactionTask.this.maybeSetResult(msg.from);
        }

        @Override
        public boolean isLatencyForSnitch() {
            return false;
        }

        @Override
        public void onFailure(InetAddress from) {
            AnticompactionTask.this.maybeSetException(new RuntimeException("Anticompaction failed or timed out in " + from));
        }
    }
}

