/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.util;

import com.google.common.util.concurrent.RateLimiter;
import org.apache.cassandra.config.Config;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.io.compress.CompressedRandomAccessReader;
import org.apache.cassandra.io.compress.CompressedSequentialWriter;
import org.apache.cassandra.io.compress.CompressionMetadata;
import org.apache.cassandra.io.util.ChannelProxy;
import org.apache.cassandra.io.util.ICompressedFile;
import org.apache.cassandra.io.util.MmappedRegions;
import org.apache.cassandra.io.util.RandomAccessReader;
import org.apache.cassandra.io.util.SegmentedFile;
import org.apache.cassandra.utils.JVMStabilityInspector;
import org.apache.cassandra.utils.concurrent.Ref;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompressedSegmentedFile
extends SegmentedFile
implements ICompressedFile {
    private static final Logger logger = LoggerFactory.getLogger(CompressedSegmentedFile.class);
    private static final boolean useMmap = DatabaseDescriptor.getDiskAccessMode() == Config.DiskAccessMode.mmap;
    public final CompressionMetadata metadata;
    private final MmappedRegions regions;

    public CompressedSegmentedFile(ChannelProxy channel, int bufferSize, CompressionMetadata metadata) {
        this(channel, bufferSize, metadata, useMmap ? MmappedRegions.map(channel, metadata) : null);
    }

    public CompressedSegmentedFile(ChannelProxy channel, int bufferSize, CompressionMetadata metadata, MmappedRegions regions) {
        super(new Cleanup(channel, metadata, regions), channel, bufferSize, metadata.dataLength, metadata.compressedFileLength);
        this.metadata = metadata;
        this.regions = regions;
    }

    private CompressedSegmentedFile(CompressedSegmentedFile copy) {
        super(copy);
        this.metadata = copy.metadata;
        this.regions = copy.regions;
    }

    @Override
    public ChannelProxy channel() {
        return this.channel;
    }

    @Override
    public MmappedRegions regions() {
        return this.regions;
    }

    @Override
    public CompressedSegmentedFile sharedCopy() {
        return new CompressedSegmentedFile(this);
    }

    @Override
    public void addTo(Ref.IdentityCollection identities) {
        super.addTo(identities);
        this.metadata.addTo(identities);
    }

    @Override
    public void dropPageCache(long before) {
        if (before >= this.metadata.dataLength) {
            super.dropPageCache(0L);
        }
        super.dropPageCache(this.metadata.chunkFor((long)before).offset);
    }

    @Override
    public RandomAccessReader createReader() {
        return new CompressedRandomAccessReader.Builder(this).build();
    }

    @Override
    public RandomAccessReader createReader(RateLimiter limiter) {
        return new CompressedRandomAccessReader.Builder(this).limiter(limiter).build();
    }

    @Override
    public CompressionMetadata getMetadata() {
        return this.metadata;
    }

    public static class Builder
    extends SegmentedFile.Builder {
        final CompressedSequentialWriter writer;

        public Builder(CompressedSequentialWriter writer) {
            this.writer = writer;
        }

        protected CompressionMetadata metadata(String path, long overrideLength) {
            if (this.writer == null) {
                return CompressionMetadata.create(path);
            }
            return this.writer.open(overrideLength);
        }

        @Override
        public SegmentedFile complete(ChannelProxy channel, int bufferSize, long overrideLength) {
            return new CompressedSegmentedFile(channel, bufferSize, this.metadata(channel.filePath(), overrideLength));
        }
    }

    private static final class Cleanup
    extends SegmentedFile.Cleanup {
        final CompressionMetadata metadata;
        private final MmappedRegions regions;

        protected Cleanup(ChannelProxy channel, CompressionMetadata metadata, MmappedRegions regions) {
            super(channel);
            this.metadata = metadata;
            this.regions = regions;
        }

        @Override
        public void tidy() {
            Throwable err;
            Throwable throwable = err = this.regions == null ? null : this.regions.close(null);
            if (err != null) {
                JVMStabilityInspector.inspectThrowable(err);
                logger.error("Error while closing mmapped regions", err);
            }
            this.metadata.close();
            super.tidy();
        }
    }
}

