/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.view;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nullable;
import org.apache.cassandra.concurrent.ScheduledExecutors;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.DeletionTime;
import org.apache.cassandra.db.Mutation;
import org.apache.cassandra.db.ReadOrderGroup;
import org.apache.cassandra.db.ReadQuery;
import org.apache.cassandra.db.SinglePartitionReadCommand;
import org.apache.cassandra.db.SystemKeyspace;
import org.apache.cassandra.db.compaction.CompactionInfo;
import org.apache.cassandra.db.compaction.CompactionManager;
import org.apache.cassandra.db.compaction.OperationType;
import org.apache.cassandra.db.lifecycle.SSTableSet;
import org.apache.cassandra.db.partitions.UnfilteredPartitionIterators;
import org.apache.cassandra.db.rows.Rows;
import org.apache.cassandra.db.rows.UnfilteredRowIterator;
import org.apache.cassandra.db.rows.UnfilteredRowIterators;
import org.apache.cassandra.db.view.View;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.io.sstable.ReducingKeyIterator;
import org.apache.cassandra.io.sstable.format.SSTableReader;
import org.apache.cassandra.service.StorageProxy;
import org.apache.cassandra.service.StorageService;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.Pair;
import org.apache.cassandra.utils.UUIDGen;
import org.apache.cassandra.utils.concurrent.Refs;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ViewBuilder
extends CompactionInfo.Holder {
    private final ColumnFamilyStore baseCfs;
    private final View view;
    private final UUID compactionId;
    private volatile Token prevToken = null;
    private static final Logger logger = LoggerFactory.getLogger(ViewBuilder.class);
    private volatile boolean isStopped = false;

    public ViewBuilder(ColumnFamilyStore baseCfs, View view) {
        this.baseCfs = baseCfs;
        this.view = view;
        this.compactionId = UUIDGen.getTimeUUID();
    }

    private void buildKey(DecoratedKey key) {
        AtomicLong noBase = new AtomicLong(Long.MAX_VALUE);
        ReadQuery selectQuery = this.view.getReadQuery();
        if (!selectQuery.selectsKey(key)) {
            return;
        }
        int nowInSec = FBUtilities.nowInSeconds();
        SinglePartitionReadCommand command = this.view.getSelectStatement().internalReadForView(key, nowInSec);
        UnfilteredRowIterator empty = UnfilteredRowIterators.noRowsIterator(this.baseCfs.metadata, key, Rows.EMPTY_STATIC_ROW, DeletionTime.LIVE, false);
        try (ReadOrderGroup orderGroup = command.startOrderGroup();
             UnfilteredRowIterator data = UnfilteredPartitionIterators.getOnlyElement(command.executeLocally(orderGroup), command);){
            Iterator<Collection<Mutation>> mutations = this.baseCfs.keyspace.viewManager.forTable(this.baseCfs.metadata).generateViewUpdates(Collections.singleton(this.view), data, empty, nowInSec, true);
            mutations.forEachRemaining(m -> StorageProxy.mutateMV(key.getKey(), m, true, noBase));
        }
    }

    public void run() {
        Token lastToken;
        Object object;
        Object temp;
        Function<org.apache.cassandra.db.lifecycle.View, Iterable<SSTableReader>> function;
        String ksname = this.baseCfs.metadata.ksName;
        String viewName = this.view.name;
        if (SystemKeyspace.isViewBuilt(ksname, viewName)) {
            return;
        }
        Collection<Range<Token>> ranges = StorageService.instance.getLocalRanges(this.baseCfs.metadata.ksName);
        final Pair<Integer, Token> buildStatus = SystemKeyspace.getViewBuildStatus(ksname, viewName);
        if (buildStatus == null) {
            this.baseCfs.forceBlockingFlush();
            function = org.apache.cassandra.db.lifecycle.View.selectFunction(SSTableSet.CANONICAL);
            int generation = Integer.MIN_VALUE;
            temp = this.baseCfs.selectAndReference(function).refs;
            Throwable throwable = null;
            try {
                object = ((Refs)temp).iterator();
                while (object.hasNext()) {
                    SSTableReader reader = object.next();
                    generation = Math.max(reader.descriptor.generation, generation);
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (temp != null) {
                    if (throwable != null) {
                        try {
                            ((Refs)temp).close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        ((Refs)temp).close();
                    }
                }
            }
            SystemKeyspace.beginViewBuild(ksname, viewName, generation);
            lastToken = null;
        } else {
            function = new Function<org.apache.cassandra.db.lifecycle.View, Iterable<SSTableReader>>(){

                @Nullable
                public Iterable<SSTableReader> apply(org.apache.cassandra.db.lifecycle.View view) {
                    Iterable readers = (Iterable)org.apache.cassandra.db.lifecycle.View.selectFunction(SSTableSet.CANONICAL).apply((Object)view);
                    if (readers != null) {
                        return Iterables.filter((Iterable)readers, ssTableReader -> ssTableReader.descriptor.generation <= (Integer)buildStatus2.left);
                    }
                    return null;
                }
            };
            lastToken = (Token)buildStatus.right;
        }
        this.prevToken = lastToken;
        try {
            Refs<SSTableReader> sstables = this.baseCfs.selectAndReference(function).refs;
            temp = null;
            try {
                ReducingKeyIterator iter = new ReducingKeyIterator(sstables);
                object = null;
                try {
                    while (!this.isStopped && iter.hasNext()) {
                        DecoratedKey key = iter.next();
                        Token token = key.getToken();
                        if (lastToken != null && lastToken.compareTo(token) >= 0) continue;
                        for (Range range : ranges) {
                            if (!range.contains(token)) continue;
                            this.buildKey(key);
                            if (this.prevToken != null && this.prevToken.compareTo(token) == 0) continue;
                            SystemKeyspace.updateViewBuildStatus(ksname, viewName, key.getToken());
                            this.prevToken = token;
                        }
                        lastToken = null;
                    }
                    if (!this.isStopped) {
                        SystemKeyspace.finishViewBuildStatus(ksname, viewName);
                    }
                }
                catch (Throwable throwable) {
                    object = throwable;
                    throw throwable;
                }
                finally {
                    if (iter != null) {
                        if (object != null) {
                            try {
                                iter.close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)object).addSuppressed(throwable);
                            }
                        } else {
                            iter.close();
                        }
                    }
                }
            }
            catch (Throwable throwable) {
                temp = throwable;
                throw throwable;
            }
            finally {
                if (sstables != null) {
                    if (temp != null) {
                        try {
                            sstables.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)temp).addSuppressed(throwable);
                        }
                    } else {
                        sstables.close();
                    }
                }
            }
        }
        catch (Exception e) {
            ViewBuilder builder = new ViewBuilder(this.baseCfs, this.view);
            ScheduledExecutors.nonPeriodicTasks.schedule(() -> CompactionManager.instance.submitViewBuilder(builder), 5L, TimeUnit.MINUTES);
            logger.warn("Materialized View failed to complete, sleeping 5 minutes before restarting", (Throwable)e);
        }
    }

    @Override
    public CompactionInfo getCompactionInfo() {
        long rangesLeft = 0L;
        long rangesTotal = 0L;
        Token lastToken = this.prevToken;
        for (Range<Token> range : StorageService.instance.getLocalRanges(this.baseCfs.keyspace.getName())) {
            ++rangesLeft;
            ++rangesTotal;
            if (lastToken != null && !range.contains(lastToken)) continue;
            rangesLeft = 0L;
        }
        return new CompactionInfo(this.baseCfs.metadata, OperationType.VIEW_BUILD, rangesLeft, rangesTotal, "ranges", this.compactionId);
    }

    @Override
    public void stop() {
        this.isStopped = true;
    }
}

