/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.rows;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.ColumnDefinition;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.DeletionPurger;
import org.apache.cassandra.db.LivenessInfo;
import org.apache.cassandra.db.SerializationHeader;
import org.apache.cassandra.db.TypeSizes;
import org.apache.cassandra.db.context.CounterContext;
import org.apache.cassandra.db.marshal.ByteType;
import org.apache.cassandra.db.rows.AbstractCell;
import org.apache.cassandra.db.rows.Cell;
import org.apache.cassandra.db.rows.CellPath;
import org.apache.cassandra.db.rows.SerializationHelper;
import org.apache.cassandra.io.util.DataInputPlus;
import org.apache.cassandra.io.util.DataOutputPlus;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.ObjectSizes;
import org.apache.cassandra.utils.memory.AbstractAllocator;

public class BufferCell
extends AbstractCell {
    private static final long EMPTY_SIZE = ObjectSizes.measure(new BufferCell(ColumnDefinition.regularDef("", "", "", ByteType.instance), 0L, 0, 0, ByteBufferUtil.EMPTY_BYTE_BUFFER, null));
    private final long timestamp;
    private final int ttl;
    private final int localDeletionTime;
    private final ByteBuffer value;
    private final CellPath path;

    public BufferCell(ColumnDefinition column, long timestamp, int ttl, int localDeletionTime, ByteBuffer value, CellPath path) {
        super(column);
        assert (column.isComplex() == (path != null));
        this.timestamp = timestamp;
        this.ttl = ttl;
        this.localDeletionTime = localDeletionTime;
        this.value = value;
        this.path = path;
    }

    public static BufferCell live(CFMetaData metadata, ColumnDefinition column, long timestamp, ByteBuffer value) {
        return BufferCell.live(metadata, column, timestamp, value, null);
    }

    public static BufferCell live(CFMetaData metadata, ColumnDefinition column, long timestamp, ByteBuffer value, CellPath path) {
        if (metadata.params.defaultTimeToLive != 0) {
            return BufferCell.expiring(column, timestamp, metadata.params.defaultTimeToLive, FBUtilities.nowInSeconds(), value, path);
        }
        return new BufferCell(column, timestamp, 0, Integer.MAX_VALUE, value, path);
    }

    public static BufferCell expiring(ColumnDefinition column, long timestamp, int ttl, int nowInSec, ByteBuffer value) {
        return BufferCell.expiring(column, timestamp, ttl, nowInSec, value, null);
    }

    public static BufferCell expiring(ColumnDefinition column, long timestamp, int ttl, int nowInSec, ByteBuffer value, CellPath path) {
        assert (ttl != 0);
        return new BufferCell(column, timestamp, ttl, nowInSec + ttl, value, path);
    }

    public static BufferCell tombstone(ColumnDefinition column, long timestamp, int nowInSec) {
        return BufferCell.tombstone(column, timestamp, nowInSec, null);
    }

    public static BufferCell tombstone(ColumnDefinition column, long timestamp, int nowInSec, CellPath path) {
        return new BufferCell(column, timestamp, 0, nowInSec, ByteBufferUtil.EMPTY_BYTE_BUFFER, path);
    }

    @Override
    public boolean isCounterCell() {
        return !this.isTombstone() && this.column.cellValueType().isCounter();
    }

    @Override
    public boolean isLive(int nowInSec) {
        return this.localDeletionTime == Integer.MAX_VALUE || this.ttl != 0 && nowInSec < this.localDeletionTime;
    }

    @Override
    public boolean isTombstone() {
        return this.localDeletionTime != Integer.MAX_VALUE && this.ttl == 0;
    }

    @Override
    public boolean isExpiring() {
        return this.ttl != 0;
    }

    @Override
    public long timestamp() {
        return this.timestamp;
    }

    @Override
    public int ttl() {
        return this.ttl;
    }

    @Override
    public int localDeletionTime() {
        return this.localDeletionTime;
    }

    @Override
    public ByteBuffer value() {
        return this.value;
    }

    @Override
    public CellPath path() {
        return this.path;
    }

    @Override
    public Cell withUpdatedColumn(ColumnDefinition newColumn) {
        return new BufferCell(newColumn, this.timestamp, this.ttl, this.localDeletionTime, this.value, this.path);
    }

    @Override
    public Cell withUpdatedValue(ByteBuffer newValue) {
        return new BufferCell(this.column, this.timestamp, this.ttl, this.localDeletionTime, newValue, this.path);
    }

    @Override
    public Cell copy(AbstractAllocator allocator) {
        if (!this.value.hasRemaining()) {
            return this;
        }
        return new BufferCell(this.column, this.timestamp, this.ttl, this.localDeletionTime, allocator.clone(this.value), this.path == null ? null : this.path.copy(allocator));
    }

    @Override
    public Cell markCounterLocalToBeCleared() {
        if (!this.isCounterCell()) {
            return this;
        }
        ByteBuffer marked = CounterContext.instance().markLocalToBeCleared(this.value());
        return marked == this.value() ? this : new BufferCell(this.column, this.timestamp, this.ttl, this.localDeletionTime, marked, this.path);
    }

    @Override
    public Cell purge(DeletionPurger purger, int nowInSec) {
        if (!this.isLive(nowInSec)) {
            if (purger.shouldPurge(this.timestamp, this.localDeletionTime)) {
                return null;
            }
            if (this.isExpiring()) {
                return BufferCell.tombstone(this.column, this.timestamp, this.localDeletionTime - this.ttl, this.path);
            }
        }
        return this;
    }

    @Override
    public Cell updateAllTimestamp(long newTimestamp) {
        return new BufferCell(this.column, this.isTombstone() ? newTimestamp - 1L : newTimestamp, this.ttl, this.localDeletionTime, this.value, this.path);
    }

    @Override
    public int dataSize() {
        return TypeSizes.sizeof(this.timestamp) + TypeSizes.sizeof(this.ttl) + TypeSizes.sizeof(this.localDeletionTime) + this.value.remaining() + (this.path == null ? 0 : this.path.dataSize());
    }

    @Override
    public long unsharedHeapSizeExcludingData() {
        return EMPTY_SIZE + ObjectSizes.sizeOnHeapExcludingData(this.value) + (this.path == null ? 0L : this.path.unsharedHeapSizeExcludingData());
    }

    static class Serializer
    implements Cell.Serializer {
        private static final int IS_DELETED_MASK = 1;
        private static final int IS_EXPIRING_MASK = 2;
        private static final int HAS_EMPTY_VALUE_MASK = 4;
        private static final int USE_ROW_TIMESTAMP_MASK = 8;
        private static final int USE_ROW_TTL_MASK = 16;

        Serializer() {
        }

        @Override
        public void serialize(Cell cell, ColumnDefinition column, DataOutputPlus out, LivenessInfo rowLiveness, SerializationHeader header) throws IOException {
            assert (cell != null);
            boolean hasValue = cell.value().hasRemaining();
            boolean isDeleted = cell.isTombstone();
            boolean isExpiring = cell.isExpiring();
            boolean useRowTimestamp = !rowLiveness.isEmpty() && cell.timestamp() == rowLiveness.timestamp();
            boolean useRowTTL = isExpiring && rowLiveness.isExpiring() && cell.ttl() == rowLiveness.ttl() && cell.localDeletionTime() == rowLiveness.localExpirationTime();
            int flags = 0;
            if (!hasValue) {
                flags |= 4;
            }
            if (isDeleted) {
                flags |= 1;
            } else if (isExpiring) {
                flags |= 2;
            }
            if (useRowTimestamp) {
                flags |= 8;
            }
            if (useRowTTL) {
                flags |= 0x10;
            }
            out.writeByte((byte)flags);
            if (!useRowTimestamp) {
                header.writeTimestamp(cell.timestamp(), out);
            }
            if ((isDeleted || isExpiring) && !useRowTTL) {
                header.writeLocalDeletionTime(cell.localDeletionTime(), out);
            }
            if (isExpiring && !useRowTTL) {
                header.writeTTL(cell.ttl(), out);
            }
            if (column.isComplex()) {
                column.cellPathSerializer().serialize(cell.path(), out);
            }
            if (hasValue) {
                header.getType(column).writeValue(cell.value(), out);
            }
        }

        @Override
        public Cell deserialize(DataInputPlus in, LivenessInfo rowLiveness, ColumnDefinition column, SerializationHeader header, SerializationHelper helper) throws IOException {
            int localDeletionTime;
            long timestamp;
            int flags = in.readUnsignedByte();
            boolean hasValue = (flags & 4) == 0;
            boolean isDeleted = (flags & 1) != 0;
            boolean isExpiring = (flags & 2) != 0;
            boolean useRowTimestamp = (flags & 8) != 0;
            boolean useRowTTL = (flags & 0x10) != 0;
            long l = timestamp = useRowTimestamp ? rowLiveness.timestamp() : header.readTimestamp(in);
            int n = useRowTTL ? rowLiveness.localExpirationTime() : (localDeletionTime = isDeleted || isExpiring ? header.readLocalDeletionTime(in) : Integer.MAX_VALUE);
            int ttl = useRowTTL ? rowLiveness.ttl() : (isExpiring ? header.readTTL(in) : 0);
            CellPath path = column.isComplex() ? column.cellPathSerializer().deserialize(in) : null;
            boolean isCounter = localDeletionTime == Integer.MAX_VALUE && column.type.isCounter();
            ByteBuffer value = ByteBufferUtil.EMPTY_BYTE_BUFFER;
            if (hasValue) {
                if (helper.canSkipValue(column) || path != null && helper.canSkipValue(path)) {
                    header.getType(column).skipValue(in);
                } else {
                    value = header.getType(column).readValue(in, DatabaseDescriptor.getMaxValueSize());
                    if (isCounter) {
                        value = helper.maybeClearCounterValue(value);
                    }
                }
            }
            return new BufferCell(column, timestamp, ttl, localDeletionTime, value, path);
        }

        @Override
        public long serializedSize(Cell cell, ColumnDefinition column, LivenessInfo rowLiveness, SerializationHeader header) {
            boolean useRowTTL;
            long size = 1L;
            boolean hasValue = cell.value().hasRemaining();
            boolean isDeleted = cell.isTombstone();
            boolean isExpiring = cell.isExpiring();
            boolean useRowTimestamp = !rowLiveness.isEmpty() && cell.timestamp() == rowLiveness.timestamp();
            boolean bl = useRowTTL = isExpiring && rowLiveness.isExpiring() && cell.ttl() == rowLiveness.ttl() && cell.localDeletionTime() == rowLiveness.localExpirationTime();
            if (!useRowTimestamp) {
                size += header.timestampSerializedSize(cell.timestamp());
            }
            if ((isDeleted || isExpiring) && !useRowTTL) {
                size += header.localDeletionTimeSerializedSize(cell.localDeletionTime());
            }
            if (isExpiring && !useRowTTL) {
                size += header.ttlSerializedSize(cell.ttl());
            }
            if (column.isComplex()) {
                size += column.cellPathSerializer().serializedSize(cell.path());
            }
            if (hasValue) {
                size += header.getType(column).writtenLength(cell.value());
            }
            return size;
        }

        @Override
        public boolean skip(DataInputPlus in, ColumnDefinition column, SerializationHeader header) throws IOException {
            boolean useRowTTL;
            int flags = in.readUnsignedByte();
            boolean hasValue = (flags & 4) == 0;
            boolean isDeleted = (flags & 1) != 0;
            boolean isExpiring = (flags & 2) != 0;
            boolean useRowTimestamp = (flags & 8) != 0;
            boolean bl = useRowTTL = (flags & 0x10) != 0;
            if (!useRowTimestamp) {
                header.skipTimestamp(in);
            }
            if (!useRowTTL && (isDeleted || isExpiring)) {
                header.skipLocalDeletionTime(in);
            }
            if (!useRowTTL && isExpiring) {
                header.skipTTL(in);
            }
            if (column.isComplex()) {
                column.cellPathSerializer().skip(in);
            }
            if (hasValue) {
                header.getType(column).skipValue(in);
            }
            return true;
        }
    }
}

