/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service.pager;

import java.nio.ByteBuffer;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.ReadCommand;
import org.apache.cassandra.db.SinglePartitionReadCommand;
import org.apache.cassandra.db.filter.DataLimits;
import org.apache.cassandra.db.rows.Row;
import org.apache.cassandra.service.pager.AbstractQueryPager;
import org.apache.cassandra.service.pager.PagingState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SinglePartitionPager
extends AbstractQueryPager {
    private static final Logger logger = LoggerFactory.getLogger(SinglePartitionPager.class);
    private final SinglePartitionReadCommand<?> command;
    private volatile PagingState.RowMark lastReturned;

    public SinglePartitionPager(SinglePartitionReadCommand<?> command, PagingState state, int protocolVersion) {
        super(command, protocolVersion);
        this.command = command;
        if (state != null) {
            this.lastReturned = state.rowMark;
            this.restoreState(command.partitionKey(), state.remaining, state.remainingInPartition);
        }
    }

    public ByteBuffer key() {
        return this.command.partitionKey().getKey();
    }

    public DataLimits limits() {
        return this.command.limits();
    }

    @Override
    public PagingState state() {
        return this.lastReturned == null ? null : new PagingState(null, this.lastReturned, this.maxRemaining(), this.remainingInPartition());
    }

    @Override
    protected ReadCommand nextPageReadCommand(int pageSize) {
        return this.command.forPaging(this.lastReturned == null ? null : this.lastReturned.clustering(this.command.metadata()), pageSize);
    }

    @Override
    protected void recordLast(DecoratedKey key, Row last) {
        if (last != null) {
            this.lastReturned = PagingState.RowMark.create(this.command.metadata(), last, this.protocolVersion);
        }
    }

    @Override
    protected boolean isPreviouslyReturnedPartition(DecoratedKey key) {
        return this.lastReturned != null;
    }
}

