/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service.pager;

import java.util.Optional;
import org.apache.cassandra.db.DataRange;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.PartitionPosition;
import org.apache.cassandra.db.PartitionRangeReadCommand;
import org.apache.cassandra.db.ReadCommand;
import org.apache.cassandra.db.filter.DataLimits;
import org.apache.cassandra.db.rows.Row;
import org.apache.cassandra.dht.AbstractBounds;
import org.apache.cassandra.dht.Bounds;
import org.apache.cassandra.dht.ExcludingBounds;
import org.apache.cassandra.dht.IncludingExcludingBounds;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.exceptions.RequestExecutionException;
import org.apache.cassandra.service.pager.AbstractQueryPager;
import org.apache.cassandra.service.pager.PagingState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RangeSliceQueryPager
extends AbstractQueryPager {
    private static final Logger logger = LoggerFactory.getLogger(RangeSliceQueryPager.class);
    private volatile DecoratedKey lastReturnedKey;
    private volatile PagingState.RowMark lastReturnedRow;

    public RangeSliceQueryPager(PartitionRangeReadCommand command, PagingState state, int protocolVersion) {
        super(command, protocolVersion);
        assert (!command.isNamesQuery());
        if (state != null) {
            this.lastReturnedKey = command.metadata().decorateKey(state.partitionKey);
            this.lastReturnedRow = state.rowMark;
            this.restoreState(this.lastReturnedKey, state.remaining, state.remainingInPartition);
        }
    }

    @Override
    public PagingState state() {
        return this.lastReturnedKey == null ? null : new PagingState(this.lastReturnedKey.getKey(), this.lastReturnedRow, this.maxRemaining(), this.remainingInPartition());
    }

    @Override
    protected ReadCommand nextPageReadCommand(int pageSize) throws RequestExecutionException {
        DataLimits limits;
        DataRange pageRange;
        DataRange fullRange = ((PartitionRangeReadCommand)this.command).dataRange();
        if (this.lastReturnedKey == null) {
            pageRange = fullRange;
            limits = this.command.limits().forPaging(pageSize);
        } else {
            boolean includeLastKey = this.remainingInPartition() > 0;
            AbstractBounds<PartitionPosition> bounds = this.makeKeyBounds(this.lastReturnedKey, includeLastKey);
            if (includeLastKey) {
                pageRange = fullRange.forPaging(bounds, this.command.metadata().comparator, this.lastReturnedRow.clustering(this.command.metadata()), false);
                limits = this.command.limits().forPaging(pageSize, this.lastReturnedKey.getKey(), this.remainingInPartition());
            } else {
                pageRange = fullRange.forSubRange(bounds);
                limits = this.command.limits().forPaging(pageSize);
            }
        }
        return new PartitionRangeReadCommand(this.command.metadata(), this.command.nowInSec(), this.command.columnFilter(), this.command.rowFilter(), limits, pageRange, Optional.empty());
    }

    @Override
    protected void recordLast(DecoratedKey key, Row last) {
        if (last != null) {
            this.lastReturnedKey = key;
            this.lastReturnedRow = PagingState.RowMark.create(this.command.metadata(), last, this.protocolVersion);
        }
    }

    @Override
    protected boolean isPreviouslyReturnedPartition(DecoratedKey key) {
        return key.equals(this.lastReturnedKey);
    }

    private AbstractBounds<PartitionPosition> makeKeyBounds(PartitionPosition lastReturnedKey, boolean includeLastKey) {
        AbstractBounds<PartitionPosition> bounds = ((PartitionRangeReadCommand)this.command).dataRange().keyRange();
        if (bounds instanceof Range || bounds instanceof Bounds) {
            return includeLastKey ? new Bounds<PartitionPosition>(lastReturnedKey, (PartitionPosition)bounds.right) : new Range<PartitionPosition>(lastReturnedKey, (PartitionPosition)bounds.right);
        }
        return includeLastKey ? new IncludingExcludingBounds<PartitionPosition>(lastReturnedKey, (PartitionPosition)bounds.right) : new ExcludingBounds<PartitionPosition>(lastReturnedKey, (PartitionPosition)bounds.right);
    }
}

