/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service.pager;

import java.util.NoSuchElementException;
import org.apache.cassandra.db.ConsistencyLevel;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.ReadCommand;
import org.apache.cassandra.db.ReadOrderGroup;
import org.apache.cassandra.db.filter.DataLimits;
import org.apache.cassandra.db.partitions.CountingPartitionIterator;
import org.apache.cassandra.db.partitions.PartitionIterator;
import org.apache.cassandra.db.partitions.PartitionIterators;
import org.apache.cassandra.db.rows.Row;
import org.apache.cassandra.db.rows.RowIterator;
import org.apache.cassandra.db.rows.WrappingRowIterator;
import org.apache.cassandra.exceptions.RequestExecutionException;
import org.apache.cassandra.exceptions.RequestValidationException;
import org.apache.cassandra.service.ClientState;
import org.apache.cassandra.service.pager.QueryPager;
import org.apache.cassandra.service.pager.SinglePartitionPager;

abstract class AbstractQueryPager
implements QueryPager {
    protected final ReadCommand command;
    protected final DataLimits limits;
    protected final int protocolVersion;
    private int remaining;
    private DecoratedKey lastKey;
    private int remainingInPartition;
    private boolean exhausted;

    protected AbstractQueryPager(ReadCommand command, int protocolVersion) {
        this.command = command;
        this.protocolVersion = protocolVersion;
        this.limits = command.limits();
        this.remaining = this.limits.count();
        this.remainingInPartition = this.limits.perPartitionCount();
    }

    @Override
    public ReadOrderGroup startOrderGroup() {
        return this.command.startOrderGroup();
    }

    @Override
    public PartitionIterator fetchPage(int pageSize, ConsistencyLevel consistency, ClientState clientState) throws RequestValidationException, RequestExecutionException {
        if (this.isExhausted()) {
            return PartitionIterators.EMPTY;
        }
        pageSize = Math.min(pageSize, this.remaining);
        return new PagerIterator(this.nextPageReadCommand(pageSize).execute(consistency, clientState), this.limits.forPaging(pageSize), this.command.nowInSec());
    }

    @Override
    public PartitionIterator fetchPageInternal(int pageSize, ReadOrderGroup orderGroup) throws RequestValidationException, RequestExecutionException {
        if (this.isExhausted()) {
            return PartitionIterators.EMPTY;
        }
        pageSize = Math.min(pageSize, this.remaining);
        return new PagerIterator(this.nextPageReadCommand(pageSize).executeInternal(orderGroup), this.limits.forPaging(pageSize), this.command.nowInSec());
    }

    protected void restoreState(DecoratedKey lastKey, int remaining, int remainingInPartition) {
        this.lastKey = lastKey;
        this.remaining = remaining;
        this.remainingInPartition = remainingInPartition;
    }

    @Override
    public boolean isExhausted() {
        return this.exhausted || this.remaining == 0 || this instanceof SinglePartitionPager && this.remainingInPartition == 0;
    }

    @Override
    public int maxRemaining() {
        return this.remaining;
    }

    protected int remainingInPartition() {
        return this.remainingInPartition;
    }

    protected abstract ReadCommand nextPageReadCommand(int var1);

    protected abstract void recordLast(DecoratedKey var1, Row var2);

    protected abstract boolean isPreviouslyReturnedPartition(DecoratedKey var1);

    private class PagerIterator
    extends CountingPartitionIterator {
        private final DataLimits pageLimits;
        private Row lastRow;
        private boolean isFirstPartition;
        private RowIterator nextPartition;

        private PagerIterator(PartitionIterator iter, DataLimits pageLimits, int nowInSec) {
            super(iter, pageLimits, nowInSec);
            this.isFirstPartition = true;
            this.pageLimits = pageLimits;
        }

        @Override
        public boolean hasNext() {
            while (this.nextPartition == null && super.hasNext()) {
                if (this.nextPartition == null) {
                    this.nextPartition = super.next();
                }
                DecoratedKey key = this.nextPartition.partitionKey();
                if (AbstractQueryPager.this.lastKey == null || !AbstractQueryPager.this.lastKey.equals(key)) {
                    AbstractQueryPager.this.remainingInPartition = AbstractQueryPager.this.limits.perPartitionCount();
                }
                AbstractQueryPager.this.lastKey = key;
                if (this.isFirstPartition && AbstractQueryPager.this.isPreviouslyReturnedPartition(key) && !this.nextPartition.hasNext()) {
                    this.nextPartition.close();
                    this.nextPartition = null;
                }
                this.isFirstPartition = false;
            }
            return this.nextPartition != null;
        }

        @Override
        public RowIterator next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            RowIterator toReturn = this.nextPartition;
            this.nextPartition = null;
            return new RowPagerIterator(toReturn);
        }

        @Override
        public void close() {
            super.close();
            if (this.nextPartition != null) {
                this.nextPartition.close();
            }
            AbstractQueryPager.this.recordLast(AbstractQueryPager.this.lastKey, this.lastRow);
            int counted = this.counter.counted();
            AbstractQueryPager.this.remaining = AbstractQueryPager.this.remaining - counted;
            AbstractQueryPager.this.remainingInPartition = AbstractQueryPager.this.remainingInPartition - this.counter.countedInCurrentPartition();
            AbstractQueryPager.this.exhausted = counted < this.pageLimits.count();
        }

        private class RowPagerIterator
        extends WrappingRowIterator {
            RowPagerIterator(RowIterator iter) {
                super(iter);
            }

            @Override
            public Row next() {
                PagerIterator.this.lastRow = super.next();
                return PagerIterator.this.lastRow;
            }
        }
    }
}

