/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.view;

import com.google.common.collect.Lists;
import com.google.common.util.concurrent.Striped;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.locks.Lock;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.config.ViewDefinition;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.IMutation;
import org.apache.cassandra.db.Keyspace;
import org.apache.cassandra.db.Mutation;
import org.apache.cassandra.db.SystemKeyspace;
import org.apache.cassandra.db.commitlog.ReplayPosition;
import org.apache.cassandra.db.partitions.PartitionUpdate;
import org.apache.cassandra.db.view.TemporalRow;
import org.apache.cassandra.db.view.View;
import org.apache.cassandra.service.StorageProxy;

public class ViewManager {
    private static final Striped<Lock> LOCKS = Striped.lazyWeakLock((int)(DatabaseDescriptor.getConcurrentViewWriters() * 1024));
    private static final boolean enableCoordinatorBatchlog = Boolean.getBoolean("cassandra.mv_enable_coordinator_batchlog");
    private final ConcurrentNavigableMap<UUID, ForStore> viewManagersByStore = new ConcurrentSkipListMap<UUID, ForStore>();
    private final ConcurrentNavigableMap<String, View> viewsByName = new ConcurrentSkipListMap<String, View>();
    private final Keyspace keyspace;

    public ViewManager(Keyspace keyspace) {
        this.keyspace = keyspace;
    }

    public void pushViewReplicaUpdates(PartitionUpdate update, boolean writeCommitLog) {
        LinkedList mutations = null;
        TemporalRow.Set temporalRows = null;
        for (Map.Entry view : this.viewsByName.entrySet()) {
            temporalRows = ((View)view.getValue()).getTemporalRowSet(update, temporalRows, false);
            Collection<Mutation> viewMutations = ((View)view.getValue()).createMutations(update, temporalRows, false);
            if (viewMutations == null || viewMutations.isEmpty()) continue;
            if (mutations == null) {
                mutations = Lists.newLinkedList();
            }
            mutations.addAll(viewMutations);
        }
        if (mutations != null) {
            StorageProxy.mutateMV(update.partitionKey().getKey(), mutations, writeCommitLog);
        }
    }

    public boolean updatesAffectView(Collection<? extends IMutation> mutations, boolean coordinatorBatchlog) {
        if (coordinatorBatchlog && !enableCoordinatorBatchlog) {
            return false;
        }
        for (IMutation iMutation : mutations) {
            for (PartitionUpdate cf : iMutation.getPartitionUpdates()) {
                assert (this.keyspace.getName().equals(cf.metadata().ksName));
                if (coordinatorBatchlog && this.keyspace.getReplicationStrategy().getReplicationFactor() == 1) continue;
                for (View view : this.allViews()) {
                    if (!cf.metadata().cfId.equals(view.getDefinition().baseTableId) || !view.updateAffectsView(cf)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public Iterable<View> allViews() {
        return this.viewsByName.values();
    }

    public void update(String viewName) {
        View view = (View)this.viewsByName.get(viewName);
        assert (view != null) : "When updating a view, it should already be in the ViewManager";
        view.build();
        Optional<ViewDefinition> viewDefinition = this.keyspace.getMetadata().views.get(viewName);
        assert (viewDefinition.isPresent()) : "When updating a view, it should still be in the Keyspaces views";
        view.updateDefinition(viewDefinition.get());
    }

    public void reload() {
        HashMap<String, ViewDefinition> newViewsByName = new HashMap<String, ViewDefinition>();
        for (ViewDefinition viewDefinition : this.keyspace.getMetadata().views) {
            newViewsByName.put(viewDefinition.viewName, viewDefinition);
        }
        for (String string : this.viewsByName.keySet()) {
            if (newViewsByName.containsKey(string)) continue;
            this.removeView(string);
        }
        for (Map.Entry entry : newViewsByName.entrySet()) {
            if (this.viewsByName.containsKey(entry.getKey())) continue;
            this.addView((ViewDefinition)entry.getValue());
        }
        for (View view : this.allViews()) {
            view.build();
            view.updateDefinition((ViewDefinition)newViewsByName.get(view.name));
        }
    }

    public void addView(ViewDefinition definition) {
        View view = new View(definition, this.keyspace.getColumnFamilyStore(definition.baseTableId));
        this.forTable(view.getDefinition().baseTableId).addView(view);
        this.viewsByName.put(definition.viewName, view);
    }

    public void removeView(String name) {
        View view = (View)this.viewsByName.remove(name);
        if (view == null) {
            return;
        }
        this.forTable(view.getDefinition().baseTableId).removeView(name);
        SystemKeyspace.setViewRemoved(this.keyspace.getName(), view.name);
    }

    public void buildAllViews() {
        for (View view : this.allViews()) {
            view.build();
        }
    }

    public ForStore forTable(UUID baseId) {
        ForStore previous;
        ForStore forStore = (ForStore)this.viewManagersByStore.get(baseId);
        if (forStore == null && (previous = this.viewManagersByStore.put(baseId, forStore = new ForStore())) != null) {
            forStore = previous;
        }
        return forStore;
    }

    public static Lock acquireLockFor(ByteBuffer key) {
        Lock lock = (Lock)LOCKS.get((Object)key);
        if (lock.tryLock()) {
            return lock;
        }
        return null;
    }

    public class ForStore {
        private final ConcurrentNavigableMap<String, View> viewsByName = new ConcurrentSkipListMap<String, View>();

        public Iterable<View> allViews() {
            return this.viewsByName.values();
        }

        public Iterable<ColumnFamilyStore> allViewsCfs() {
            ArrayList<ColumnFamilyStore> viewColumnFamilies = new ArrayList<ColumnFamilyStore>();
            for (View view : this.allViews()) {
                viewColumnFamilies.add(ViewManager.this.keyspace.getColumnFamilyStore(view.getDefinition().viewName));
            }
            return viewColumnFamilies;
        }

        public void forceBlockingFlush() {
            for (ColumnFamilyStore viewCfs : this.allViewsCfs()) {
                viewCfs.forceBlockingFlush();
            }
        }

        public void dumpMemtables() {
            for (ColumnFamilyStore viewCfs : this.allViewsCfs()) {
                viewCfs.dumpMemtable();
            }
        }

        public void truncateBlocking(long truncatedAt) {
            for (ColumnFamilyStore viewCfs : this.allViewsCfs()) {
                ReplayPosition replayAfter = viewCfs.discardSSTables(truncatedAt);
                SystemKeyspace.saveTruncationRecord(viewCfs, truncatedAt, replayAfter);
            }
        }

        public void addView(View view) {
            this.viewsByName.put(view.name, view);
        }

        public void removeView(String name) {
            this.viewsByName.remove(name);
        }
    }
}

