/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.compaction;

public enum OperationType {
    COMPACTION("Compaction"),
    VALIDATION("Validation"),
    KEY_CACHE_SAVE("Key cache save"),
    ROW_CACHE_SAVE("Row cache save"),
    COUNTER_CACHE_SAVE("Counter cache save"),
    CLEANUP("Cleanup"),
    SCRUB("Scrub"),
    UPGRADE_SSTABLES("Upgrade sstables"),
    INDEX_BUILD("Secondary index build"),
    TOMBSTONE_COMPACTION("Tombstone Compaction"),
    UNKNOWN("Unknown compaction type"),
    ANTICOMPACTION("Anticompaction after repair"),
    VERIFY("Verify"),
    FLUSH("Flush"),
    STREAM("Stream"),
    WRITE("Write"),
    VIEW_BUILD("View build");

    public final String type;
    public final String fileName;

    private OperationType(String type) {
        this.type = type;
        this.fileName = type.toLowerCase().replace(" ", "");
    }

    public static OperationType fromFileName(String fileName) {
        for (OperationType opType : OperationType.values()) {
            if (!opType.fileName.equals(fileName)) continue;
            return opType;
        }
        throw new IllegalArgumentException("Invalid fileName for operation type: " + fileName);
    }

    public String toString() {
        return this.type;
    }
}

