/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import com.google.common.collect.Sets;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.NavigableSet;
import java.util.Set;
import java.util.TreeSet;
import org.apache.cassandra.concurrent.Stage;
import org.apache.cassandra.concurrent.StageManager;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.ColumnDefinition;
import org.apache.cassandra.db.Clusterable;
import org.apache.cassandra.db.Clustering;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.Columns;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.Keyspace;
import org.apache.cassandra.db.Memtable;
import org.apache.cassandra.db.Mutation;
import org.apache.cassandra.db.PartitionColumns;
import org.apache.cassandra.db.SinglePartitionReadCommand;
import org.apache.cassandra.db.Slices;
import org.apache.cassandra.db.filter.ClusteringIndexNamesFilter;
import org.apache.cassandra.db.filter.ColumnFilter;
import org.apache.cassandra.db.filter.DataLimits;
import org.apache.cassandra.db.filter.RowFilter;
import org.apache.cassandra.db.lifecycle.SSTableSet;
import org.apache.cassandra.db.lifecycle.View;
import org.apache.cassandra.db.partitions.AbstractBTreePartition;
import org.apache.cassandra.db.partitions.ImmutableBTreePartition;
import org.apache.cassandra.db.partitions.Partition;
import org.apache.cassandra.db.partitions.PartitionUpdate;
import org.apache.cassandra.db.rows.Cell;
import org.apache.cassandra.db.rows.Row;
import org.apache.cassandra.db.rows.UnfilteredRowIterator;
import org.apache.cassandra.db.rows.UnfilteredRowIterators;
import org.apache.cassandra.io.sstable.format.SSTableReader;
import org.apache.cassandra.metrics.TableMetrics;
import org.apache.cassandra.thrift.ThriftResultsMerger;
import org.apache.cassandra.tracing.Tracing;
import org.apache.cassandra.utils.SearchIterator;
import org.apache.cassandra.utils.btree.BTreeSet;
import org.apache.cassandra.utils.memory.HeapAllocator;

public class SinglePartitionNamesCommand
extends SinglePartitionReadCommand<ClusteringIndexNamesFilter> {
    private int oldestUnrepairedDeletionTime = Integer.MAX_VALUE;

    protected SinglePartitionNamesCommand(boolean isDigest, int digestVersion, boolean isForThrift, CFMetaData metadata, int nowInSec, ColumnFilter columnFilter, RowFilter rowFilter, DataLimits limits, DecoratedKey partitionKey, ClusteringIndexNamesFilter clusteringIndexFilter) {
        super(isDigest, digestVersion, isForThrift, metadata, nowInSec, columnFilter, rowFilter, limits, partitionKey, clusteringIndexFilter);
    }

    public SinglePartitionNamesCommand(CFMetaData metadata, int nowInSec, ColumnFilter columnFilter, RowFilter rowFilter, DataLimits limits, DecoratedKey partitionKey, ClusteringIndexNamesFilter clusteringIndexFilter) {
        this(false, 0, false, metadata, nowInSec, columnFilter, rowFilter, limits, partitionKey, clusteringIndexFilter);
    }

    public SinglePartitionNamesCommand(CFMetaData metadata, int nowInSec, ColumnFilter columnFilter, RowFilter rowFilter, DataLimits limits, ByteBuffer key, ClusteringIndexNamesFilter clusteringIndexFilter) {
        this(metadata, nowInSec, columnFilter, rowFilter, limits, metadata.decorateKey(key), clusteringIndexFilter);
    }

    @Override
    public SinglePartitionNamesCommand copy() {
        return new SinglePartitionNamesCommand(this.isDigestQuery(), this.digestVersion(), this.isForThrift(), this.metadata(), this.nowInSec(), this.columnFilter(), this.rowFilter(), this.limits(), this.partitionKey(), (ClusteringIndexNamesFilter)this.clusteringIndexFilter());
    }

    @Override
    protected int oldestUnrepairedTombstone() {
        return this.oldestUnrepairedDeletionTime;
    }

    @Override
    protected UnfilteredRowIterator queryMemtableAndDiskInternal(ColumnFamilyStore cfs, boolean copyOnHeap) {
        Tracing.trace("Acquiring sstable references");
        ColumnFamilyStore.ViewFragment view = cfs.select(View.select(SSTableSet.LIVE, this.partitionKey()));
        AbstractBTreePartition result = null;
        ClusteringIndexNamesFilter filter = (ClusteringIndexNamesFilter)this.clusteringIndexFilter();
        Tracing.trace("Merging memtable contents");
        for (Memtable memtable : view.memtables) {
            Partition partition = memtable.getPartition(this.partitionKey());
            if (partition == null) continue;
            UnfilteredRowIterator iter = filter.getUnfilteredRowIterator(this.columnFilter(), partition);
            Throwable throwable = null;
            try {
                if (iter.isEmpty()) continue;
                UnfilteredRowIterator clonedFilter = copyOnHeap ? UnfilteredRowIterators.cloningIterator(iter, HeapAllocator.instance) : iter;
                result = this.add(this.isForThrift() ? ThriftResultsMerger.maybeWrap(clonedFilter, this.nowInSec()) : clonedFilter, (ImmutableBTreePartition)result, false);
            }
            catch (Throwable clonedFilter) {
                throwable = clonedFilter;
                throw clonedFilter;
            }
            finally {
                if (iter == null) continue;
                if (throwable != null) {
                    try {
                        iter.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    continue;
                }
                iter.close();
            }
        }
        Collections.sort(view.sstables, SSTableReader.maxTimestampComparator);
        int sstablesIterated = 0;
        for (SSTableReader sstable : view.sstables) {
            long currentMaxTs;
            if (result != null && sstable.getMaxTimestamp() < result.partitionLevelDeletion().markedForDeleteAt() || (filter = this.reduceFilter(filter, result, currentMaxTs = sstable.getMaxTimestamp())) == null) break;
            Tracing.trace("Merging data from sstable {}", (Object)sstable.descriptor.generation);
            sstable.incrementReadCount();
            UnfilteredRowIterator iter = filter.filter(sstable.iterator(this.partitionKey(), this.columnFilter(), filter.isReversed(), this.isForThrift()));
            Throwable throwable = null;
            try {
                if (iter.isEmpty()) continue;
                ++sstablesIterated;
                result = this.add(this.isForThrift() ? ThriftResultsMerger.maybeWrap(iter, this.nowInSec()) : iter, (ImmutableBTreePartition)result, sstable.isRepaired());
            }
            catch (Throwable throwable3) {
                throwable = throwable3;
                throw throwable3;
            }
            finally {
                if (iter == null) continue;
                if (throwable != null) {
                    try {
                        iter.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                iter.close();
            }
        }
        cfs.metric.updateSSTableIterated(sstablesIterated);
        if (result == null || result.isEmpty()) {
            return UnfilteredRowIterators.emptyIterator(this.metadata(), this.partitionKey(), false);
        }
        DecoratedKey decoratedKey = result.partitionKey();
        cfs.metric.samplers.get((Object)TableMetrics.Sampler.READS).addSample(decoratedKey.getKey(), decoratedKey.hashCode(), 1);
        if (sstablesIterated > cfs.getMinimumCompactionThreshold() && !cfs.isAutoCompactionDisabled() && cfs.getCompactionStrategyManager().shouldDefragment()) {
            Tracing.trace("Defragmenting requested data");
            try (UnfilteredRowIterator iter = result.unfilteredIterator(this.columnFilter(), Slices.ALL, false);){
                final Mutation mutation = new Mutation(PartitionUpdate.fromIterator(iter));
                StageManager.getStage(Stage.MUTATION).execute(new Runnable(){

                    @Override
                    public void run() {
                        Keyspace.open(mutation.getKeyspaceName()).apply(mutation, false, false);
                    }
                });
            }
        }
        return result.unfilteredIterator(this.columnFilter(), Slices.ALL, ((ClusteringIndexNamesFilter)this.clusteringIndexFilter()).isReversed());
    }

    private ImmutableBTreePartition add(UnfilteredRowIterator iter, ImmutableBTreePartition result, boolean isRepaired) {
        if (!isRepaired) {
            this.oldestUnrepairedDeletionTime = Math.min(this.oldestUnrepairedDeletionTime, iter.stats().minLocalDeletionTime);
        }
        int maxRows = Math.max(((ClusteringIndexNamesFilter)this.clusteringIndexFilter()).requestedRows().size(), 1);
        if (result == null) {
            return ImmutableBTreePartition.create(iter, maxRows);
        }
        try (UnfilteredRowIterator merged = UnfilteredRowIterators.merge(Arrays.asList(iter, result.unfilteredIterator(this.columnFilter(), Slices.ALL, ((ClusteringIndexNamesFilter)this.clusteringIndexFilter()).isReversed())), this.nowInSec());){
            ImmutableBTreePartition immutableBTreePartition = ImmutableBTreePartition.create(merged, maxRows);
            return immutableBTreePartition;
        }
    }

    private ClusteringIndexNamesFilter reduceFilter(ClusteringIndexNamesFilter filter, Partition result, long sstableTimestamp) {
        boolean hasNoMoreClusterings;
        if (result == null) {
            return filter;
        }
        SearchIterator<Clustering, Row> searchIter = result.searchIterator(this.columnFilter(), false);
        PartitionColumns columns = this.columnFilter().fetchedColumns();
        NavigableSet<Clustering> clusterings = filter.requestedRows();
        boolean removeStatic = false;
        if (!columns.statics.isEmpty()) {
            Row staticRow = searchIter.next(Clustering.STATIC_CLUSTERING);
            removeStatic = staticRow != null && this.canRemoveRow(staticRow, columns.statics, sstableTimestamp);
        }
        TreeSet<Clusterable> toRemove = null;
        for (Clustering clustering : clusterings) {
            if (!searchIter.hasNext()) break;
            Row row = searchIter.next(clustering);
            if (row == null || !this.canRemoveRow(row, columns.regulars, sstableTimestamp)) continue;
            if (toRemove == null) {
                toRemove = new TreeSet<Clusterable>(result.metadata().comparator);
            }
            toRemove.add(clustering);
        }
        if (!removeStatic && toRemove == null) {
            return filter;
        }
        boolean hasNoMoreStatic = columns.statics.isEmpty() || removeStatic;
        boolean bl = hasNoMoreClusterings = clusterings.isEmpty() || toRemove != null && toRemove.size() == clusterings.size();
        if (hasNoMoreStatic && hasNoMoreClusterings) {
            return null;
        }
        if (toRemove != null) {
            BTreeSet.Builder<Clusterable> newClusterings = BTreeSet.builder(result.metadata().comparator);
            newClusterings.addAll((Collection<Clusterable>)Sets.difference(clusterings, (Set)toRemove));
            clusterings = newClusterings.build();
        }
        return new ClusteringIndexNamesFilter(clusterings, filter.isReversed());
    }

    private boolean canRemoveRow(Row row, Columns requestedColumns, long sstableTimestamp) {
        if (row.primaryKeyLivenessInfo().isEmpty() || row.primaryKeyLivenessInfo().timestamp() <= sstableTimestamp) {
            return false;
        }
        for (ColumnDefinition column : requestedColumns) {
            if (column.type.isCollection()) {
                return false;
            }
            Cell cell = row.getCell(column);
            if (cell != null && cell.timestamp() > sstableTimestamp) continue;
            return false;
        }
        return true;
    }
}

