/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.statements;

import org.apache.cassandra.auth.Permission;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.cql3.CFName;
import org.apache.cassandra.cql3.statements.SchemaAlteringStatement;
import org.apache.cassandra.db.view.View;
import org.apache.cassandra.exceptions.ConfigurationException;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.exceptions.UnauthorizedException;
import org.apache.cassandra.service.ClientState;
import org.apache.cassandra.service.MigrationManager;
import org.apache.cassandra.transport.Event;

public class DropViewStatement
extends SchemaAlteringStatement {
    public final boolean ifExists;

    public DropViewStatement(CFName cf, boolean ifExists) {
        super(cf);
        this.ifExists = ifExists;
    }

    @Override
    public void checkAccess(ClientState state) throws UnauthorizedException, InvalidRequestException {
        CFMetaData baseTable = View.findBaseTable(this.keyspace(), this.columnFamily());
        if (baseTable != null) {
            state.hasColumnFamilyAccess(this.keyspace(), baseTable.cfName, Permission.ALTER);
        }
    }

    @Override
    public void validate(ClientState state) {
    }

    @Override
    public Event.SchemaChange changeEvent() {
        return new Event.SchemaChange(Event.SchemaChange.Change.DROPPED, Event.SchemaChange.Target.TABLE, this.keyspace(), this.columnFamily());
    }

    @Override
    public boolean announceMigration(boolean isLocalOnly) throws InvalidRequestException, ConfigurationException {
        try {
            MigrationManager.announceViewDrop(this.keyspace(), this.columnFamily(), isLocalOnly);
            return true;
        }
        catch (ConfigurationException e) {
            if (this.ifExists) {
                return false;
            }
            throw e;
        }
    }
}

