/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.restrictions;

import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.cql3.ColumnIdentifier;
import org.apache.cassandra.cql3.ColumnSpecification;
import org.apache.cassandra.cql3.IndexName;
import org.apache.cassandra.cql3.QueryOptions;
import org.apache.cassandra.cql3.Term;
import org.apache.cassandra.cql3.VariableSpecifications;
import org.apache.cassandra.cql3.restrictions.IndexRestrictions;
import org.apache.cassandra.db.filter.RowFilter;
import org.apache.cassandra.db.marshal.UTF8Type;

public class CustomIndexExpression {
    private final ColumnIdentifier valueColId = new ColumnIdentifier("custom index expression", false);
    public final IndexName targetIndex;
    public final Term.Raw valueRaw;
    private Term value;

    public CustomIndexExpression(IndexName targetIndex, Term.Raw value) {
        this.targetIndex = targetIndex;
        this.valueRaw = value;
    }

    public void prepareValue(CFMetaData cfm, VariableSpecifications boundNames) {
        ColumnSpecification spec = new ColumnSpecification(cfm.ksName, cfm.ksName, this.valueColId, UTF8Type.instance);
        this.value = this.valueRaw.prepare(cfm.ksName, spec);
        this.value.collectMarkerSpecification(boundNames);
    }

    public void addToRowFilter(RowFilter filter, CFMetaData cfm, QueryOptions options) {
        filter.addCustomIndexExpression(cfm, cfm.getIndexes().get(this.targetIndex.getIdx()).orElseThrow(() -> IndexRestrictions.indexNotFound(this.targetIndex, cfm)), this.value.bindAndGet(options));
    }
}

