/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.config;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.Config;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.config.ViewDefinition;
import org.apache.cassandra.cql3.functions.FunctionName;
import org.apache.cassandra.cql3.functions.UDAggregate;
import org.apache.cassandra.cql3.functions.UDFunction;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.Keyspace;
import org.apache.cassandra.db.SystemKeyspace;
import org.apache.cassandra.db.commitlog.CommitLog;
import org.apache.cassandra.db.compaction.CompactionManager;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.UserType;
import org.apache.cassandra.index.Index;
import org.apache.cassandra.io.sstable.Descriptor;
import org.apache.cassandra.schema.KeyspaceMetadata;
import org.apache.cassandra.schema.KeyspaceParams;
import org.apache.cassandra.schema.SchemaKeyspace;
import org.apache.cassandra.service.MigrationManager;
import org.apache.cassandra.utils.ConcurrentBiMap;
import org.apache.cassandra.utils.Pair;
import org.cliffc.high_scale_lib.NonBlockingHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Schema {
    private static final Logger logger = LoggerFactory.getLogger(Schema.class);
    public static final Schema instance = new Schema();
    public static final Set<String> SYSTEM_KEYSPACE_NAMES = ImmutableSet.of((Object)"system", (Object)"system_schema");
    public static final int NAME_LENGTH = 48;
    private final Map<String, KeyspaceMetadata> keyspaces = new NonBlockingHashMap();
    private final Map<String, Keyspace> keyspaceInstances = new NonBlockingHashMap();
    private final ConcurrentBiMap<Pair<String, String>, UUID> cfIdMap = new ConcurrentBiMap();
    private volatile UUID version;
    public static final UUID emptyVersion;

    public Schema() {
        if (!Config.isClientMode()) {
            this.load(SchemaKeyspace.metadata());
            this.load(SystemKeyspace.metadata());
        }
    }

    public static boolean isSystemKeyspace(String keyspaceName) {
        return SYSTEM_KEYSPACE_NAMES.contains(keyspaceName.toLowerCase());
    }

    public Schema loadFromDisk() {
        return this.loadFromDisk(true);
    }

    public Schema loadFromDisk(boolean updateVersion) {
        this.load(SchemaKeyspace.readSchemaFromSystemTables());
        if (updateVersion) {
            this.updateVersion();
        }
        return this;
    }

    public Schema load(Collection<KeyspaceMetadata> keyspaceDefs) {
        keyspaceDefs.forEach(this::load);
        return this;
    }

    public Schema load(KeyspaceMetadata keyspaceDef) {
        keyspaceDef.tables.forEach(this::load);
        keyspaceDef.views.forEach(this::load);
        this.setKeyspaceMetadata(keyspaceDef);
        return this;
    }

    public Keyspace getKeyspaceInstance(String keyspaceName) {
        return this.keyspaceInstances.get(keyspaceName);
    }

    public ColumnFamilyStore getColumnFamilyStoreIncludingIndexes(Pair<String, String> ksNameAndCFName) {
        String ksName = (String)ksNameAndCFName.left;
        String cfName = (String)ksNameAndCFName.right;
        int indexOfSeparator = cfName.indexOf(46);
        Pair<String, String> baseTable = indexOfSeparator > -1 ? Pair.create(ksName, cfName.substring(0, indexOfSeparator)) : ksNameAndCFName;
        UUID cfId = this.cfIdMap.get(baseTable);
        if (cfId == null) {
            return null;
        }
        Keyspace ks = this.keyspaceInstances.get(ksName);
        if (ks == null) {
            return null;
        }
        ColumnFamilyStore baseCFS = ks.getColumnFamilyStore(cfId);
        if (indexOfSeparator == -1) {
            return baseCFS;
        }
        if (baseCFS == null) {
            return null;
        }
        Index index = baseCFS.indexManager.getIndexByName(cfName.substring(indexOfSeparator + 1, cfName.length()));
        if (index == null) {
            return null;
        }
        return index.getBackingTable().get();
    }

    public ColumnFamilyStore getColumnFamilyStoreInstance(UUID cfId) {
        Pair<String, String> pair = this.cfIdMap.inverse().get(cfId);
        if (pair == null) {
            return null;
        }
        Keyspace instance = this.getKeyspaceInstance((String)pair.left);
        if (instance == null) {
            return null;
        }
        return instance.getColumnFamilyStore(cfId);
    }

    public void storeKeyspaceInstance(Keyspace keyspace) {
        if (this.keyspaceInstances.containsKey(keyspace.getName())) {
            throw new IllegalArgumentException(String.format("Keyspace %s was already initialized.", keyspace.getName()));
        }
        this.keyspaceInstances.put(keyspace.getName(), keyspace);
    }

    public Keyspace removeKeyspaceInstance(String keyspaceName) {
        return this.keyspaceInstances.remove(keyspaceName);
    }

    public void clearKeyspaceMetadata(KeyspaceMetadata ksm) {
        this.keyspaces.remove(ksm.name);
    }

    public CFMetaData getCFMetaData(String keyspaceName, String cfName) {
        assert (keyspaceName != null);
        KeyspaceMetadata ksm = this.keyspaces.get(keyspaceName);
        return ksm == null ? null : ksm.getTableOrViewNullable(cfName);
    }

    public CFMetaData getCFMetaData(UUID cfId) {
        Pair<String, String> cf = this.getCF(cfId);
        return cf == null ? null : this.getCFMetaData((String)cf.left, (String)cf.right);
    }

    public CFMetaData getCFMetaData(Descriptor descriptor) {
        return this.getCFMetaData(descriptor.ksname, descriptor.cfname);
    }

    public ViewDefinition getView(String keyspaceName, String viewName) {
        assert (keyspaceName != null);
        KeyspaceMetadata ksm = this.keyspaces.get(keyspaceName);
        return ksm == null ? null : ksm.views.getNullable(viewName);
    }

    public KeyspaceMetadata getKSMetaData(String keyspaceName) {
        assert (keyspaceName != null);
        return this.keyspaces.get(keyspaceName);
    }

    public List<String> getNonSystemKeyspaces() {
        return ImmutableList.copyOf((Collection)Sets.difference(this.keyspaces.keySet(), SYSTEM_KEYSPACE_NAMES));
    }

    public Iterable<CFMetaData> getTablesAndViews(String keyspaceName) {
        assert (keyspaceName != null);
        KeyspaceMetadata ksm = this.keyspaces.get(keyspaceName);
        assert (ksm != null);
        return ksm.tablesAndViews();
    }

    public Set<String> getKeyspaces() {
        return this.keyspaces.keySet();
    }

    public void setKeyspaceMetadata(KeyspaceMetadata ksm) {
        assert (ksm != null);
        this.keyspaces.put(ksm.name, ksm);
        Keyspace keyspace = this.getKeyspaceInstance(ksm.name);
        if (keyspace != null) {
            keyspace.setMetadata(ksm);
        }
    }

    public Pair<String, String> getCF(UUID cfId) {
        return this.cfIdMap.inverse().get(cfId);
    }

    public boolean hasCF(Pair<String, String> ksAndCFName) {
        return this.cfIdMap.containsKey(ksAndCFName);
    }

    public UUID getId(String ksName, String cfName) {
        return this.cfIdMap.get(Pair.create(ksName, cfName));
    }

    public void load(CFMetaData cfm) {
        Pair<String, String> key = Pair.create(cfm.ksName, cfm.cfName);
        if (this.cfIdMap.containsKey(key)) {
            throw new RuntimeException(String.format("Attempting to load already loaded table %s.%s", cfm.ksName, cfm.cfName));
        }
        logger.debug("Adding {} to cfIdMap", (Object)cfm);
        this.cfIdMap.put(key, cfm.cfId);
    }

    public void load(ViewDefinition view) {
        CFMetaData cfm = view.metadata;
        Pair<String, String> key = Pair.create(cfm.ksName, cfm.cfName);
        if (this.cfIdMap.containsKey(key)) {
            throw new RuntimeException(String.format("Attempting to load already loaded view %s.%s", cfm.ksName, cfm.cfName));
        }
        logger.debug("Adding {} to cfIdMap", (Object)cfm);
        this.cfIdMap.put(key, cfm.cfId);
    }

    public void unload(CFMetaData cfm) {
        this.cfIdMap.remove(Pair.create(cfm.ksName, cfm.cfName));
    }

    private void unload(ViewDefinition view) {
        this.cfIdMap.remove(Pair.create(view.ksName, view.viewName));
    }

    public Collection<org.apache.cassandra.cql3.functions.Function> getFunctions(FunctionName name) {
        if (!name.hasKeyspace()) {
            throw new IllegalArgumentException(String.format("Function name must be fully quallified: got %s", name));
        }
        KeyspaceMetadata ksm = this.getKSMetaData(name.keyspace);
        return ksm == null ? Collections.emptyList() : ksm.functions.get(name);
    }

    public Optional<org.apache.cassandra.cql3.functions.Function> findFunction(FunctionName name, List<AbstractType<?>> argTypes) {
        if (!name.hasKeyspace()) {
            throw new IllegalArgumentException(String.format("Function name must be fully quallified: got %s", name));
        }
        KeyspaceMetadata ksm = this.getKSMetaData(name.keyspace);
        return ksm == null ? Optional.empty() : ksm.functions.find(name, argTypes);
    }

    public UUID getVersion() {
        return this.version;
    }

    public void updateVersion() {
        this.version = SchemaKeyspace.calculateSchemaDigest();
        SystemKeyspace.updateSchemaVersion(this.version);
    }

    public void updateVersionAndAnnounce() {
        this.updateVersion();
        MigrationManager.passiveAnnounce(this.version);
    }

    public synchronized void clear() {
        for (String keyspaceName : this.getNonSystemKeyspaces()) {
            KeyspaceMetadata ksm = this.getKSMetaData(keyspaceName);
            ksm.tables.forEach(this::unload);
            ksm.views.forEach(this::unload);
            this.clearKeyspaceMetadata(ksm);
        }
        this.updateVersionAndAnnounce();
    }

    public void addKeyspace(KeyspaceMetadata ksm) {
        assert (this.getKSMetaData(ksm.name) == null);
        this.load(ksm);
        Keyspace.open(ksm.name);
        MigrationManager.instance.notifyCreateKeyspace(ksm);
    }

    public void updateKeyspace(String ksName, KeyspaceParams newParams) {
        KeyspaceMetadata ksm = this.update(ksName, ks -> ks.withSwapped(newParams));
        MigrationManager.instance.notifyUpdateKeyspace(ksm);
    }

    public void dropKeyspace(String ksName) {
        KeyspaceMetadata ksm = instance.getKSMetaData(ksName);
        String snapshotName = Keyspace.getTimestampedSnapshotName(ksName);
        CompactionManager.instance.interruptCompactionFor(ksm.tablesAndViews(), true);
        Keyspace keyspace = Keyspace.open(ksm.name);
        ArrayList<UUID> droppedCfs = new ArrayList<UUID>();
        for (CFMetaData cfm : ksm.tablesAndViews()) {
            ColumnFamilyStore cfs = keyspace.getColumnFamilyStore(cfm.cfName);
            this.unload(cfm);
            if (DatabaseDescriptor.isAutoSnapshot()) {
                cfs.snapshot(snapshotName);
            }
            Keyspace.open(ksm.name).dropCf(cfm.cfId);
            droppedCfs.add(cfm.cfId);
        }
        Keyspace.clear(ksm.name);
        this.clearKeyspaceMetadata(ksm);
        Keyspace.writeOrder.awaitNewBarrier();
        CommitLog.instance.forceRecycleAllSegments(droppedCfs);
        MigrationManager.instance.notifyDropKeyspace(ksm);
    }

    public void addTable(CFMetaData cfm) {
        assert (this.getCFMetaData(cfm.ksName, cfm.cfName) == null);
        this.update(cfm.ksName, ks -> {
            this.load(cfm);
            Keyspace.open(cFMetaData.ksName);
            return ks.withSwapped(ks.tables.with(cfm));
        });
        Keyspace.open(cfm.ksName).initCf(cfm.cfId, cfm.cfName, true);
        MigrationManager.instance.notifyCreateColumnFamily(cfm);
    }

    public void updateTable(String ksName, String tableName) {
        CFMetaData cfm = this.getCFMetaData(ksName, tableName);
        assert (cfm != null);
        boolean columnsDidChange = cfm.reload();
        Keyspace keyspace = Keyspace.open(cfm.ksName);
        keyspace.getColumnFamilyStore(cfm.cfName).reload();
        MigrationManager.instance.notifyUpdateColumnFamily(cfm, columnsDidChange);
    }

    public void dropTable(String ksName, String tableName) {
        KeyspaceMetadata oldKsm = this.getKSMetaData(ksName);
        assert (oldKsm != null);
        ColumnFamilyStore cfs = Keyspace.open(ksName).getColumnFamilyStore(tableName);
        assert (cfs != null);
        cfs.indexManager.markAllIndexesRemoved();
        CFMetaData cfm = oldKsm.tables.get(tableName).get();
        KeyspaceMetadata newKsm = oldKsm.withSwapped(oldKsm.tables.without(tableName));
        this.unload(cfm);
        this.setKeyspaceMetadata(newKsm);
        CompactionManager.instance.interruptCompactionFor(Collections.singleton(cfm), true);
        if (DatabaseDescriptor.isAutoSnapshot()) {
            cfs.snapshot(Keyspace.getTimestampedSnapshotName(cfs.name));
        }
        Keyspace.open(ksName).dropCf(cfm.cfId);
        MigrationManager.instance.notifyDropColumnFamily(cfm);
        CommitLog.instance.forceRecycleAllSegments(Collections.singleton(cfm.cfId));
    }

    public void addView(ViewDefinition view) {
        assert (this.getCFMetaData(view.ksName, view.viewName) == null);
        this.update(view.ksName, ks -> {
            this.load(view);
            Keyspace.open(viewDefinition.ksName);
            return ks.withSwapped(ks.views.with(view));
        });
        Keyspace.open(view.ksName).initCf(view.metadata.cfId, view.viewName, true);
        Keyspace.open((String)view.ksName).viewManager.reload();
        MigrationManager.instance.notifyCreateView(view);
    }

    public void updateView(String ksName, String viewName) {
        Optional<ViewDefinition> optView = this.getKSMetaData((String)ksName).views.get(viewName);
        assert (optView.isPresent());
        ViewDefinition view = optView.get();
        boolean columnsDidChange = view.metadata.reload();
        Keyspace keyspace = Keyspace.open(view.ksName);
        keyspace.getColumnFamilyStore(view.viewName).reload();
        Keyspace.open((String)view.ksName).viewManager.update(view.viewName);
        MigrationManager.instance.notifyUpdateView(view, columnsDidChange);
    }

    public void dropView(String ksName, String viewName) {
        KeyspaceMetadata oldKsm = this.getKSMetaData(ksName);
        assert (oldKsm != null);
        ColumnFamilyStore cfs = Keyspace.open(ksName).getColumnFamilyStore(viewName);
        assert (cfs != null);
        cfs.indexManager.markAllIndexesRemoved();
        ViewDefinition view = oldKsm.views.get(viewName).get();
        KeyspaceMetadata newKsm = oldKsm.withSwapped(oldKsm.views.without(viewName));
        this.unload(view);
        this.setKeyspaceMetadata(newKsm);
        CompactionManager.instance.interruptCompactionFor(Collections.singleton(view.metadata), true);
        if (DatabaseDescriptor.isAutoSnapshot()) {
            cfs.snapshot(Keyspace.getTimestampedSnapshotName(cfs.name));
        }
        Keyspace.open(ksName).dropCf(view.metadata.cfId);
        Keyspace.open((String)ksName).viewManager.reload();
        MigrationManager.instance.notifyDropView(view);
        CommitLog.instance.forceRecycleAllSegments(Collections.singleton(view.metadata.cfId));
    }

    public void addType(UserType ut) {
        this.update(ut.keyspace, ks -> ks.withSwapped(ks.types.with(ut)));
        MigrationManager.instance.notifyCreateUserType(ut);
    }

    public void updateType(UserType ut) {
        this.update(ut.keyspace, ks -> ks.withSwapped(ks.types.without(userType.name).with(ut)));
        MigrationManager.instance.notifyUpdateUserType(ut);
    }

    public void dropType(UserType ut) {
        this.update(ut.keyspace, ks -> ks.withSwapped(ks.types.without(userType.name)));
        MigrationManager.instance.notifyDropUserType(ut);
    }

    public void addFunction(UDFunction udf) {
        this.update(udf.name().keyspace, ks -> ks.withSwapped(ks.functions.with(udf)));
        MigrationManager.instance.notifyCreateFunction(udf);
    }

    public void updateFunction(UDFunction udf) {
        this.update(udf.name().keyspace, ks -> ks.withSwapped(ks.functions.without(udf.name(), udf.argTypes()).with(udf)));
        MigrationManager.instance.notifyUpdateFunction(udf);
    }

    public void dropFunction(UDFunction udf) {
        this.update(udf.name().keyspace, ks -> ks.withSwapped(ks.functions.without(udf.name(), udf.argTypes())));
        MigrationManager.instance.notifyDropFunction(udf);
    }

    public void addAggregate(UDAggregate uda) {
        this.update(uda.name().keyspace, ks -> ks.withSwapped(ks.functions.with(uda)));
        MigrationManager.instance.notifyCreateAggregate(uda);
    }

    public void updateAggregate(UDAggregate uda) {
        this.update(uda.name().keyspace, ks -> ks.withSwapped(ks.functions.without(uda.name(), uda.argTypes()).with(uda)));
        MigrationManager.instance.notifyUpdateAggregate(uda);
    }

    public void dropAggregate(UDAggregate uda) {
        this.update(uda.name().keyspace, ks -> ks.withSwapped(ks.functions.without(uda.name(), uda.argTypes())));
        MigrationManager.instance.notifyDropAggregate(uda);
    }

    private synchronized KeyspaceMetadata update(String keyspaceName, Function<KeyspaceMetadata, KeyspaceMetadata> transformation) {
        KeyspaceMetadata current = this.getKSMetaData(keyspaceName);
        if (current == null) {
            throw new IllegalStateException(String.format("Keyspace %s doesn't exist", keyspaceName));
        }
        KeyspaceMetadata transformed = transformation.apply(current);
        this.setKeyspaceMetadata(transformed);
        return transformed;
    }

    static {
        try {
            emptyVersion = UUID.nameUUIDFromBytes(MessageDigest.getInstance("MD5").digest());
        }
        catch (NoSuchAlgorithmException e) {
            throw new AssertionError();
        }
    }
}

